// This code is (C) 1999 Bill Welliver <hww3@riverweb.com>
// It can be freely distributed and copied under the terms of the
// GNU General Public License, version 2 or later.
// This code comes with NO WARRANTY of any kind, either implicit or explicit.

string cvs_version="$Id: NTuserauth.pike,v 1.1 1999/03/29 16:54:23 hww3 Exp $";

#include <module.h>
inherit "roxenlib";
inherit "module";

// #define AUTHDEBUG 0

#ifdef AUTHDEBUG
#define DEBUGLOG(X) perror("NTauth: "+X+"\n");
#else
#define DEBUGLOG(X) /**/
#endif

int att=0, succ=0, nouser=0;
string domain,primary,backup;

void create() 
{
	defvar ("domain", "", "Default Domain", TYPE_STRING,
			"The default NT Domain to Authenticate against."
			);
	defvar ("primary", "", "Primary Logon Server", TYPE_STRING,
			"The first NT server to contact for authentication."
			);
	defvar ("backup", "", "Secondary Logon Server", TYPE_STRING,
			"The backup NT server to contact for authentication."
			);
	defvar ("defaultuid",geteuid(),"Default User ID", TYPE_INT,
			"User IDs don't have much meaning in this module's scope. However, "
			"some modules require an user ID to work correctly. This is the "
			"user ID which will be returned to all such requests."
			);
	defvar ("defaultgid", getegid(), "Default Group ID", TYPE_INT,
			"Same as User ID, only it refers rather to the group."
			);
	defvar ("defaultgecos", "", "Default Gecos", TYPE_STRING,
			"The default Gecos."
			);
	defvar ("defaulthome","/", "Default user Home Directory", TYPE_DIR, 
			"It is possible (but not mandatory) to specify an user's home "
			"directory in the passwords database. This is used if it's "
			"not provided. (<B>Not implemented yet</B>, it always uses this value)"
			);
	defvar ("defaultshell", "/bin/sh", "Default user Login Shell", TYPE_FILE,
			"Same as the default home, only referring to the user's login shell."
			" (<B>Not implemented yet</B>, it always uses this value)"
			);
}


void start()
{
  domain=query("domain");
  primary=query("primary");
  backup=query("backup");
}

/*
 * Module Callbacks
 */

array|int auth (string *auth, object id)
{
	string u,p,udomain;
	mixed err;
        int result;

	att++;
	DEBUGLOG (sprintf("auth(%O)",auth)-"\n");

	sscanf (auth[1],"%s:%s",u,p);

	if (!p||!strlen(p)) {
		DEBUGLOG ("no password supplied by the user");
		return ({0, auth[1], -1});
	}

        if (!u||!strlen(u)) {
                DEBUGLOG ("no username supplied by the user");
                return ({0, auth[1], -1});
        }

        if (search(u, "/")!=-1) {  // we have a domain/user string...
                array temp=u/"/";
                u=temp[1];
                udomain=temp[0];                
        }
        else udomain=domain;

	DEBUGLOG ("SMBAuth.auth(" + u + ", " + p + ", " + primary + ", " +
		backup + ", " + udomain +  ")"); 
//        perror(sprintf("%O", indices(SMBAuth)));
#if constant(SMBAuth)
        result=SMBAuth.auth(u, p, primary, backup, udomain);
#endif
#if !constant(SMBAuth)
	result=4;
#endif         
        if(result==0) {
	DEBUGLOG (u+" positively recognized");
	succ++;
	return ({1,u,0});
        }

        else {
        DEBUGLOG ("SMBAuth Returned " + result + "\n");
        return ({0, auth[1], -1});
        }
}

/*
 * Support Callbacks
 */
string status() {
	return "<H2>Security info</H2>"
			"Attempted authentications: "+att+"<BR>\n"
			"Failed: "+(att-succ+nouser)
			;
}

array register_module() {
	return ({
	MODULE_AUTH,
	"NT user authentication",
	"This module implements user authentication via NT/SMB.<p>\n"
	"&copy; 1997 Bill Welliver, distributed freely under GPL license."
#if !constant(SMBAuth)
	"<p>You must have the SMBAuth Pike Module installed, which may be "
	"found at <a href=\"http://hww3.riverweb.com/smbauth\">http://hww3.riverweb.com/smbauth</a>."
	"<p>Please install this module and restart Roxen. For your protection, "
	"Roxen will fail all authentication attempts until the module is "
	"installed.
#endif
	,
	0,
	1
	});
};
