#include <iostream>
#include <fstream>
#ifdef QWT_QTOPIA
#include <qpe/qpeapplication.h>
#endif
#include <qapplication.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qfont.h>
#include <qlabel.h>
#include <qwt_thermo.h>
#include <qwt_math.h>

class Thermo: public QVBox
{
public:
   Thermo(const QString &text, const QColor &color, QWidget *parent):
      QVBox(parent)
   {
      d_thermo = new QwtThermo(this);

      d_thermo->setOrientation(Qt::Vertical, QwtThermo::Right);
      d_thermo->setRange(0.0,1.0);
      d_thermo->setValue(1.0);
      d_thermo->setBorderWidth(1);
      d_thermo->setPipeWidth(4);
      d_thermo->setFont(QFont("Helvetica",10));
      d_thermo->setScaleMaxMajor(6);
       d_thermo->setFillColor(color);

      QLabel *label = new QLabel(text, this);
      label->setAlignment(Qt::AlignLeft|Qt::AlignVCenter);
   }

    void setRange(double vmin, double vmax) 
      { d_thermo->setRange(vmin, vmax); }
    void setValue(double val) { d_thermo->setValue(val); }
    double maxValue() { return d_thermo->maxValue(); }

private:
   QwtThermo *d_thermo;
};

class MainWin : public QHBox 
{
public:
    MainWin();

protected:
    virtual void timerEvent(QTimerEvent *e);
    void updateThermo();

private:
    Thermo *t1;
    Thermo *t2;
    Thermo *t3;
};

MainWin::MainWin() 
{
    t1 = new Thermo("1 min", Qt::darkRed, this);
    t2 = new Thermo("10 min", Qt::darkGreen, this);
    t3 = new Thermo("15 min", Qt::darkBlue, this);
    
    (void)startTimer(2000);
}

void MainWin::timerEvent(QTimerEvent *)
{
    updateThermo();
}

//---------------------------------------
// MainWin::update()
//
//  read values from /proc/loadavg
//  and display them. Adjust thermometer scales
//  if necessary.
//---------------------------------------
void MainWin::updateThermo()
{
    double v1, v2, v3;
    static double vmin = 0.1;
    double vmax, vnew;
    
    std::ifstream inp("/proc/loadavg");
    inp >> v1 >> v2 >> v3;

    // adjust and synchronize ranges
    vmax = qwtCeil125(qwtMax(qwtMax(qwtMax(v1,v2),v3),vmin));

    if ( (vmax > t1->maxValue()) 
        || (vmax < 0.25 * t1->maxValue()) )
    {
        vnew = vmax;
        t1->setRange(0.0, vnew);
        t2->setRange(0.0, vnew);
        t3->setRange(0.0, vnew);
    }

    // set values
    t1->setValue(v1);
    t2->setValue(v2);
    t3->setValue(v3);
}

int main (int argc, char **argv)
{
#ifdef QWT_QTOPIA
    QPEApplication a(argc, argv);
#else
    QApplication a(argc, argv);
#endif

    MainWin w;
    a.setMainWidget(&w);

    w.setCaption("load average");
    w.show();
    
    return a.exec();
}
