/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  memoryhandler.cc - C++ Memory handler implementation.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "memoryhandler.h"
#include <algorithm>

using namespace Inti;

/*  Static members
 */
 
MemoryHandler::AllocationList MemoryHandler::allocation_list;
std::new_handler MemoryHandler::current_handler;

/*  MemoryHandler::AllocationList
 */

MemoryHandler::AllocationList::AllocationList()
{
}

MemoryHandler::AllocationList::~AllocationList()
{
	iterator i = begin();
	while (i != end())
	{
		::operator delete (*i);
		++i;
	}
	clear();
}

/*  MemoryHandler
 */

MemoryHandler::MemoryHandler()
{
}

MemoryHandler::~MemoryHandler()
{
}

std::new_handler
MemoryHandler::set_new_handler(std::new_handler handler)
{
	std::new_handler old_handler = current_handler;
	current_handler = handler;
	return old_handler;
}

void* 
MemoryHandler::operator new(size_t size)
{	
	// Set the new_handler for this call
	std::new_handler global_handler  = std::set_new_handler(current_handler);
	
	// If allocation fails current_handler is called, if specified, otherwise the global new_handler is called.
	void *ptr;
			
	try	 
	{
		ptr = ::operator new(size);
		allocation_list.push_front(ptr);
	}
	catch(std::bad_alloc&)
	{
		std::set_new_handler(global_handler);
		throw;
	}
	
	//  Reset gloabal new_handler
	std::set_new_handler(global_handler);
	return ptr;
}

void
MemoryHandler::operator delete(void *ptr)
{
	AllocationList::iterator i = std::find(allocation_list.begin(), allocation_list.end(), ptr);
	if (i != allocation_list.end())
	{
		allocation_list.erase(i);
		::operator delete(ptr);
	}
}

bool
MemoryHandler::is_dynamic() const
{
	// Get pointer to beginning of the memory occupied by this.
	const void* ptr = dynamic_cast<const void*>(this);
	
	// Search for ptr in allocation_list
	AllocationList::iterator i = std::find(allocation_list.begin(), allocation_list.end(), ptr);
	return i != allocation_list.end();
}

