/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  radiomenuitem.cc - GtkRadioMenuItem C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "radiomenuitem.h"
#include "private/radiomenuitem_p.h"

using namespace Inti;

/*  Gtk::RadioMenuItem
 */

Gtk::RadioMenuItem::RadioMenuItem(GtkRadioMenuItem *radio_menu_item, bool reference)
: CheckMenuItem((GtkCheckMenuItem*)radio_menu_item, reference)
{
}

Gtk::RadioMenuItem::RadioMenuItem()
: CheckMenuItem((GtkCheckMenuItem*)RadioMenuItemClass::create())
{
}

Gtk::RadioMenuItem::RadioMenuItem(Group *group)
: CheckMenuItem((GtkCheckMenuItem*)RadioMenuItemClass::create())
{
	set_group(group);
}

Gtk::RadioMenuItem::RadioMenuItem(const RadioMenuItem *group)
: CheckMenuItem((GtkCheckMenuItem*)RadioMenuItemClass::create())
{
	set_group(group->get_group());
}

Gtk::RadioMenuItem::RadioMenuItem(const String& label, bool use_underline)
: CheckMenuItem((GtkCheckMenuItem*)RadioMenuItemClass::create())
{
	add_label(label, use_underline);
}

Gtk::RadioMenuItem::RadioMenuItem(Group *group, const String& label, bool use_underline)
: CheckMenuItem((GtkCheckMenuItem*)RadioMenuItemClass::create())
{
	set_group(group);
	add_label(label, use_underline);
}

Gtk::RadioMenuItem::RadioMenuItem(const RadioMenuItem *group, const String& label, bool use_underline)
: CheckMenuItem((GtkCheckMenuItem*)RadioMenuItemClass::create())
{
	set_group(group->get_group());
	add_label(label, use_underline);
}

Gtk::RadioMenuItem::~RadioMenuItem()
{
}

GtkRadioMenuItemClass* 
Gtk::RadioMenuItem::gtk_radio_menu_item_class() const
{ 
	return get_class<GtkRadioMenuItemClass>();
}

Gtk::RadioMenuItem::operator GtkRadioMenuItem* () const 
{
	return this ? gtk_radio_menu_item() : 0; 
}
	
Gtk::RadioMenuItem::Group*
Gtk::RadioMenuItem::get_group() const
{
	return gtk_radio_menu_item_get_group(gtk_radio_menu_item());
}

void
Gtk::RadioMenuItem::set_group(Group *group)
{
	gtk_radio_menu_item_set_group(gtk_radio_menu_item(), group);
}

/*  Gtk::RadioMenuItemClass
 */

void
Gtk::RadioMenuItemClass::init(GtkRadioMenuItemClass *g_class)
{
	CheckMenuItemClass::init((GtkCheckMenuItemClass*)g_class);
}

GType
Gtk::RadioMenuItemClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_RADIO_MENU_ITEM, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::RadioMenuItemClass::create()
{
	return g_object_new(get_type(), 0);
}

