/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  itemfactory.cc - GtkItemFactory C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "itemfactory.h"
#include "private/itemfactory_p.h"
#include "widget.h"
#include "menubar.h"
#include "menu.h"
#include "optionmenu.h"
#include "checkmenuitem.h"
#include "accelgroup.h"
#include "../gdk/types.h"
#include "../glib/scanner.h"

using namespace Inti;

/*  Gtk::ItemFactory
 */

Gtk::ItemFactory::ItemFactory(GtkItemFactory *item_factory, bool reference)
: Object((GtkObject*)item_factory, reference)
{
}
	
Gtk::ItemFactory::ItemFactory()
: Object((GtkObject*)ItemFactoryClass::create(), true)
{
	gtk_item_factory_construct(gtk_item_factory(), GTK_TYPE_MENU_BAR, "<main>", 0);
}

Gtk::ItemFactory::ItemFactory(GtkType container_type, const char* path, AccelGroup *accel_group)
: Object((GtkObject*)ItemFactoryClass::create(), true)
{
	gtk_item_factory_construct(gtk_item_factory(), container_type, path, *accel_group);
}

Gtk::ItemFactory::~ItemFactory()
{
}
	
GtkItemFactoryClass* 
Gtk::ItemFactory::gtk_item_factory_class() const
{ 
	return get_class<GtkItemFactoryClass>(); 
}
	
Gtk::ItemFactory::operator GtkItemFactory* () const 
{ 
	return this ? gtk_item_factory() : 0; 
}
	
Gtk::AccelGroup*
Gtk::ItemFactory::accel_group() const
{
	return G::Object::wrap<AccelGroup>(gtk_item_factory()->accel_group);
}

Gtk::MenuBar*
Gtk::ItemFactory::menu_bar() const
{
	GtkWidget *widget = gtk_item_factory()->widget;
	return GTK_IS_MENU_BAR(widget) ?  G::Object::wrap<MenuBar>((GtkMenuBar*)widget) : 0;
}

Gtk::Menu*
Gtk::ItemFactory::menu() const
{
	GtkWidget *widget = gtk_item_factory()->widget;
	return GTK_IS_MENU(widget) ?  G::Object::wrap<Menu>((GtkMenu*)widget) : 0;
}

Gtk::OptionMenu*
Gtk::ItemFactory::option_menu() const
{
	GtkWidget *widget = gtk_item_factory()->widget;
	return GTK_IS_OPTION_MENU(widget) ?  G::Object::wrap<OptionMenu>((GtkOptionMenu*)widget) : 0;
}

Gtk::Menu*
Gtk::ItemFactory::submenu(const char* path) const
{
	GtkWidget *widget = gtk_item_factory_get_widget(gtk_item_factory(), path);
	return GTK_IS_MENU(widget) ? G::Object::wrap<Menu>((GtkMenu*)widget) : 0;
}

Gtk::Menu*
Gtk::ItemFactory::submenu_by_action(unsigned int action) const
{
	GtkWidget *widget = gtk_item_factory_get_widget_by_action(gtk_item_factory(), action);
	return GTK_IS_MENU(widget) ? G::Object::wrap<Menu>((GtkMenu*)widget) : 0;
}

Gtk::MenuItem*
Gtk::ItemFactory::get_item(const char *path) const
{
	return G::Object::wrap<MenuItem>((GtkMenuItem*)gtk_item_factory_get_item(gtk_item_factory(), path));
}

Gtk::MenuItem*
Gtk::ItemFactory::get_item_by_action(unsigned int action) const
{
	return G::Object::wrap<MenuItem>((GtkMenuItem*)gtk_item_factory_get_item_by_action(gtk_item_factory(), action));
}

String
Gtk::ItemFactory::path_from_widget(const Widget& widget)
{
	return gtk_item_factory_path_from_widget(widget.gtk_widget());
}

String
Gtk::ItemFactory::path_from_entry(const char *entry_path)
{
	int length = strlen(entry_path);
	char *s = new char[length];
	char *p = s;
	while (*entry_path)
	{
		if (*entry_path == '_')
			entry_path++;
		*s++ = *entry_path++;
	}
	*s = '\0';
	String path = p;
	delete p;
	return path;
}

void
Gtk::ItemFactory::delete_item(const char *path)
{
	gtk_item_factory_delete_item(gtk_item_factory(), path);
}
	
namespace { // popup_destroy_callback

void popup_destroy_callback(gpointer data)
{
	Gtk::ItemFactory::DestroySlot *slot = static_cast<Gtk::ItemFactory::DestroySlot*>(data);
	slot->call();
}
	
} // popup_destroy_callback

void 
Gtk::ItemFactory::popup(unsigned int x, unsigned int y, unsigned int mouse_button, const DestroySlot *destroy, unsigned int time)
{
	gtk_item_factory_popup_with_data(gtk_item_factory(), (void*)destroy, &popup_destroy_callback, x, y, mouse_button, time);
}

void 
Gtk::ItemFactory::popup(unsigned int x, unsigned int y, unsigned int mouse_button, unsigned int time)
{
	gtk_item_factory_popup_with_data(gtk_item_factory(), 0, 0, x, y, mouse_button, time);
}

Gtk::ItemFactory*
Gtk::ItemFactory::from_widget(const Widget& widget)
{
	return G::Object::wrap<ItemFactory>(gtk_item_factory_from_widget(widget.gtk_widget()));
}

/*  Gtk::ItemFactoryClass
 */

void
Gtk::ItemFactoryClass::init(GtkItemFactoryClass *g_class)
{
	ObjectClass::init((GtkObjectClass*)g_class);
}

GType
Gtk::ItemFactoryClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ITEM_FACTORY, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::ItemFactoryClass::create()
{
	return g_object_new(get_type(), 0);
}


