/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  fixed.cc - GtkFixed C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "fixed.h"
#include "private/fixed_p.h"

using namespace Inti;

/*  Gtk::Fixed
 */

Gtk::Fixed::Fixed(GtkFixed *fixed, bool reference)
: Container((GtkContainer*)fixed, reference)
{
}

Gtk::Fixed::Fixed() 
: Container((GtkContainer*)FixedClass::create())
{
}

Gtk::Fixed::~Fixed()
{
}

GtkFixedClass* 
Gtk::Fixed::gtk_fixed_class() const 
{
	return get_class<GtkFixedClass>(); 
}
	
Gtk::Fixed::operator GtkFixed* () const 
{ 
	return this ? gtk_fixed() : 0; 
}
	
bool
Gtk::Fixed::get_has_window() const
{
	return gtk_fixed_get_has_window(gtk_fixed());
}

void
Gtk::Fixed::put(Widget& widget, int x, int y)
{
	gtk_fixed_put(gtk_fixed(), widget.gtk_widget(), x, y);
}

void
Gtk::Fixed::move(Widget& widget, int x, int y)
{
	gtk_fixed_move(gtk_fixed(), widget.gtk_widget(), x, y);
}

void
Gtk::Fixed::set_has_window(bool has_window)
{
	gtk_fixed_set_has_window(gtk_fixed(), has_window);
}

/*  Gtk::FixedClass
 */

void
Gtk::FixedClass::init(GtkFixedClass *g_class)
{
	ContainerClass::init((GtkContainerClass*)g_class);
}

GType
Gtk::FixedClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_FIXED, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::FixedClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Child properties
 */

const Gtk::Fixed::XPropertyType Gtk::Fixed::x_property("x");

const Gtk::Fixed::YPropertyType Gtk::Fixed::y_property("y");

