/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  accellabel.cc - GtkAccelLabel C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "accellabel.h"
#include "private/accellabel_p.h"

using namespace Inti;

/*  Gtk::AccelLabel
 */

Gtk::AccelLabel::AccelLabel(GtkAccelLabel *accel_label, bool reference)
: Label((GtkLabel*)accel_label, reference)
{
}

Gtk::AccelLabel::AccelLabel()
: Label((GtkLabel*)AccelLabelClass::create())
{
}

Gtk::AccelLabel::AccelLabel(const String& str, bool use_underline)
: Label((GtkLabel*)AccelLabelClass::create())
{
	set_text(str.c_str());
	set_use_underline(use_underline);
}

Gtk::AccelLabel::~AccelLabel()
{
}

GtkAccelLabelClass* 
Gtk::AccelLabel::gtk_accel_label_class() const
{ 
	return get_class<GtkAccelLabelClass>(); 
}
	
Gtk::AccelLabel::operator GtkAccelLabel* () const
{
	return this ? gtk_accel_label() : 0;
}
	
Gtk::Widget*
Gtk::AccelLabel::get_accel_widget() const
{
	return G::Object::wrap<Widget>(gtk_accel_label_get_accel_widget(gtk_accel_label()));
}

unsigned int
Gtk::AccelLabel::get_accel_width() const
{
	return gtk_accel_label_get_accel_width(gtk_accel_label());
}

void
Gtk::AccelLabel::set_accel_widget(Widget& accel_widget)
{
	gtk_accel_label_set_accel_widget(gtk_accel_label(), accel_widget.gtk_widget());
}

void
Gtk::AccelLabel::set_accel_closure(GClosure *accel_closure)
{
	gtk_accel_label_set_accel_closure(gtk_accel_label(), accel_closure);
}

bool
Gtk::AccelLabel::refetch()
{
	return gtk_accel_label_refetch(gtk_accel_label());
}

/*  Gtk::AccelLabelClass
 */

void
Gtk::AccelLabelClass::init(GtkAccelLabelClass *g_class)
{
	LabelClass::init((GtkLabelClass*)g_class);
}

GType
Gtk::AccelLabelClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ACCEL_LABEL, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::AccelLabelClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Properties
 */

const Gtk::AccelLabel::AccelClosurePropertyType Gtk::AccelLabel::accel_closure_property("accel_closure");

const Gtk::AccelLabel::AccelWidgetPropertyType Gtk::AccelLabel::accel_widget_property("accel_widget");

