/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  component_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_ATK_COMPONENT_IFACE_H
#define INTI_ATK_COMPONENT_IFACE_H

namespace Inti {

namespace Atk {

class ComponentIface
{
public:
	static void init(AtkComponentIface *g_iface);

	static guint add_focus_handler_proxy(AtkComponent *component, AtkFocusHandler handler);

	static gboolean contains_proxy(AtkComponent *component, gint x, gint y, AtkCoordType coord_type);

	static AtkObject* ref_accessible_at_point_proxy(AtkComponent *component, gint x, gint y, AtkCoordType coord_type);

	static void get_extents_proxy(AtkComponent *component, gint *x, gint *y, gint *width, gint *height, AtkCoordType coord_type);

	static void get_position_proxy(AtkComponent *component, gint *x, gint *y, AtkCoordType coord_type);

	static void get_size_proxy(AtkComponent *component, gint *width, gint *height);

	static gboolean grab_focus_proxy(AtkComponent *component);

	static void remove_focus_handler_proxy(AtkComponent *component, guint handler_id);

	static gboolean set_extents_proxy(AtkComponent *component, gint  x, gint y, gint width, gint height, AtkCoordType coord_type);

	static gboolean set_position_proxy(AtkComponent *component, gint  x, gint y, AtkCoordType coord_type);

	static gboolean set_size_proxy(AtkComponent *component, gint width, gint height);

	static AtkLayer get_layer_proxy(AtkComponent *component);

	static gint get_mdi_zorder_proxy(AtkComponent *component);
};

} // namespace Atk

} // namespace Inti

#endif // INTI_ATK_COMPONENT_IFACE_H
