dnl as-scrub-include.m4 0.0.1
dnl autostars m4 macro for scrubbing CFLAGS of system include dirs
dnl because gcc 3.x complains about including system including dirs
dnl
dnl thomas@apestaart.org
dnl
dnl This macro uses output of cpp -v and expects it to contain text that 
dnl looks a little bit like this:
dnl #include <...> search starts here:
dnl  /usr/local/include
dnl  /usr/lib/gcc-lib/i386-redhat-linux/3.2/include
dnl  /usr/include
dnl End of search list.

dnl AS_SCRUB_INCLUDE(VAR)
dnl example
dnl AS_SCRUB_INCLUDE(CFLAGS)
dnl will remove all system include dirs from the given CFLAGS

AC_DEFUN(AS_SCRUB_INCLUDE,
[
  GIVEN_CFLAGS=$[$1]
  INCLUDE_DIRS=`echo | cpp -v 2>&1`

  dnl remove everything from this output between the "starts here" and "End of"
  dnl line
  INCLUDE_DIRS=`echo $INCLUDE_DIRS | sed -e 's/.*<...> search starts here://' | sed -e 's/End of search list.*//'`
  for dir in $INCLUDE_DIRS; do
    GIVEN_CFLAGS=$(echo $GIVEN_CFLAGS | sed -e "s;-I$dir ;;" | sed -e "s;-I$dir$;;")
  done
  [$1]=$GIVEN_CFLAGS
])
# $Id: chameleon.m4,v 1.9 2003/04/20 18:32:23 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# This function checks for libchameleon


AC_DEFUN(AQ_CHAMELEON_INCLUDED,[
dnl PREREQUISITES:
dnl   - AQ_CHECK_OS must already have been called
dnl   - AC_CHECK_HEADER(syslog.h) must have been called
dnl IN: 
dnl   - path and name of Chameleon (without trailing "/chameleon")
dnl     (e.g. src/libchipcard)
dnl OUT:
dnl   Variables:
dnl     chameleon_needed_libs: libraries libchameleon needs (subst)
dnl     chameleon_includes:    CFLAGS for chameleon includes (subst)
dnl     chameleon_libs:        LDADD/LIBADD instructions for chameleon (subst)

AC_MSG_CHECKING(for included chameleon)
case "$OS_TYPE" in
 windows)
  chameleon_needed_libs="-L/c/windows -lwsock32"
  cp ${srcdir}/$1/chameleon/windows/*.c ${srcdir}/$1/chameleon/
  cp ${srcdir}/$1/chameleon/windows/*.h ${srcdir}/$1/chameleon/
  ;;
 posix)
  cp ${srcdir}/$1/chameleon/posix/*.c ${srcdir}/$1/chameleon/
  cp ${srcdir}/$1/chameleon/posix/*.h ${srcdir}/$1/chameleon/
  ;;
esac
AC_SUBST(chameleon_needed_libs)
chameleon_includes="-I\${top_srcdir}/$1"
chameleon_libs="\${top_builddir}/$1/chameleon/libchameleon.la"
AS_SCRUB_INCLUDE(chameleon_includes)
AC_SUBST(chameleon_includes)
AC_SUBST(chameleon_libs)

AC_MSG_RESULT([ok (includes=$chameleon_includes)])
])

# $Id: debug.m4,v 1.1 2002/12/16 04:39:24 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# This function checks for some debug settings


AC_DEFUN(AQ_CHECK_DEBUG,[
dnl PREREQUISITES:
dnl   none
dnl IN: 
dnl   nothing
dnl OUT:
dnl   Variables:
dnl     have_func
dnl   Defines:
dnl     HAVE_FUNC defined if "__func__" is available

AC_MSG_CHECKING(for debug settings)
    AC_TRY_COMPILE([#include <stdio.h>],[
   int main(int argc, char **argv) {
      fprintf(stderr,"%s",__func__);
      return 0;
   }
   ],
   [  
      have_func="yes"
      AC_DEFINE(HAVE_FUNC)
   ],
   [
     have_func="no"
   ],
 )

AC_SUBST(have_func)
AC_MSG_RESULT(ok)
])




# $Id: debugmode.m4,v 1.1.1.1 2002/10/10 16:36:23 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# This function checks for the debugmode


AC_DEFUN(AQ_DEBUGMODE,[
dnl IN: 
dnl   nothing
dnl OUT:
dnl   Variables:
dnl     DEBUGMODE: number of the debug level (subst)
dnl   Defines:
dnl     DEBUGMODE: number of the debug level (subst)

dnl check for debugmode
AC_MSG_CHECKING(for debug mode)
AC_ARG_WITH(debug-mode,
  [  --with-debug-mode=MODE  debug mode],
  [DEBUGMODE="$withval"],
  [DEBUGMODE="0"])
AC_SUBST(DEBUGMODE)
AC_DEFINE_UNQUOTED(DEBUGMODE,$DEBUGMODE)
AC_MSG_RESULT($DEBUGMODE)
])
# $Id: docpath.m4,v 1.1.1.1 2002/10/10 16:36:23 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# This function checks for the output path for the documentation

AC_DEFUN(AQ_DOCPATH,[
dnl PREREQUISITES:
dnl   none
dnl IN: 
dnl   nothing
dnl OUT:
dnl   Variables:
dnl     docpath: Output path for the documentation (subst)
dnl   Defines:

# check for docpath
AC_MSG_CHECKING(for docpath)
AC_ARG_WITH(docpath, [  --with-docpath=DIR      where to store the apidoc],
  [docpath="$withval"],
  [docpath="apidoc"])
AC_SUBST(docpath)
AC_MSG_RESULT($docpath)
])
# $Id: kde2.m4,v 1.2 2003/03/31 01:49:44 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# These functions search for KDE 2


AC_DEFUN(AQ_CHECK_KDE2,[
dnl PREREQUISITES:
dnl   none
dnl IN: 
dnl   $1 = "yes" if KDE2 is needed, "no" if KDE2 is optional
dnl   $2 = subdirs to include when KDE2 is available
dnl   You may preset the return variables.
dnl   All variables which already have a value will not be altered
dnl OUT:
dnl   Variables:
dnl     have_kde2 - set to "yes" if KDE2 exists
dnl     kde2_includes - CFLAGS for includes (-I)
dnl     kde2_include_dir - path to includes
dnl     kde2_libs - LDFLAGS for linking the kde3 libraries (-L)
dnl     kde2_app - kde2 apps given as the argument to this funtion
dnl     kde2_install_dir - install directory for kde3 applications
dnl   Defines:
dnl     HAVE_KDE2
dnl USED MACROS:
dnl  AQ_CHECK_QT2


kde2_local_lforce="$1"
kde2_local_lsd="$2"

AC_MSG_CHECKING(if KDE2 is allowed)
AC_ARG_ENABLE(kde2,
  [  --enable-kde2         enable kde2 (default=yes)],
  enable_kde2="$enableval",
  enable_kde2="yes")
AC_MSG_RESULT($enable_kde2)

if test "$enable_kde2" = "no"; then
   kde2_libs=""
   kde2_includes=""
   kde2_include_dir=""
   kde2_app=""
   kde2_install_dir=""
else


dnl check for QT2
AQ_CHECK_QT2("$kde2_local_lforce")
AC_MSG_CHECKING(if qt2 version is fully useable)
if test "$have_qt2" != "yes"; then
   	kde2_libs=""
   	kde2_includes=""
   	kde2_include_dir=""
   	kde2_app=""
   	kde2_install_dir=""
	AC_MSG_RESULT(no, so no KDE2 without qt2)
else
	AC_MSG_RESULT(yes)



dnl paths for kde install dir
AC_MSG_CHECKING(for kde2 install dir)
AC_ARG_WITH(kde2-prefix, 
  [  --with-kde2-prefix=DIR      installs kde2 apps to the given dir],
  [local_kde2_prefix="$withval"],
  [local_kde2_prefix="\
  	$KDEDIR \
        /usr/local \
        /usr \
        /opt/kde2 \
        /opt/kde \
        "
  ]
)

if test -z "$kde2_install_dir"; then
	for i in $local_kde2_prefix; do
		if test -z "$kde2_install_dir"; then
        	   if test -x "$i/bin/kde-config"; then
                   	if $i/bin/kde-config --prefix &>/dev/null ; then
                           kde2_install_dir="`$i/bin/kde-config --prefix`"
                        else
                           tmp="`$i/bin/kde-config --prefix 2>&1`"
                           AC_MSG_WARN([
  $i/bin/kde-config exists, but could not be executed. Error was
  "$tmp]")
  			fi
                   fi
 		fi
        done
fi

if test -z "$kde2_install_dir"; then
      	AC_MSG_RESULT(not found)
else
      	AC_MSG_RESULT($kde2_install_dir)
fi


dnl paths for kde includes
AC_MSG_CHECKING(for kde2 includes)
AC_ARG_WITH(kde2-includes, 
  [  --with-kde2-includes=DIR      uses kde2 includes from given dir],
  [local_kde2_includes="$withval"],
  [local_kde2_includes="\
  	$KDEDIR/include \
        /usr/include/kde2 \
        /usr/local/include/kde2 \
        /usr/include/kde \
        /usr/local/include/kde \
        /opt/kde2/include \
        /opt/kde/include \
        /usr/include \
        /usr/local/include \
        "
  ]
)

if test -z "$kde2_includes"; then
	for i in $local_kde2_includes; do
		if test -z "$kde2_includes"; then
        		if test -r "$i/kapp.h"; then
                        	tmp=`grep "KDE_VERSION_MAJOR 2" "$i/kapp.h"`
                                if test -n "$tmp"; then
                                	kde2_includes="-I$i"
                                        kde2_include_dir="$i"
                                fi
                	fi
 		fi
        done
fi
if test -n "$kde2_includes"; then
	AC_MSG_RESULT($kde2_include_dir)
else
	AC_MSG_RESULT(not found)
fi



dnl paths for kde libs
AC_MSG_CHECKING(for kde libraries)
AC_ARG_WITH(kde2-libs, 
  [  --with-kde2-libs=DIR      uses kde2 libs from given dir],
  [local_kde2_libs="$withval"],
  [local_kde2_libs="\
  	$KDEDIR/lib \
        /usr/lib/kde2 \
        /usr/local/lib/kde2 \
        /usr/lib/kde \
        /usr/local/lib/kde \
        /opt/kde2/lib \
        /opt/kde/lib \
        /usr/lib \
        /usr/local/lib \
        "
  ]
)

if test -z "$kde2_libs"; then
	AQ_SEARCH_FOR_PATH([libkdeui.so.3],[$local_kde2_libs])
       	if test -n "$found_dir" ; then
       		kde2_libs="-L$found_dir"
		AC_MSG_RESULT($kde2_libs)
        else
		AC_MSG_RESULT(not found)
       	fi
fi


# check if all necessary kde components where found
if test -z "$kde2_includes" || \
   test -z "$kde2_install_dir" || \
   test -z "$kde2_libs"; then
	kde2_libs=""
   	kde2_includes=""
   	kde2_app=""
   	if test "$kde2_local_lforce" = "yes"; then
        	AC_MSG_ERROR([
 Compilation of KDE applications is enabled but I could not find some KDE
 components (see which are missing in messages above).
 If you don't want to compile KDE applications please use "--disable-kdeapps".
 ])
   	else
        	AC_MSG_WARN([
 KDE2 is not explicitly disabled and I could not find some KDE2 components 
 (see which are missing in messages above).
 If you don't want to compile KDE2 applications please use "--disable-kde2".
 ])
   	fi
else
dnl TODO: AC_TRY_RUN, check whether kdeversion.h has matching versions
   kde2_app="$kde2_local_lsd"
   have_kde2=yes
   AC_DEFINE(HAVE_KDE2)
fi


dnl end of if QT2 is useable
fi


dnl end of if "$enable_kdeapps"
fi

AS_SCRUB_INCLUDE(kde2_includes)
AC_SUBST(kde2_app)
AC_SUBST(kde2_libs)
AC_SUBST(kde2_includes)
AC_SUBST(kde2_include_dir)
AC_SUBST(kde2_install_dir)

])



# $Id: kde3.m4,v 1.3 2003/03/31 01:49:44 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# These functions search for KDE 3


AC_DEFUN(AQ_CHECK_KDE3,[
dnl PREREQUISITES:
dnl   none
dnl IN: 
dnl   $1 = "yes" if KDE3 is needed, "no" if KDE3 is optional
dnl   $2 = subdirs to include when KDE3 is available
dnl   You may preset the return variables.
dnl   All variables which already have a value will not be altered
dnl OUT:
dnl   Variables:
dnl     have_kde3 - set to "yes" if KDE3 exists
dnl     kde3_includes - CFLAGS for includes (-I)
dnl     kde3_include_dir - path to includes
dnl     kde3_libs - LDFLAGS for linking the kde3 libraries (-L)
dnl     kde3_app - kde3 apps given as the argument to this funtion
dnl     kde3_install_dir - install directory for kde3 applications
dnl   Defines:
dnl     HAVE_KDE3
dnl USED MACROS:
dnl  AQ_CHECK_QT3


kde3_local_lforce="$1"
kde3_local_lsd="$2"

dnl check if kde apps are desired
AC_MSG_CHECKING(if KDE3 is allowed)
AC_ARG_ENABLE(kde3,
  [  --enable-kde3         enable kde3 (default=yes)],
  enable_kde3="$enableval",
  enable_kde3="yes")
AC_MSG_RESULT($enable_kde3)

if test "$enable_kde3" = "no"; then
   kde3_libs=""
   kde3_includes=""
   kde3_include_dir=""
   kde3_app=""
   kde3_install_dir=""
else


dnl check for QT3
AQ_CHECK_QT3("$kde3_local_lforce")
AC_MSG_CHECKING(if qt3 version is fully useable)
if test "$have_qt3" != "yes"; then
   	kde3_libs=""
   	kde3_includes=""
   	kde3_include_dir=""
   	kde3_app=""
   	kde3_install_dir=""
	AC_MSG_RESULT(no, so no KDE3 without qt3)
else
	AC_MSG_RESULT(yes)


dnl paths for kde install dir
AC_MSG_CHECKING(for kde3 install dir)
AC_ARG_WITH(kde3-prefix, 
  [  --with-kde3-prefix=DIR      installs kde3 apps to the given dir],
  [local_kde3_prefix="$withval"],
  [local_kde3_prefix="\
  	$KDEDIR \
        /usr/local \
        /usr \
        /opt/kde3 \
        /opt/kde \
        "
  ]
)
if test -z "$kde3_install_dir"; then
	for i in $local_kde3_prefix; do
		if test -z "$kde3_install_dir"; then
        	   if test -x "$i/bin/kde-config"; then
                      	$i/bin/kde-config --prefix &>/dev/null && \
                          kde3_install_dir="`$i/bin/kde-config --prefix`"
                   fi
 		fi
        done
fi

if test -z "$kde3_install_dir"; then
      	AC_MSG_RESULT(not found)
else
      	AC_MSG_RESULT($kde3_install_dir)
fi


dnl paths for kde includes
AC_MSG_CHECKING(for kde3 includes)
AC_ARG_WITH(kde3-includes, 
  [  --with-kde3-includes=DIR      uses kde3 includes from given dir],
  [local_kde3_includes="$withval"],
  [local_kde3_includes="\
  	$KDEDIR/include \
        /usr/include/kde3 \
        /usr/local/include/kde3 \
        /usr/include/kde \
        /usr/local/include/kde \
        /opt/kde3/include \
        /opt/kde/include \
        /usr/include \
        /usr/local/include \
        "
  ]
)

if test -z "$kde3_include_dir"; then
	for i in $local_kde3_includes; do
		if test -z "$kde3_include_dir"; then
        		if test -r "$i/kdeversion.h"; then
                        	tmp=`grep "KDE_VERSION_MAJOR 3" "$i/kdeversion.h"`
                                if test -n "$tmp"; then
                                        kde3_include_dir="$i"
                                fi
                	fi
 		fi
        done
fi
if test -n "$kde3_include_dir"; then
	kde3_includes="-I$kde3_include_dir"
	AC_MSG_RESULT($kde3_include_dir)
else
	AC_MSG_RESULT(not found)
fi


dnl paths for kde libs
AC_MSG_CHECKING(for kde3 libraries)
AC_ARG_WITH(kde3-libs, 
  [  --with-kde3-libs=DIR      uses kde3 libs from given dir],
  [local_kde3_libs="$withval"],
  [local_kde3_libs="\
  	$KDEDIR/lib \
        /usr/lib/kde3 \
        /usr/local/lib/kde3 \
        /usr/lib/kde \
        /usr/local/lib/kde \
        /opt/kde3/lib \
        /opt/kde/lib \
        /usr/lib \
        /usr/local/lib \
        "
  ]
)

if test -z "$kde3_libs"; then
	AQ_SEARCH_FOR_PATH([libkdeui.so.4],[$local_kde3_libs])
       	if test -n "$found_dir" ; then
       		kde3_libs="-L$found_dir"
       	fi
fi
if test -n "$kde3_libs"; then
      	AC_MSG_RESULT($kde3_libs)
else
       	AC_MSG_RESULT(not found)
fi


# check if all necessary kde components where found
if test -z "$kde3_includes" || \
   test -z "$kde3_install_dir" || \
   test -z "$kde3_libs"; then
	kde3_libs=""
   	kde3_includes=""
   	kde3_app=""
   	have_kde3="no"
   	if test "$kde3_local_lforce" = "yes"; then
        	AC_MSG_ERROR([
 Compilation of KDE3 applications is enabled but I could not find some KDE3
 components (see which are missing in messages above).
 If you don't want to compile KDE3 applications please use "--disable-kde3".
 ])
   	else
        	AC_MSG_WARN([
 KDE3 is not explicitly disabled and I could not find some KDE3 components 
 (see which are missing in messages above).
 If you don't want to compile KDE3 applications please use "--disable-kde3".
 ])
   	fi
else
dnl TODO: AC_TRY_RUN, check whether kdeversion.h has matching versions
   kde3_app="$kde3_local_lsd"
   have_kde3="yes"
   AC_DEFINE(HAVE_KDE3)
fi


dnl end of if QT3 is useable
fi

dnl end of if "$enable_kdeapps"
fi

AS_SCRUB_INCLUDE(kde3_includes)
AC_SUBST(kde3_app)
AC_SUBST(kde3_libs)
AC_SUBST(kde3_includes)
AC_SUBST(kde3_include_dir)
AC_SUBST(kde3_install_dir)

])



# $Id: kde.m4,v 1.2 2002/10/29 00:39:36 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# These functions search for KDE 2-3


AC_DEFUN(AQ_CHECK_KDE,[
dnl PREREQUISITES:
dnl   none
dnl IN: 
dnl   $1 = "yes" if KDE is needed, "no" if KDE is optional
dnl   $2 = subdirs to include when KDE is available
dnl   You may preset the return variables.
dnl   All variables which already have a value will not be altered
dnl OUT:
dnl   Variables:
dnl     have_kde - set to "yes" if KDE exists
dnl     kde_includes - path to includes
dnl     kde_libs - path to libraries
dnl     kde_app - kde apps given as the argument to this funtion
dnl     kde_install_dir - install directory for kde3 applications
dnl     kde_generation - major version of kde
dnl     qt_generation - major version of qt
dnl   Defines:
dnl     HAVE_KDE
dnl USED MACROS:
dnl  AQ_CHECK_KDE2
dnl  AQ_CHECK_KDE3


kde_local_ops="$1"
kde_local_lsd="$2"

dnl check if kde apps are desired
AC_MSG_CHECKING(if KDE applications should be compiled)
AC_ARG_ENABLE(kde,
  [  --enable-kde         enable compilation of kde applications (default=yes)],
  enable_kdeapps="$enableval",
  enable_kdeapps="yes")
AC_MSG_RESULT($enable_kdeapps)

if test "$enable_kdeapps" = "no"; then
   kde_libs=""
   kde_includes=""
   kde_app=""
   have_kde="no"
else
   dnl check for KDE3
   have_kde="no"
   have_kde3="no"
   AQ_CHECK_KDE3("no","$kde_local_lsd")
   if test "$have_kde3" = "yes"; then
   	kde_app="$kde3_app"
        kde_libs="$kde3_libs"
        kde_includes="$kde3_includes"
        kde_include_dir="$kde3_include_dir"
        kde_install_dir="$kde3_install_dir"
        kde_generation="3"
        qt_generation="3"
        have_kde="yes"
   	qt_app="$qt3_app"
        qt_libs="$qt3_libs"
        qt_includes="$qt3_includes"
   	qt_moc="$qt3_moc"
   	qt_uic="$qt3_uic"
        qt_generation="3"
        have_qt="yes"
   else
   	dnl check for KDE2
   	have_kde2="no"
   	AQ_CHECK_KDE2("no","$kde_local_lsd")
   	if test "$have_kde2" = "yes"; then
   		kde_app="$kde2_app"
        	kde_libs="$kde2_libs"
        	kde_includes="$kde2_includes"
        	kde_include_dir="$kde2_include_dir"
        	kde_install_dir="$kde2_install_dir"
        	kde_generation="2"
        	qt_generation="2"
        	have_kde="yes"
   		qt_app="$qt2_app"
        	qt_libs="$qt2_libs"
        	qt_includes="$qt2_includes"
   		qt_moc="$qt2_moc"
   		qt_uic="$qt2_uic"
        	qt_generation="2"
        	have_qt="yes"
   	fi
   fi
   dnl check if kde found
   AC_MSG_CHECKING(for KDE version to be used)
   if test "$have_kde" != "yes"; then
   	if test "$kde_local_ops" = "yes"; then
        	AC_MSG_ERROR([
  I could not find a suitable KDE version while checking for KDE2 and KDE3.
  If you do not want KDE applications to be compiled please use 
  --disable-kde.])
  	else
        	AC_MSG_RESULT(none)
   	fi
   else
   	AC_MSG_RESULT(version $kde_generation)
        AC_DEFINE(HAVE_KDE)
        AC_DEFINE_UNQUOTED(KDE_GENERATION,$kde_generation)
        AC_DEFINE_UNQUOTED(QT_GENERATION,$qt_generation)
   fi
dnl end of if "$enable_kdeapps"
fi

AC_SUBST(kde_app)
AC_SUBST(kde_libs)
AC_SUBST(kde_includes)
AC_SUBST(kde_include_dir)
AC_SUBST(kde_generation)
AC_SUBST(kde_install_dir)
AC_SUBST(qt_app)
AC_SUBST(qt_libs)
AC_SUBST(qt_includes)
AC_SUBST(qt_moc)
AC_SUBST(qt_uic)
AC_SUBST(qt_generation)
])

# $Id: os.m4,v 1.3 2003/01/10 20:02:02 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# These functions guess your operation system

AC_DEFUN(AQ_CHECK_OS,[
dnl PREREQUISITES:
dnl   AC_CANONICAL_SYSTEM must be called before
dnl IN:
dnl   nothing
dnl OUT:
dnl   Variables:
dnl     OSYSTEM: Short name of your system (subst)
dnl     OS_TYPE: either "posix" or "windows" (subst)
dnl     MAKE_DLL_TARGET: under windows this is set to "dll" (subst)
dnl     INSTALL_DLL_TARGET: under Windows this is set to "dll-install" (subst)
dnl   Defines:
dnl     OS_NAME: full name of your system
dnl     OS_SHORTNAME: short name of your system
dnl     Depending on your system one of the following is defined in addition:
dnl      OS_LINUX, OS_OPENBSD, OS_FREEBSD, OS_BEOS, OS_WIN32

# check for OS
AC_MSG_CHECKING([target system type])
OSYSTEM=""
OS_TYPE=""
MAKE_DLL_TARGET=""
INSTALL_DLL_TARGET=""
AC_DEFINE_UNQUOTED(OS_NAME,"$target")
case "$target" in
    *-linux*)
	OSYSTEM="linux"
	AC_DEFINE(OS_LINUX)
	OS_TYPE="posix"
	;;
    *-openbsd*)
	OSYSTEM="openbsd"
	AC_DEFINE(OS_OPENBSD)
	OS_TYPE="posix"
	;;
    *-freebsd*)
	OSYSTEM="freebsd"
	AC_DEFINE(OS_FREEBSD)
	OS_TYPE="posix"
	;;
    *-beos*)
	OSYSTEM="beos"
	AC_DEFINE(OS_BEOS)
	OS_TYPE="posix"
	;;
    *-win32*)
    	OSYSTEM="windows"
	AC_DEFINE(OS_WIN32)
	OS_TYPE="windows"
	;;
    *-mingw32*)
	OSYSTEM="windows"
	AC_DEFINE(OS_WIN32)
	OS_TYPE="windows"
	;;
    *)
	AC_MSG_WARN([Sorry, but target $target is not supported.
        Please report if it works anyway. We will assume that your system
        is a posix system and continue.])
	OSYSTEM="unknown"
	OS_TYPE="posix"
	;;
esac

AC_SUBST(OSYSTEM)
AC_DEFINE_UNQUOTED(OS_SHORTNAME,"$OSYSTEM")
AC_SUBST(OS_TYPE)
AC_DEFINE_UNQUOTED(OS_TYPE,"$OS_TYPE")

AC_MSG_RESULT($OS_TYPE)
])


# $Id: pcsc.m4,v 1.3 2003/03/31 01:49:44 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# This function check if PC/SC is wanted

AC_DEFUN(AQ_CHECK_PCSC,[
dnl PREREQUISITES:
dnl   - AQ_CHECK_OS must becalled before
dnl IN: 
dnl   nothing
dnl OUT:
dnl   Variables:
dnl     pcsc_libraries: Path to the SSL libraries 
dnl     pcsc_lib: SSL libraries to link against
dnl     pcsc_includes: Path to the PC/SC includes
dnl   Defines:

dnl check if pcsc is desired
if test "$OSYSTEM" != "windows" ; then
  AC_MSG_CHECKING(if PC/SC should be used)
  AC_ARG_ENABLE(pcsc,
    [  --enable-pcsc             enable PC/SC driver (default=yes)],
    enable_pcsc="$enableval",
    enable_pcsc="yes")
  AC_MSG_RESULT($enable_pcsc)

  if test "$enable_pcsc" != "no"; then

    dnl ******* pcsc includes ***********
    AC_MSG_CHECKING(for pcsc includes)
    if test "$OSYSTEM" != "windows" ; then
      AC_ARG_WITH(pcsc-includes, [  --with-pcsc-includes=DIR adds pcsc include path],
        [pcsc_search_inc_dirs="$withval"],
        [pcsc_search_inc_dirs="/usr/include\
               	       /usr/local/include\
          	       /usr/local/pcsc/include\
  		       /usr/pcsc/include\
                       "])

      dnl search for pcsc
      AQ_SEARCH_FOR_PATH([winscard.h],[$pcsc_search_inc_dirs])
      if test -n "$found_dir" ; then
        pcsc_includes="-I$found_dir"
      fi
      AC_MSG_RESULT($pcsc_includes)
    else
      AC_MSG_RESULT(builtin winscard.h)
    fi


    dnl ******* pcsc lib ***********
    AC_MSG_CHECKING(for pcsc libs)
    AC_ARG_WITH(pcsc-libname, [  --with-pcsc-libname=NAME  specify the name of the pcsc library],
      [pcsc_search_lib_names="$withval"],
      [pcsc_search_lib_names="libpcsclite.so \
                             libpcsclite.so.* \
                             libpcsc.a"])

    AC_ARG_WITH(pcsc-libs, [  --with-pcsc-libs=DIR  adds pcsc library path],
      [pcsc_search_lib_dirs="$withval"],
      [pcsc_search_lib_dirs="/usr/lib \
            	          /usr/local/lib \
                          /usr/lib/pcsc/lib \
	                  /usr/local/pcsc/lib \
	                  /lib"])
    dnl search for pcsc libs
    for d in $pcsc_search_lib_dirs; do
       AQ_SEARCH_FILES("$d",$pcsc_search_lib_names)
       if test -n "$found_file" ; then
          pcsc_libraries="-L$d"
          pcsc_lib="-l`echo $found_file | sed 's/lib//;s/\.so*//;s/\.a//'`"
          break
       fi
    done

    if test -z "$pcsc_libraries" -o -z "$pcsc_lib" -o -z "$pcsc_includes"; then
        AC_MSG_WARN(No pcsc libraries found, SCard driver will not be available.)
    else
        AC_MSG_RESULT($pcsc_libraries ${pcsc_lib})
        have_pcsc="yes"
    fi
  # end of "if enable-pcsc"
  fi
#end of if windows
fi

AS_SCRUB_INCLUDE(pcsc_includes)
AC_SUBST(pcsc_includes)
AC_SUBST(pcsc_libraries)
AC_SUBST(pcsc_lib)
])

# $Id: qt2.m4,v 1.9 2003/03/31 01:49:44 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# These functions search for QT 2


AC_DEFUN(AQ_CHECK_QT2,[
dnl PREREQUISITES:
dnl   AQ_CHECK_OS must be called before this
dnl IN: 
dnl   $1 = "yes" if QT2 is needed, "no" if QT2 is optional
dnl   $2 = subdirs to include when QT2 is available
dnl   You may preset the return variables.
dnl   All variables which already have a value will not be altered
dnl OUT:
dnl   Variables:
dnl     have_qt2 - set to "yes" if QT2 exists
dnl     qt2_includes - path to includes
dnl     qt2_libs - path to libraries
dnl     qt2_app - kde apps given as the argument to this funtion
dnl     qt2_uic - name and path of the uic tool
dnl     qt2_moc - name and path of the moc tool
dnl   Defines:
dnl     HAVE_QT2

lforce="$1"
lsd="$2"

AC_MSG_CHECKING(if QT2 is allowed)
AC_ARG_ENABLE(qt2,
  [  --enable-qt2         enable qt2 (default=yes)],
  enable_qt2="$enableval",
  enable_qt2="yes")
AC_MSG_RESULT($enable_qt2)

if test "$enable_qt2" = "no"; then
   qt2_libs=""
   qt2_includes=""
   qt2_app=""
   qt2_moc=""
   qt2_uic=""
   have_qt2="no"
else


dnl paths for qt2 includes
AC_MSG_CHECKING(for qt2 includes)
AC_ARG_WITH(qt2-includes, 
  [  --with-qt2-includes=DIR      uses qt2 includes from given dir],
  [local_qt2_includes="$withval"],
  [local_qt2_includes="\
  	$QTDIR/include \
        /usr/include/qt2 \
        /usr/local/include/qt2 \
        /usr/lib/qt2/include \
        /usr/local/lib/qt2/include \
        /opt/qt2/include \
        /usr/include/qt \
        /usr/local/include/qt \
        /usr/lib/qt/include \
        /usr/local/lib/qt/include \
        /usr/include \
        /usr/local/include \
        /opt/qt/include \
        "
  ]
)

if test -z "$qt2_includes"; then
	for i in $local_qt2_includes; do
		if test -z "$qt2_includes"; then
                  if test -f "$i/qglobal.h"; then
                    lv1=`grep -h "#define QT_VERSION_STR" $i/qglobal.h`
                    case $lv1 in
                    *2.*)
                  	qt2_includes="-I$i"
                        break;
                        ;;
                    esac
                  fi
 		fi
        done
fi
if test -n "$qt2_includes"; then
	AC_MSG_RESULT($qt2_includes)
else
	AC_MSG_RESULT(not found)
fi


AC_MSG_CHECKING(if threaded qt2 may be used)
AC_ARG_ENABLE(qt2-threads,
  [  --enable-qt2-threads         enable qt2-mt library (default=yes)],
  enable_qt2_threads="$enableval",
  enable_qt2_threads="yes")
AC_MSG_RESULT($enable_qt2_threads)


dnl paths for qt2 libs
AC_MSG_CHECKING(for qt2 libraries)
AC_ARG_WITH(qt2-libs, 
  [  --with-qt2-libs=DIR      uses qt2 libs from given dir],
  [local_qt2_libs="$withval"],
  [local_qt2_libs="\
  	$QTDIR/lib \
        /usr/lib/qt2 \
        /usr/local/lib/qt2 \
        /usr/lib/qt2/lib \
        /usr/local/lib/qt2/lib \
        /opt/qt2/lib \
        /usr/lib/qt \
        /usr/local/lib/qt \
        /usr/lib/qt/lib \
        /usr/local/lib/qt/lib \
        /usr/lib \
        /usr/local/lib \
        /opt/qt/lib \
        "
  ]
)

if test "$enable_qt2_threads" != "no"; then
	if test -z "$qt2_libs"; then
		AQ_SEARCH_FOR_PATH([libqt-mt.so.2],[$local_qt2_libs])
       		if test -n "$found_dir" ; then
       			qt2_libs="-L$found_dir -lqt-mt"
       		fi
	fi
fi
if test -z "$qt2_libs"; then
 	AQ_SEARCH_FOR_PATH([libqt.so.2],[$local_qt2_libs])
     	if test -n "$found_dir" ; then
     	   qt2_libs="-L$found_dir -lqt"
       	fi
fi

if test -n "$qt2_libs"; then
	AC_MSG_RESULT($qt2_libs)
else
	AC_MSG_RESULT(not found)
fi


dnl paths for qt2 moc
AC_MSG_CHECKING(for qt2 moc)
AC_ARG_WITH(qt2-moc, 
  [  --with-qt2-moc=DIR      uses given qt2 moc],
  [local_qt2_moc="$withval"],
  [local_qt2_moc="\
  	$QTDIR/bin \
        /usr/lib/qt2/bin \
        /usr/local/lib/qt2/bin \
        /opt/qt2/bin \
        /usr/lib/qt/bin \
        /usr/local/lib/qt/bin \
        /usr/bin \
        /usr/local/bin \
        /opt/qt/bin \
        "
  ]
)
if test -z "$qt2_moc"; then
	AQ_SEARCH_FOR_PATH([moc],[$local_qt2_moc])
       	if test -n "$found_dir" ; then
       		qt2_moc="$found_dir/moc"
       	fi
fi
if test -n "$qt2_moc"; then
	AC_MSG_RESULT($qt2_moc)
else
	AC_MSG_RESULT(not found)
fi


dnl paths for qt2 uic
AC_MSG_CHECKING(for qt2 uic)
AC_ARG_WITH(qt2-uic, 
  [  --with-qt2-uic=DIR      uses given qt2 uic],
  [local_qt2_uic="$withval"],
  [local_qt2_uic="\
  	$QTDIR/bin \
        /usr/lib/qt2/bin \
        /usr/local/lib/qt2/bin \
        /opt/qt2/bin \
        /usr/lib/qt/bin \
        /usr/local/lib/qt/bin \
        /usr/bin \
        /usr/local/bin \
        /opt/qt/bin \
        "
  ]
)
if test -z "$qt2_uic"; then
	AQ_SEARCH_FOR_PATH([uic],[$local_qt2_uic])
       	if test -n "$found_dir" ; then
       		qt2_uic="$found_dir/uic"
       	fi
fi
if test -n "$qt2_uic"; then
	AC_MSG_RESULT($qt2_uic)
else
	AC_MSG_RESULT(not found)
fi


# check if all necessary qt2 components where found
if test -z "$qt2_includes" || \
   test -z "$qt2_moc" || \
   test -z "$qt2_uic" || \
   test -z "$qt2_libs"; then
	qt2_libs=""
	qt2_moc=""
	qt2_uic=""
   	qt2_includes=""
   	qt2_app=""
   	have_qt2="no"
   	if test "$lforce" = "yes"; then
        	AC_MSG_ERROR([
 Compilation of QT applications is enabled but I could not find some QT
 components (see which are missing in messages above).
 If you don't want to compile KDE applications please use "--disable-qt2".
 ])
   	else
        	AC_MSG_WARN([
 QT2 is not explicitly disabled and I could not find some QT2 components 
 (see which are missing in messages above).
 If you don't want to compile QT2 applications please use "--disable-qt2".
 ])
   	fi
else
dnl TODO: AC_TRY_RUN, check whether kdeversion.h has matching versions
   qt2_app="$lsd"
   have_qt2="yes"
   AC_DEFINE(HAVE_QT2)
fi


dnl end of if "$enable_qt2"
fi


AS_SCRUB_INCLUDE(qt2_includes)
AC_SUBST(qt2_app)
AC_SUBST(qt2_libs)
AC_SUBST(qt2_includes)
AC_SUBST(qt2_moc)
AC_SUBST(qt2_uic)

])






# $Id: qt3.m4,v 1.5 2003/03/31 01:49:44 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# These functions search for QT 3


AC_DEFUN(AQ_CHECK_QT3,[
dnl PREREQUISITES:
dnl   AQ_CHECK_OS must be called before this
dnl IN: 
dnl   $1 = "yes" if QT3 is needed, "no" if QT3 is optional
dnl   $2 = subdirs to include when QT is available
dnl   You may preset the return variables.
dnl   All variables which already have a value will not be altered
dnl OUT:
dnl   Variables:
dnl     have_qt3 - set to "yes" if QT3 exists
dnl     qt3_includes - path to includes
dnl     qt3_libs - path to libraries
dnl     qt3_app - kde apps given as the argument to this funtion
dnl     qt3_uic - name and path of the uic tool
dnl     qt3_moc - name and path of the moc tool
dnl   Defines:
dnl     HAVE_QT3

lforce="$1"
lsd="$2"

AC_MSG_CHECKING(if QT3 is allowed)
AC_ARG_ENABLE(qt3,
  [  --enable-qt3         enable qt3 (default=yes)],
  enable_qt3="$enableval",
  enable_qt3="yes")
AC_MSG_RESULT($enable_qt3)

if test "$enable_qt3" = "no"; then
   qt3_libs=""
   qt3_includes=""
   qt3_app=""
   qt3_moc=""
   qt3_uic=""
   have_qt3="no"
else


dnl paths for qt3 includes
AC_MSG_CHECKING(for qt3 includes)
AC_ARG_WITH(qt3-includes, 
  [  --with-qt3-includes=DIR      uses qt3 includes from given dir],
  [local_qt3_includes="$withval"],
  [local_qt3_includes="\
  	$QTDIR/include \
        /usr/include/qt3 \
        /usr/local/include/qt3 \
        /usr/lib/qt3/include \
        /usr/local/lib/qt3/include \
        /opt/qt3/include \
        /usr/include/qt \
        /usr/local/include/qt \
        /usr/lib/qt/include \
        /usr/local/lib/qt/include \
        /usr/include \
        /usr/local/include \
        /opt/qt/include \
        /usr/X11R6/include \
        "
  ]
)

if test -z "$qt3_includes"; then
	for i in $local_qt3_includes; do
		if test -z "$qt3_includes"; then
                  if test -f "$i/qglobal.h"; then
                    lv1=`grep -h "#define QT_VERSION_STR" $i/qglobal.h`
                    case $lv1 in
                    *3.*)
                  	qt3_includes="-I$i"
                        break;
                        ;;
                    esac
                  fi
 		fi
        done
fi
if test -n "$qt3_includes"; then
	AC_MSG_RESULT($qt3_includes)
else
	AC_MSG_RESULT(not found)
fi


AC_MSG_CHECKING(if threaded qt3 may be used)
AC_ARG_ENABLE(qt3-threads,
  [  --enable-qt3-threads         enable qt3-mt library (default=yes)],
  enable_qt3_threads="$enableval",
  enable_qt3_threads="yes")
AC_MSG_RESULT($enable_qt3_threads)


dnl paths for qt3 libs
AC_MSG_CHECKING(for qt3 libraries)
AC_ARG_WITH(qt3-libs, 
  [  --with-qt3-libs=DIR      uses qt3 libs from given dir],
  [local_qt3_libs="$withval"],
  [local_qt3_libs="\
  	$QTDIR/lib \
        /usr/lib/qt3 \
        /usr/local/lib/qt3 \
        /usr/lib/qt3/lib \
        /usr/local/lib/qt3/lib \
        /opt/qt3/lib \
        /usr/lib/qt \
        /usr/local/lib/qt \
        /usr/lib/qt/lib \
        /usr/local/lib/qt/lib \
        /usr/lib \
        /usr/local/lib \
        /opt/qt/lib \
        /usr/X11R6/lib \
        "
  ]
)

if test "$enable_qt3_threads" != "no"; then
	if test -z "$qt3_libs"; then
		AQ_SEARCH_FOR_PATH([libqt-mt.so.3],[$local_qt3_libs])
       		if test -n "$found_dir" ; then
       			qt3_libs="-L$found_dir -lqt-mt"
                        test "$OSYSTEM" = "freebsd" && \
                          qt3_libs="$qt3_libs -lc_r"
       		fi
	fi
fi
if test -z "$qt3_libs"; then
   AQ_SEARCH_FOR_PATH([libqt.so.3],[$local_qt3_libs])
   if test -n "$found_dir" ; then
     qt3_libs="-L$found_dir -lqt"
       test "$OSYSTEM" = "freebsd" && \
          qt3_libs="$qt3_libs -lc_r"
   fi
fi

if test -n "$qt3_libs"; then
	AC_MSG_RESULT($qt3_libs)
else
	AC_MSG_RESULT(not found)
fi


dnl paths for qt3 moc
AC_MSG_CHECKING(for qt3 moc)
AC_ARG_WITH(qt3-moc, 
  [  --with-qt3-moc=DIR      uses given qt3 moc],
  [local_qt3_moc="$withval"],
  [local_qt3_moc="\
  	$QTDIR/bin \
        /usr/lib/qt3/bin \
        /usr/local/lib/qt3/bin \
        /opt/qt3/bin \
        /usr/lib/qt/bin \
        /usr/local/lib/qt/bin \
        /usr/bin \
        /usr/local/bin \
        /opt/qt/bin \
        /usr/X11R6/bin \
        "
  ]
)
if test -z "$qt3_moc"; then
	AQ_SEARCH_FOR_PATH([moc],[$local_qt3_moc])
       	if test -n "$found_dir" ; then
       		qt3_moc="$found_dir/moc"
       	fi
fi
if test -n "$qt3_moc"; then
	AC_MSG_RESULT($qt3_moc)
else
	AC_MSG_RESULT(not found)
fi


dnl paths for qt3 uic
AC_MSG_CHECKING(for qt3 uic)
AC_ARG_WITH(qt3-uic, 
  [  --with-qt3-uic=DIR      uses given qt3 uic],
  [local_qt3_uic="$withval"],
  [local_qt3_uic="\
  	$QTDIR/bin \
        /usr/lib/qt3/bin \
        /usr/local/lib/qt3/bin \
        /opt/qt3/bin \
        /usr/lib/qt/bin \
        /usr/local/lib/qt/bin \
        /usr/bin \
        /usr/local/bin \
        /opt/qt/bin \
        /usr/X11R6/bin \
        "
  ]
)
if test -z "$qt3_uic"; then
	AQ_SEARCH_FOR_PATH([uic],[$local_qt3_uic])
       	if test -n "$found_dir" ; then
       		qt3_uic="$found_dir/uic"
       	fi
fi
if test -n "$qt3_uic"; then
	AC_MSG_RESULT($qt3_uic)
else
	AC_MSG_RESULT(not found)
fi


# check if all necessary qt3 components where found
if test -z "$qt3_includes" || \
   test -z "$qt3_moc" || \
   test -z "$qt3_uic" || \
   test -z "$qt3_libs"; then
	qt3_libs=""
	qt3_moc=""
	qt3_uic=""
   	qt3_includes=""
   	qt3_app=""
   	have_qt3="no"
   	if test "$lforce" = "yes"; then
        	AC_MSG_ERROR([
 Compilation of QT applications is enabled but I could not find some QT
 components (see which are missing in messages above).
 If you don't want to compile KDE applications please use "--disable-qt3".
 ])
   	else
        	AC_MSG_WARN([
 QT3 is not explicitly disabled and I could not find some QT3 components 
 (see which are missing in messages above).
 If you don't want to compile QT3 applications please use "--disable-qt3".
 ])
   	fi
else
dnl TODO: AC_TRY_RUN, check whether kdeversion.h has matching versions
   qt3_app="$lsd"
   have_qt3="yes"
   AC_DEFINE(HAVE_QT3)
fi


dnl end of if "$enable_qt3"
fi

AS_SCRUB_INCLUDE(qt3_includes)
AC_SUBST(qt3_app)
AC_SUBST(qt3_libs)
AC_SUBST(qt3_includes)
AC_SUBST(qt3_moc)
AC_SUBST(qt3_uic)

])






# $Id: qt.m4,v 1.2 2002/10/29 00:39:36 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# These functions search for QT 2-3


AC_DEFUN(AQ_CHECK_QT,[
dnl PREREQUISITES:
dnl   none
dnl IN: 
dnl   $1 = "yes" if QT is needed, "no" if QT is optional
dnl   $2 = subdirs to include when QT is available
dnl   You may preset the return variables.
dnl   All variables which already have a value will not be altered
dnl OUT:
dnl   Variables:
dnl     have_qt - set to "yes" if QT exists
dnl     qt_includes - path to includes
dnl     qt_libs - path to libraries
dnl     qt_app - qt apps given as the argument to this funtion
dnl     qt_install_dir - install directory for qt3 applications
dnl     qt_generation - major version of qt
dnl     qt_generation - major version of qt
dnl   Defines:
dnl     HAVE_QT
dnl USED MACROS:
dnl  AQ_CHECK_QT2
dnl  AQ_CHECK_QT3
dnl NOTES:
dnl  This macro is not called by AQ_CHECK_KDE as you would expect.
dnl  Each KDE check (like AQ_CHECK_KDE2 and AQ_CHECK_KDE3) directly
dnl  calls the macro for its appropriate QT version:
dnl  - AQ_CHECK_KDE2 calls AQ_CHECK_QT2
dnl  - AQ_CHECK_KDE3 calls AQ_CHECK_QT3
dnl  AQ_CHECK_KDE simply calls AQ_CHECK_KDE3 and/or AQ_CHECK_KDE2, so this
dnl  macro here is only for your conveniance, to be used if you want to build
dnl  QT applications instead of KDE apps.

ops="$1"
lsd="$2"

dnl check if qt apps are desired
AC_MSG_CHECKING(if QT applications should be compiled)
AC_ARG_ENABLE(qt,
  [  --enable-qt         enable compilation of qt applications (default=yes)],
  enable_qtapps="$enableval",
  enable_qtapps="yes")
AC_MSG_RESULT($enable_qtapps)

if test "$enable_qtapps" = "no"; then
   qt_libs=""
   qt_includes=""
   qt_app=""
   qt_moc=""
   qt_uic=""
   have_qt="no"
else
   dnl check for QT3
   have_qt="no"
   have_qt3="no"
   AQ_CHECK_QT3("no",[$lsd])
   if test "$have_qt3" = "yes"; then
   	qt_app="$qt3_app"
        qt_libs="$qt3_libs"
        qt_includes="$qt3_includes"
   	qt_moc="$qt3_moc"
   	qt_uic="$qt3_uic"
        qt_generation="3"
        have_qt="yes"
   else
   	dnl check for QT2
   	have_qt2="no"
   	AQ_CHECK_QT2("no",[$lsd])
   	if test "$have_qt2" = "yes"; then
   		qt_app="$qt2_app"
        	qt_libs="$qt2_libs"
        	qt_includes="$qt2_includes"
   		qt_moc="$qt2_moc"
   		qt_uic="$qt2_uic"
        	qt_generation="2"
        	have_qt="yes"
   	fi
   fi
   dnl check if qt found
   AC_MSG_CHECKING(for QT version to be used)
   if test "$have_qt" != "yes"; then
   	if test "$ops" = "yes"; then
        	AC_MSG_ERROR([
  I could not find a suitable QT version while checking for QT2 and QT3.
  If you do not want QT applications to be compiled please use 
  --disable-qt.])
  	else
        	AC_MSG_RESULT(none)
   	fi
   else
   	AC_MSG_RESULT(version $qt_generation)
        AC_DEFINE(HAVE_QT)
        AC_DEFINE_UNQUOTED(QT_GENERATION,$qt_generation)
   fi
dnl end of if "$enable_qtapps"
fi

AC_SUBST(qt_app)
AC_SUBST(qt_libs)
AC_SUBST(qt_includes)
AC_SUBST(qt_moc)
AC_SUBST(qt_uic)
AC_SUBST(qt_generation)
])
# $Id: searchfiles.m4,v 1.4 2003/02/07 18:38:05 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# These functions search for files


AC_DEFUN(AQ_SEARCH_FOR_PATH,[
dnl searches for a file in a path
dnl $1 = file to search
dnl $2 = paths to search in
dnl returns the directory where the file is found (found_dir)
found_dir=""
ls=$1
ld="$2"
for li in $ld; do
    if test -r "$li/$ls"; then
        found_dir="$li"
        break
    fi
done
])

AC_DEFUN(AQ_SEARCH_FILES,[
dnl searches a dir for some files
dnl $1 = path where to search
dnl $2 = files to find
dnl returns the name of the file found (found_file)
found_file=""
ls="$1"
ld="$2"
lf=""
for li in $ld; do
    if test -f "$ls/$li"; then
      lf="$lf $ls/$li"
    fi
done
for li in $lf; do
    if test -r "$li"; then
	found_file=`basename "$li"`
	break
    fi
done
])
# $Id: ssl.m4,v 1.4 2003/03/31 01:49:44 aquamaniac Exp $
# (c) 2002 Martin Preuss<martin@libchipcard.de>
# This function check if SSL is wanted

AC_DEFUN(AQ_CHECK_SSL,[
dnl PREREQUISITES:
dnl   - AQ_CHECK_OS must becalled before
dnl IN: 
dnl   nothing
dnl OUT:
dnl   Variables:
dnl     ssl_libraries: Path to the SSL libraries (subst)
dnl     ssl_lib: SSL libraries to link against (subst)
dnl     ssl_includes: Path to the SSL includes (subst)
dnl     have_ssl: "yes" if ssl found
dnl   Defines:
dnl     HAVE_OPENSSL: defined if OpenSSL is available


dnl check if ssl is desired
AC_MSG_CHECKING(if OpenSSL should be used)
AC_ARG_ENABLE(ssl,
  [  --enable-ssl             enable encryption (default=yes)],
  enable_ssl="$enableval",
  enable_ssl="yes")
AC_MSG_RESULT($enable_ssl)

if test "$enable_ssl" != "no"; then

dnl ******* openssl includes ***********
AC_MSG_CHECKING(for openssl includes)
AC_ARG_WITH(openssl-includes, [  --with-openssl-includes=DIR adds openssl include path],
  [ssl_search_inc_dirs="$withval"],
  [ssl_search_inc_dirs="/usr/include\
    		       /usr/local/include\
		       /usr/local/ssl/include\
  		       /usr/ssl/include"])

dnl search for ssl
AQ_SEARCH_FOR_PATH([openssl/des.h],[$ssl_search_inc_dirs])
if test -z "$found_dir" ; then
    AC_MSG_ERROR(Please specify the location of your openssl includes.)
fi
ssl_includes="-I$found_dir"
AC_MSG_RESULT($ssl_includes)


dnl ******* openssl lib ***********
AC_MSG_CHECKING(for openssl libs)
AC_ARG_WITH(openssl-libname, [  --with-openssl-libname=NAME  specify the name of the openssl library],
  [ssl_search_lib_names="$withval"],
  [ssl_search_lib_names="libcrypto.so \
	                 libcrypto.so.* \
	                 libcrypto.a"])

AC_ARG_WITH(openssl-libs, [  --with-openssl-libs=DIR  adds openssl library path],
  [ssl_search_lib_dirs="$withval"],
  [ssl_search_lib_dirs="/usr/lib \
		       /usr/local/lib \
		       /usr/lib/ssl/lib \
		       /usr/lib/openssl/lib \
		       /usr/local/ssl/lib \
		       /usr/local/openssl/lib \
		       /lib"])

dnl search for openssl libs
if test "$OSYSTEM" != "windows" ; then
   for d in $ssl_search_lib_dirs; do
     AQ_SEARCH_FILES("$d",$ssl_search_lib_names)
     if test -n "$found_file" ; then
        ssl_libraries="-L$d"
        ssl_lib="-l`echo $found_file | sed 's/lib//;s/\.so*//;s/\.a//'`"
        break
     fi
   done
   else
     ssl_libraries="-L/c/windows"
     ssl_lib="-llibeay32 -llibssl32"
fi

if test -z "$ssl_libraries" -o -z "$ssl_lib" -o -z "$ssl_includes"; then
    AC_MSG_WARN(ssl libraries not found.)
    have_ssl="no"
else
    have_ssl="yes"
    AC_DEFINE(HAVE_OPENSSL)
    AC_MSG_RESULT($ssl_libraries ${ssl_lib})
fi


# end of "if enable-ssl"
fi

AS_SCRUB_INCLUDE(ssl_includes)
AC_SUBST(ssl_includes)
AC_SUBST(ssl_libraries)
AC_SUBST(ssl_lib)
])

