/* -*- indent-tabs-mode: t; tab-width: 8; c-basic-offset: 8; -*- */

#ifndef __UTIL
#define __UTIL

#include <time.h>

#define MAX(a, b) (((a) > (b)) ? (a) : (b))
#define MIN(a, b) (((a) < (b)) ? (a) : (b))

/** Copy a string of a-characters, padding the unused part of the
    destination buffer */
void iso_a_strcpy(unsigned char *dest, int size, const char *src);

/** Copy a string of d-characters, padding the unused part of the
    destination buffer */
void iso_d_strcpy(unsigned char *dest, int size, const char *src);

/** Returns a null terminated string containing the first 'size' a-characters
    from the source */
char *iso_a_strndup(const char *src, int size);

/** Returns a null terminated string containing the first 'size' d-characters
    from the source */
char *iso_d_strndup(const char *src, int size);

char *iso_strconcat(char sep, const char *a, const char *b);

char *iso_strdup(const char *src);

void iso_lsb(unsigned char *buf, int num, int bytes);
void iso_msb(unsigned char *buf, int num, int bytes);
void iso_bb(unsigned char *buf, int num, int bytes);

/** Records the date/time into a 7 byte buffer (9.1.5) */
void iso_datetime_7(unsigned char *buf, time_t t);

/** Records the date/time into a 17 byte buffer (8.4.26.1) */
void iso_datetime_17(unsigned char *buf, time_t t);

/** Removes the extension from the name, and returns the extension. The
    returned extension should _not_ be freed! */
void iso_split_filename(char *name, char **ext);

void iso_filecpy(unsigned char *buf, int size, const char *name, int version);

#endif /* __UTIL */
