/*
 *  client/edit.h  --  Routines for editing a text
 *
 *
 *  Copyright (C) 1990	Lysator Computer Club,
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	Bellman@Lysator.LiU.SE
 *
 *
 *  Any opinions expressed in this code are the author's PERSONAL opinions,
 *  and does NOT, repeat NOT, represent any official standpoint of Lysator,
 *  even if so stated.
 */


#include <s-string.h>
#include <kom-types.h>


/*****  Information for edited texts.  *****/


typedef struct {
	long	  line, col, pos;
} Editing_pos;
#define EMPTY_EDITING_POS_i	{ 0L, 0L, 0L }

typedef struct {
	String		  text;
	Misc_info	* miscs;
	int		  no_of_miscs;
	Editing_pos	  cursor_pos;
	Bool		  active;	/*  Is this position used? */
}  Edited_text;
#define EMPTY_EDITED_TEXT_i	\
	{ EMPTY_STRING_i, NULL, 0, EMPTY_EDITING_POS_i, TRUE }


/*  List of the texts you are currently editing  */
extern  Edited_text	* edited_texts;

/*  Size of the list of edited texts (number of allocated cells)  */
extern  int		  size_of_text_list;

/*  Current active text.  The one editing commands affect.  */
extern  int		  active_text;

/*  Flag. Set by the parsing of command line args in this simple */
/*  version. */
extern	int	  tomrad_avslutar;


/*****  Functions supplied by client/edit.c  *****/


/*
 *  Find a free slot in the list of texts user is editing
 *  Expand list if necessary.  (Not yet)
 */
extern  int
edit_create_new_text (void);



/*
 *  Deallocate a text and mark it's slot in the list of edited
 *  texts as free.  Returns the text number to be the new "active
 *  text".
 */
extern  int
edit_dealloc_text (int	text_to_dealloc);


/* Get the position of the insertion point of a text */
#define edit_insertion_point(edit_no)		\
    (edited_texts[(edit_no)].cursor_pos.pos + 0)

/* Set the position of the insertion point of a text */
#define edit_set_insertion_point(edit_no, position)		\
    (edited_texts[(edit_no)].cursor_pos.pos = (position))

/* Return a pointer to the text. */
#define edit_text(edit_no)	(&edited_texts[(edit_no)].text)


/*
 *  Add the conference RECIPIENT as a recipient of the unfinished
 *  text with the working number EDIT_NO.
 */
extern  Success
edit_add_recipient (int		edit_no,
		    Conf_no	recipient);


/*
 *  Add the conference RECIPIENT as a carbon copy recipient of the
 *  unfinished text with the working number EDIT_NO.
 */
extern  Success
edit_add_cc_recipient (int	edit_no,
		       Conf_no	cc_recipient);


/*
 *  Add the text TEXT-NO as being commented by the text with the 
 *  working number EDIT_NO.
 */
extern  Success
edit_add_commenting (int	edit_no,
		     Text_no	text_no);


/*
 *  Add the text TEXT-NO as being footnoted by the text with the 
 *  working number EDIT_NO.
 */
extern  Success
edit_add_footnote (int          edit_no,
                   Text_no      text_no);


/*
 *  Remove conference RECIPIENT from the list of recipients to
 *  the unfinished text EDIT_NO.
 */
extern  Success
edit_sub_recipient (int		edit_no,
		    Conf_no	recipient);



/*  This is what 'edit_text()'  returns.  */
typedef  enum  { kill_this_text,	/* The text is to be killed */
		 enter_this_text,	/* The text is to be entered into the
					 *     database    */
		 to_be_continued	/* To be continued at a later time */
}	Edit_result;


/*
 *  Let the user enter text
 */
extern  Edit_result
edit_enter_text (int	  edit_no);



/*
 *  Add a String to a text
 */
extern  Success
edit_add_string (int	  edit_no,
		 String	  str	  );


/*
 *  Delete a number of characters from a text.  Deletes forward if
 *  positive number of characters, backward if negative.
 */
extern  Success
edit_del_string (int	  edit_no,
		 int	  no_of_chars);
