/*
 *  client/function.h  --  The functions to actually execute the
 *			   commands fo the client.
 *
 *
 *  Copyright (C) 1990  Lysator Computer Club
 *			Linkoping University,  Sweden
 *
 *  Everyone is granted permission to copy, modify and redistribute
 *  this code, provided the people they give it to can.
 *
 *
 *  Author:	Thomas Bellman
 *		Lysator Computer Club
 *		Linkoping University
 *		Sweden
 *
 *  email:	bellman@Lysator.LiU.SE
 *
 */


#ifndef  FUNCTIONS_H_ALREADY_INCLUDED__
#define  FUNCTIONS_H_ALREADY_INCLUDED__


#include <misc-types.h>
#include <kom-types.h>
#include <kom-errno.h>


/*  The variable 'default_command' contains the command index
 *  for the command that is default.  This may be changed by
 *  any command.
 */
extern int	default_command;



extern void
command_loop (void);

/*  Called when some error occurs  */
extern void
client_error (Kom_err error);




/*
 *  The parameter 'ARGUMENT' in all these functions, is a pointer
 *  to a string containing the rest of the line, following the
 *  command.  E g if the user gave the command "Skapa m|te Inl{gg
 *  }t mig", then a pointer to the string "Inl{gg }t mig" should
 *  be passed in the parameter 'argument' to the function responsible
 *  for the command 'skapa m|te'.  Leading and trailing spaces are
 *  skipped.  If no arguments are given, 'ARGUMENT' should be NULL.
 */


/*  List all commands available in client  */
extern Success
cmd_list_commands (String   argument);


/*  List all commands available in client  */
extern Success
cmd_wait_for_text (String   argument);


/*  Write a new text  */
extern Success
cmd_write_new_text (String   argument);


/*  Write a footnote to a text  */
extern Success
cmd_footnote_text (String   argument);


/*  Write a comment to a text  */
extern Success
cmd_comment_text (String   argument);


/*  Reply directly (and privately) to the author of a text  */
extern Success
cmd_private_comment (String   argument);


/*  Write a letter to a person (or a conference)  */
extern Success
cmd_write_letter (String   argument);

/*  Write a raw text. */
extern Success
cmd_plain_write_new_text (String argument);

/*  Continue the started writing of a text.  */
extern  Success
cmd_continue_writing (String	argument);


/* Add another conference as recipient to the edited text. */
extern	Success
cmd_add_recipient_to_edited_text (String 	argument);

/* Add a commenting item to the edited text. */
extern Success
cmd_add_comment_to_to_edited_text (String	argument);

/* Modify or set the subject or an edited text. */
extern Success
cmd_new_subject (String		argument);

/* Start editing with an editor */
extern Success
cmd_edit_using_editor(String	argument);


/*  Remove a text that was started on earlier, but was never
 *  finished.  I e the user didn't really want to write the
 *  text.
 */
extern  Success
cmd_remove_text (String	argument);


/* Add and remove recipients from texts
 */
extern  Success
cmd_add_recipient (String argument);

extern  Success
cmd_copy_recipient (String argument);

extern  Success
cmd_sub_recipient (String argument);

extern  Success
cmd_change_recipient (String argument);


/*
 *  Enter the currenty edited text into the database as is.
 */
extern  Success
cmd_enter_text (String	argument);


/* Remove the last N words. */
extern  Success
cmd_remove_last_word (String	  argument);


/* Remove the last N lines */
extern  Success
cmd_remove_last_line (String	  argument);


/* Move insertion point to end of previous line */
extern  Success
cmd_previous_line (String	  argument);


/* Move insertion point to end of next line */
extern  Success
cmd_next_line (String	  argument);


/* Shows the header and the text body sofar. */
extern  Success
cmd_look_at_text_and_header(String argument);


/* View the text being written, or the last text viewed if none is
 * being writen */
extern  Success
cmd_look_at_text (String	  argument);


/*  Show a list of unread news.  */
extern Success
cmd_list_news (String   argument);


/*  Show a list confs.  */
extern Success
cmd_list_confs (String   argument);


/* Show a list of header lines. */
extern Success
cmd_list_texts (String	argument);


/*  Show who is logged in to the server, and what they are doing.  */
extern Success
cmd_show_who_is_on (String   argument);


/*  Log out from server and exit client.  */
extern Success
cmd_quit_LysKOM (String   argument);


/*  Find and display text(s) according to strange search patterns.  */
extern Success
cmd_find_and_view_text (String   argument);


/*  All review things. */
extern Success
cmd_review (String	argument);

extern Success
cmd_review_again (String argument);

extern Success
cmd_review_next (String	argument);


/* Remember a text for future sessions. */
extern  Success
cmd_mark_permanently (String	argument);


/*  Read the next text in order  */
extern Success
cmd_read_next_text (String   argument);


/*  Only read N latest texts of current conference */
extern Success
cmd_only (String   argument);


/*  read all unread texts in all conferences */
extern Success
cmd_all (String   argument);


/*  read all unread texts in all conferences */
extern Success
cmd_set_height (String   argument);


/* Set character set */
extern Success
cmd_set_character (String   argument);


/*  Read the next comment  */
extern Success
cmd_read_next_comment (String   argument);


/*  Read the next footnote  */
extern Success
cmd_read_next_footnote (String   argument);


/*  Read the commented text  */
extern Success
cmd_read_commented_text (String  argument);


/*  Jump comments to text  */
extern Success
cmd_jump_tree (String  argument);


/*  Goto the next conference with unread news. */
extern Success
cmd_goto_next_conf (String   argument);


/* Show status for a person or a conference */
extern  Success
cmd_status (String	name);


/*  Create a new conference  */
extern  Success
cmd_create_new_conference (String	new_conf_name);


/* Remove a conference */
extern  Success
cmd_remove_conference (String       conference);


/* Find all names matching the string given as argument */
extern  Success
cmd_show_matching_names (String	name);


/*  Go to the next conference in order  */
extern Success
cmd_goto_next_conference (String   argument);


/*  Go to the specified conference.  Join it if not a member.  */
extern Success
cmd_goto_named_conference (String   argument);


/*  Join (become a member of) a conference.  */
extern Success
cmd_join_conference (String   argument);


/*  Leave (resign as a member of) a conference.  */
extern Success
cmd_leave_conference (String   argument);


/*
 *  Tell the user who s/he is, in what conference s/he currently
 *  is in, and the version of LysKOM.
 */
extern  Success
cmd_where_am_i (String	argument);


/*  Start with a new name.  Does a login.  (The server automatically
 *  does a logout if already logged in.)
 */	
extern Success
cmd_start_anew (String   argument);



/* Enable the current user */
extern  Success
cmd_enable_user (String	  argument);



/*  Get some encouragement when you are in a bad mood.	*/
extern  Success
cmd_get_encouragement (String   argument);



/*
 *  Print the current time
 */
extern  Success
cmd_show_current_time (String	argument);



/*
 *  Tell the user the current phase of the moon.
 */
extern  Success
cmd_show_moon_phase (String	argument);



extern  Success
cmd_answer_never_existed (String	argument);


extern  Success
cmd_spawn_exec (String	  argument);


extern	Success
cmd_delete_text	(String	  argument);


extern	void
show_directed_message(Conf_no	to,
		      Conf_no	from,
		      String	message);

extern	Success
cmd_send_personal (String	argument);

extern	Success
cmd_send_alarm	(String		argument);

extern Success cmd_download(String argument);
extern Success cmd_upload(String argument);


/*  Print a message telling the users that this command is not
 *  implemented yet.
 */
extern  Success
cmd_not_yet_implemented (String   argument);

#endif  /*  FUNCTIONS_H_ALREADY_INCLUDED__  */
