/*
 * $Id: parse.h,v 1.3 2001/01/27 22:23:08 linus Exp $
 * Copyright (C) 1991  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 * $Id: parse.h,v 1.3 2001/01/27 22:23:08 linus Exp $
 *
 * parse.h  -  parse objects from an isc connection.
 *
 * Written by ceder 1990-07-13
 */
/* BUGS: Return values from realloc are not checked. */
/* 	 %lu ain't always correct.	*/

extern int
my_getc(FILE *fp);

extern void
my_ungetc(int c, FILE *fp);

extern void
skipwhite(FILE *fp);

extern u_long
parse_long(FILE *fp);

extern Success
parse_time(FILE *fp, struct tm *timeptr);


extern Success
parse_person(FILE *fp,
	     Person *person);


extern Success
parse_membership(FILE *fp,
		 Membership *mship);


extern Success
parse_membership_list(FILE *fp,
		      Membership_list *result);


extern Success
parse_conference(FILE *fp,
		 Conference *result);


extern Success
parse_mark_list(FILE *fp,
		Mark_list *result);

extern Success
parse_Misc_infos(FILE * fp, 
		 unsigned short * no_of_miscs,
		 Misc_info ** misc_items);

extern Success
parse_text_stat(FILE *fp,
		Text_stat *result);

extern Success
parse_text_list(FILE *fp,
		Text_list *result);

extern Success
parse_info(FILE *fp,
	   Info *result);

extern Success 
parse_string(FILE *fp,
	     String *result);


extern Success
parse_member_list(FILE *fp,
		  Member_list *result);

extern Success
parse_member(FILE *fp,
	     Member *result);

extern Success
parse_mark(FILE *fp,
	   Mark *result);


extern Success
parse_misc_info(FILE *fp,
		Misc_info *result);


extern Success
parse_priv_bits(FILE *fp,
		Priv_bits *result);

extern Success
parse_personal_flags(FILE *fp,
		     Personal_flags *result);

extern Success
parse_conf_type(FILE *fp,
		Conf_type *result);

extern Success
parse_conf_no_list(FILE *fp,
		   Conf_no_list *result);

extern Success
parse_who_info(FILE *fp,
	       Who_info *result);


extern  Success
parse_conf_z_info_list(FILE *fp,
		       Conf_z_info_list * result);

extern Success
parse_conf_z_info(FILE *fp, Conf_z_info * result);

extern  Success
parse_dynamic_session_info_list(FILE *fp, 
				Dynamic_session_info_list * result);

extern  Success
parse_dynamic_session_info(FILE *fp, 
			   Dynamic_session_info * result);

extern Success
parse_session_flags(FILE *fp, Session_flags * result);
