/*
 * $Id: client.c,v 1.5 1998/08/08 18:53:12 linus Exp $
 * Copyright (C) 1991  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
** client.c                        definitions of ISC client support routines
**
** history:
**    900509 pen       initial coding
**    930829 linus     changed name.
*/

#include <config.h>
#include <stdio.h>
/* #include <sys/time.h> is included from kom-types.h */
#include <sys/types.h>  
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <arpa/inet.h>
#include <netdb.h>
#ifdef HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <unistd.h>

#include <kom-types.h>

#include "client-mall.h"
#include "client.h"

/*
 * Open a connection to a server. host == NULL means this machine.
 */
ISC *
isc_connect(const char *host,
	    int port)
{
    ISC *isc_si;
    char buf[100];
#ifdef HAVE_STRUCT_LINGER
    struct linger  lingonsylt;
#endif
    int intbuf;
    struct sockaddr_in server;
    struct hostent *hp;



    /* Allocate storage for the ISC structure */
    isc_si = (ISC *) isc_malloc(sizeof(ISC));


    /* Local connection? */
    if (host == NULL)
    {
        strcpy(buf, "localhost");
	host = buf;
    }

    if ((hp = gethostbyname(host)) != NULL)
    {
	memset((char *) &server, 0, sizeof(server));
#ifdef NETDB_DIFF
	memcpy((char *) &server.sin_addr, hp->h_addr_list, hp->h_length);
#else
	memcpy((char *) &server.sin_addr, hp->h_addr, hp->h_length);
#endif
	server.sin_family = hp->h_addrtype;
    }
    else
    {
	perror("gethostbyname failed:");
	server.sin_family = AF_INET;
	server.sin_addr.s_addr = inet_addr(host);
	if (server.sin_addr.s_addr == -1)
	    return NULL;
    }

    server.sin_port = (int) htons(port);
    if ((isc_si->fd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	return NULL;

#ifdef HAVE_STRUCT_LINGER
    lingonsylt.l_onoff = 0;
    lingonsylt.l_linger = 0;
    if (setsockopt(isc_si->fd, SOL_SOCKET, SO_LINGER,
		   (char *)&lingonsylt, sizeof(lingonsylt)) < 0)
    {
	perror("Can't turn off linger");
    }
#endif

    intbuf = 0;
    if (setsockopt(isc_si->fd, SOL_SOCKET, SO_REUSEADDR, 
		   (char *)&intbuf, sizeof(intbuf)) < 0)
    {
	perror("Can't turn of reuse of local addr");
    }

    intbuf = 1;
    if (setsockopt(isc_si->fd, SOL_SOCKET, SO_KEEPALIVE,       
		   (char *)&intbuf, sizeof(intbuf)) < 0)
    {
	perror("Can't turn on KEEPALIVE");
    }

    if (connect(isc_si->fd, (struct sockaddr *)&server, sizeof(server)) < 0
	|| (isc_si->in = fdopen(isc_si->fd, "r" )) == NULL 
	|| (isc_si->out = fdopen(isc_si->fd, "w")) == NULL )
    {
	close(isc_si->fd);
	return NULL;
    }
    setbuf(isc_si->in, NULL);
    setbuf(isc_si->out, NULL);
    
    return isc_si;
}


/*
 * Shut down the connection
 */
Success
isc_disconnect(ISC *isc_si)
{
    fclose(isc_si->in);		/* *** check retval */
    fclose(isc_si->out);	/* *** check retval */
    isc_free(isc_si);
    return OK;
}



/*
 * Wait for a message from the server. I opt_readset != NULL also wait for
 * messages on those fds.
 *
 * Return value:
 *	< 0	error
 *	> 0	there is a message from the server (and maybe also
 *		in opt_readset)
 *	= 0	there is a message in the opt_readset.
 */
int
isc_wait(ISC *isc_si,
	 int timeout,
	 fd_set *opt_readset)
{
    fd_set read_set;
    struct timeval wait;
    int nfds;


    /* Setup timeout structure */
    wait.tv_sec  = timeout / 1000;
    wait.tv_usec = (timeout * 1000) % 1000000;

    /* Setup file descriptor set */
    if ( opt_readset == NULL )
    {
	FD_ZERO(&read_set);
	opt_readset = &read_set;
    }
    FD_SET(isc_si->fd, opt_readset);

  
    nfds = select(FD_SETSIZE,
		  opt_readset,
		  (fd_set *) NULL,
		  (fd_set *) NULL,
		  &wait);


    return (nfds < 0 ? nfds : FD_ISSET(isc_si->fd, opt_readset));
}
 
    
