/***************************************
					$Header$

					
***************************************/


#ifndef ERR_H
#define ERR_H    /*+ To stop multiple inclusions. +*/

#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <stdarg.h>

static __inline__ void
std_err(const char *file,const char *func,int line,
	const char *fmt,...) {

  va_list args;

  if (!fmt)
    return;

  va_start(args,fmt);
  fprintf(stderr,"Error in file %s, function %s, line %d\n",file,func,line);
  if (errno) {
    perror(func);
    errno=0;
  }
  vfprintf(stderr,fmt,args);
  fflush(stderr);
  va_end(args);

}

void (*my_err)(const char *,const char *,int,const char *,...)=std_err;

#define err(a,b...) my_err(__FILE__,__FUNCTION__,__LINE__, a , ## b)

#define errret(a,b...) do {err(a,##b);return -1;} while(0)
#define errretv(a,b,c...) do {err(b,##c);return a;} while(0)
#define error(a,b...) do {err(a,##b);exit(-1);} while(0)

#endif /* ERR_H */
