/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX/HB9DRD
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT44FileReceive.h"
#include "JT44Defs.h"

#include "jt44gui/JT44App.h"

#include "common/SoundFile.h"
#include "common/Exception.h"

#include <wx/debug.h>
#include <wx/log.h>

CJT44FileReceive::CJT44FileReceive() :
CJT44Receive(),
m_fileName(wxEmptyString),
m_soundDev(NULL)
{
}

CJT44FileReceive::~CJT44FileReceive()
{
}

bool CJT44FileReceive::getEndTime()
{
	return false;
}

void CJT44FileReceive::setFileName(const wxString& fileName)
{
	wxASSERT(m_soundDev == NULL);

	m_fileName = fileName;

	m_soundDev = CSoundDev::createSoundDev(wxT("file"), fileName, JT44_SAMPLE_RATE, 16);
	m_soundDev->openRead();
}

void CJT44FileReceive::openSoundDevice()
{
	wxASSERT(m_soundDev != NULL);
}

void CJT44FileReceive::closeSoundDevice()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->close();
	delete m_soundDev;

	m_soundDev = NULL;
}

void CJT44FileReceive::recordAudio(const wxString& id, double* audioData, int length) const
{
	wxASSERT(audioData != NULL);
	wxASSERT(length > 0);
}

void CJT44FileReceive::receiveMessage(CJT44Message* message) const
{
	::wxGetApp().receiveFileMessage(message);
}

void CJT44FileReceive::showLevels(CJT44Levels* levels) const
{
	::wxGetApp().showFileLevels(levels);
}

wxString CJT44FileReceive::createId()
{
	wxString id = m_fileName;

	int pos = id.Find(wxT('/'), true);
	if (pos != -1) {
		wxString temp = id.Mid(pos + 1);
		id = temp;
	}

	pos = id.Find(wxT('.'));
	if (pos != -1) {
		wxString temp = id.Mid(0, pos);
		id = temp;
	}

	return id;
}

void CJT44FileReceive::error(const wxString& text)
{
        ::wxLogError(wxT("%ld: %s"), GetId(), text.c_str());

	::wxGetApp().error(text);
}
