/***************************************************************************
                          macros.cpp  -  description
                             -------------------
    begin                : Sam Mai 3 2003
    copyright            : (C) 2003 by Volker Schroer
    email                : dl1ksv@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "macrowindow.h"
#include <qpushbutton.h>
//#include <qbuttongroup.h>
#include "parameter.h"

#include "macros.h"

extern Parameter settings; 
myBox::myBox(QWidget *parent, const char *name = 0) :
QButtonGroup(1,Horizontal,parent,name)
{
}
void myBox::paintEvent(QPaintEvent *)
{
int width,height,y;
int anzahl = this->count();
width=this->width();
width=width-15;
y=5;
if (settings.ApplicationFont != 0)
 height=QFontMetrics(*settings.ApplicationFont).height();
else 
 height=QFontMetrics(this->font()).height();
for(int i=0; i < anzahl; i++)
 {
  QButton *pb; 
  pb=this->find(i);
//  if (settings.ApplicationFont != 0)
//   pb->setFont(*settings.ApplicationFont);

  pb->setGeometry(5,y,width,height);
//    pb->setFixedWidth(width);

    y=y+height+2;
 } 
}

myBox::~myBox()
{
}

MacroWindow::MacroWindow(QWidget *parent, const char *name ) : QScrollView(parent,name)
{
DisplayBox=new myBox(viewport());

//DisplayBox=new QVButtonGroup(viewport());
addChild(DisplayBox);
//DisplayBox->setMidLineWidth(1);
setResizePolicy(AutoOne);
verticalScrollBar()->setFixedWidth(16);
setVScrollBarMode(AlwaysOn);
setHScrollBarMode(AlwaysOff);
horizontalScrollBar()->setFixedHeight(16);
DisplayBox->setFixedWidth(this->width());
connect(DisplayBox,SIGNAL(clicked(int)),this,SIGNAL(callMacro(int)));
}
MacroWindow::~MacroWindow(){
}

void MacroWindow::resizeEvent( QResizeEvent * )
{
DisplayBox->setFixedWidth(this->width()-verticalScrollBar()->width());
/**
int width,height,y;
int anzahl = DisplayBox->count();
width=this->width();
width=width-verticalScrollBar()->width();

DisplayBox->setFixedWidth(width);
width=width-15;
y=5;
if (settings.ApplicationFont != 0)
 height=QFontMetrics(*settings.ApplicationFont).height();
else 
 height=QFontMetrics(this->font()).height();
for(int i=0; i < anzahl; i++)
 {
  QButton *pb; 
  pb=DisplayBox->find(i);
//  if (settings.ApplicationFont != 0)
//   pb->setFont(*settings.ApplicationFont);

//  pb->setGeometry(5,y,width,height);
//    pb->setFixedWidth(width);
    pb->move(5,y);
    y=y+height;
 }
**/  
}

void MacroWindow::updateMacroWindow(Macros *Macro)
{
QButton *pb;
int anzahl = DisplayBox->count();
int i,height,y;
if (settings.ApplicationFont != 0)
 height=QFontMetrics(*settings.ApplicationFont).height()+5;
else 
 height=QFontMetrics(this->font()).height()+5;
 
for(i=0; i < anzahl; i++)
 {
  pb=DisplayBox->find(i);
  DisplayBox->remove(pb);
  delete pb;
 }
 
anzahl= Macro->count(); 
//height=10+(height+5)*anzahl;
//DisplayBox->setFixedHeight(height);
y=5; 
for(i=0; i< anzahl;i++)
 {
  pb = new QPushButton(DisplayBox);
//  pb->setFixedHeight(height);
//  pb->move(5,y);
//  y=y+height+2;
  if ( !Macro->getAccelerator(i).isEmpty() )
   {
    pb->setAccel(QKeySequence(Macro->getAccelerator(i)));
    pb->setText(Macro->getMacroName(i)+" ("+Macro->getAccelerator(i)+")");    
   } 
  else
     pb->setText(Macro->getMacroName(i)); 
  pb->show();
 }

show(); 
}
void MacroWindow::fontChange(const QFont &)
{
 if (settings.ApplicationFont != 0)
 { 
  DisplayBox->setFont(*settings.ApplicationFont);
  int anzahl = DisplayBox->count();
  for(int i=0; i < anzahl; i++)
  {
   QButton *pb; 
   pb=DisplayBox->find(i);
   pb->setFont(*settings.ApplicationFont);
  }
 } 
 
}
