/***************************************************************************
                          csound.h  -  description
                             -------------------
    begin                : Wed Apr 5 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef CSOUND_H
#define CSOUND_H

#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <portaudio.h>

#include <qobject.h>

#include "input.h"
#include "constants.h"
/**Class for operating on SoundCard
  *@author Volker Schroer
  */
  
typedef struct {
    float *audiobuffer;
    int in;
    int out;
    int available;
    int maxbuf;
    } AudioBuffer;  
class CSound :public Input
{
public: 
	CSound(int ptt);
	~CSound();
	virtual bool open_Device_write(QString *);
	virtual bool open_Device_read(QString *);
	virtual bool close_Device();
        int getSamples(double *,int);				// Reading Samples from Soundcard
	int putSamples(double *,int);
	void PTT(bool);

private: // Private attributes
bool started;
bool output;    
PortAudioStream *stream;
double OldSampleRate;

AudioBuffer audio_buffer;
void saveSampleRate(PaDeviceID );
void restoreSampleRate();
        

};

#endif
