/*
    ldapdiff
    Copyright (C) 2000-2002 Thomas.Reith@rhoen.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <lber.h>
#include <ldap.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>

#include "ldapdiff.h"
#include "base64.h"

static int ldifparsebase64(char* s,char **val,size_t *val_len)
{
 *val = LDALLOC(strlen(s) * 4,sizeof(char));
 if((*val_len = b64_pton(s,(u_char*)*val,strlen(s) * 4)) == -1){
  fprintf(stderr,"b64_pton() failed: file: %s, line: %d\n",__FILE__,__LINE__);
  return -1;
 } 
 return 0;
}

static int ldifparseurl(char* s,char **val,size_t *val_len)
{
 if(strncasecmp("file://",s,strlen("file://")) == 0){
  FILE   *f;
  char   *fname;
  char   *buf[1024];
  size_t  bcount;
  size_t  bsum;

  fname = s+strlen("file://");
  if((f = fopen(fname,"r")) == NULL){
   fprintf(stderr,"fopen() of %s failed: file: %s, line: %d\n",fname,__FILE__,__LINE__);
    return -1;
  }

  bsum = 0;
  *val  = NULL;
  while((bcount = fread(buf,sizeof(char),1024,f)) > 0){
   if((*val = realloc(*val,sizeof(char)*(bsum+bcount))) == NULL){
    fprintf(stderr,"realloc() failed file:%s line:%d %s\n",__FILE__,__LINE__,strerror(errno));
    exit(-1);
   }
   memcpy(*val+bsum,buf,bcount);
   bsum += bcount;
  }
  ldiflog(LOG2,"ldifread: file [%s] with %d bytes read",fname,bsum);

  fclose(f);
  *val_len  = bsum;
  return 0;
 }
 else{
  fprintf(stderr,"ldifparseurl() failed (\"file://\") file: %s line: %d\n",__FILE__,__LINE__);
  return -1;
 }
}

int ldifparse(char *s,char **var,char **val,size_t *val_len,teattrtype *val_type)
{
 char *valtmp;

 if((valtmp = strchr(s,':')) == NULL){
  return -1;
 }

 *var = LDALLOC(valtmp - s + 1,sizeof(char));
 strncpy(*var,s,valtmp - s);
 (*var)[valtmp-s] = '\0';
 /* 
  not rfc2849 conform, but useful 
 */
 ldiftrim(*var);
 if(strlen(*var) == 0){
  return -1;
 }

 /* base64 encoded ldif attribute detected */
 if(strncmp(valtmp+1,": ",2) == 0){
  ldiflog(LOG2,"ldifread: base64 attribute detected attribute: %s",*var);
  *val_type = ATTRBIN;
  return ldifparsebase64(valtmp+3,val,val_len);
 }

 /* attributed with file:/// url detected  */
 if(strncmp(valtmp+1,"< ",2) == 0){
  ldiflog(LOG2,"ldifread: url attribute detected attribute: %s",*var);
  *val_type = ATTRBIN;
  return ldifparseurl(valtmp+3,val,val_len);
 }

 *val = LDALLOC(strlen(valtmp+2)*2,sizeof(char));
 if(strcmp(ldifgetgconf(CONFICONV),"yes") == 0){
  char *itmp;
  char *otmp;

  itmp = valtmp+2;
  otmp = *val;
  if(ldificonv(&itmp,&otmp) == -1){
   return -1;
  }
 }
 else{
  sprintf(*val,"%s",valtmp+2);
 }

 *val_len  = strlen(*val);
 *val_type = ATTRASC;
 if(strlen(*val) == 0){
  return -1;
 }

 return 0;
}
