#ifndef _KVI_XMMS_WIDGET_H_INCLUDED_
#define _KVI_XMMS_WIDGET_H_INCLUDED_

// =============================================================================
//
//   This is a plugin for the KVIrc IRC client
//   Copyright (C) 1999-2000 Szymon Stefanek (kvirc@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_dockablewidget.h"

class KviFrame;
class KviProcess;

class KviXmmsWidget : public KviDockableWidget
{
	Q_OBJECT
public:
	KviXmmsWidget(void *handle, KviStatusBar *parent, KviFrame *frame);
	~KviXmmsWidget();
protected slots:
	void processExited(KviProcess *);
protected:
	KviFrame *m_pFrm;
	int  m_mousePressX;
	int  m_timer;
	bool m_bIsPlaying;
	bool m_bIsRunning;
	int  m_iPlaylistPos;
	int  m_iPlaylistLen;

	virtual void paintEvent(QPaintEvent *);
	virtual void mousePressEvent(QMouseEvent *);
	virtual void mouseReleaseEvent(QMouseEvent *);
	virtual void timerEvent(QTimerEvent *);
	void sayWhatIsPlayed();
};

#define KVI_XMMS_UPDATE_TIME 500

#endif // _KVI_XMMS_WIDGET_H_INCLUDED_
