#ifndef _KVI_IMAGE_VIEW_H_INCLUDED_
#define _KVI_IMAGE_VIEW_H_INCLUDED_

// =============================================================================
//
//   This is a plugin for the KVIrc IRC client
//   Copyright (C) 1999-2000 Szymon Stefanek (kvirc@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qscrollview.h>

class QImage;
class QPixmap;

class KviImageView : public QScrollView
{
	Q_OBJECT
public:
	KviImageView(QWidget *parent);
	~KviImageView();
protected:
	QPixmap *m_pOriginalPixmap;
	QImage  *m_pViewedImage;
	unsigned int m_uZoom;
public:
	bool loadImage(const char *fName);
	unsigned int zoom();
	void setZoom(unsigned int zoom);
protected:
	virtual void drawContents(QPainter *p, int clipx, int clipy, int clipw, int cliph);
};

#endif // _KVI_IMAGE_VIEW_H_INCLUDED_
