#ifndef _KVI_SCRIPT_OBJECTCONTROLLER_H_INCLUDED_
#define _KVI_SCRIPT_OBJECTCONTROLLER_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

class KviFrame;
class KviScriptObject;
class KviScriptObjectClassDefinition;
class KviStr;
class KviUserParser;
class KviWindow;

class KviScriptObjectController
{
	friend class KviScriptObject;
public:
	KviScriptObjectController(KviUserParser *);
	~KviScriptObjectController();
protected:
	KviUserParser   *m_pUserParser;
	KviScriptObject *m_pTopLevelObject;
public:
	KviFrame *mainFrame();

	KviScriptObject *topLevelObject();
	void getUniqueId(KviStr &idBuf);

	/**  Lookup a GLOBAL object */
	KviScriptObject *findObjectById(const char *szId);
	KviScriptObject *findLocalObjectByClass(const char *szClass);

	bool isKnownObjectClass(const char *szClass);

	KviScriptObject *allocateObject(
		const char *szClass, const char *szName, KviScriptObject *par, QPtrList<KviStr> *params, bool *pbDeletedParams
	);

	KviScriptObjectClassDefinition *lookupClassDefinition(const char *szClass);

	/**
	 * Remove all the objects of all the controllers.
	 * Remove all the classes and recreate the built-in ones.
	 * Then recreate the toplevel objects.
	 */
	void globalReset();

	/**
	 * Remove all objects with a specific class.
	 */
	bool killClass(const char *szClassName);

	void dumpClasses(KviWindow *wnd);
	void dumpObjects(KviWindow *wnd);
private:
	void killClass(KviScriptObjectClassDefinition *);
	void killAllLocalObjectsWithClass(const char *szClassName);
	void allocateBuiltInClassDefinitions();
	void localCleanup();
	void createTopLevelObject();
};

inline bool KviScriptObjectController::isKnownObjectClass(const char *szClass)
{
	return (lookupClassDefinition(szClass) != 0);
}

#endif // _KVI_SCRIPT_OBJECTCONTROLLER_H_INCLUDED_
