// =============================================================================
//
//      --- kvi_options_scriptcenter.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsScriptCenter"

#include <qlayout.h>

#include "kvi_boolselector.h"
#include "kvi_locale.h"
#include "kvi_options.h"
#include "kvi_options_scriptcenter.h"

/*
	@quickhelp: KviOptionsScriptCenter
	@widget: Script center options
*/
KviOptionsScriptCenter::KviOptionsScriptCenter(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_SCRIPTCENTER)
{
	QGridLayout *g = new QGridLayout(
		this, 4, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, KVI_GENERAL_OPTIONS_GRIDLAYOUT_SPACE
	);

	KviBoolSelector *b = new KviBoolSelector(this,
		_i18n_("Show as toplevel dialog"), &(g_pOptions->m_bScriptCenterShowAsDialog)
	);
	g->addWidget(b, 0, 0);
	b = new KviBoolSelector(this, _i18n_("Include the Help Browser tab"), &(g_pOptions->m_bScriptCenterAddHelpBrowser));
	g->addWidget(b, 1, 0);
	b = new KviBoolSelector(this,
		_i18n_("Automatically save changes to disk when dialog is closed"), &(g_pOptions->m_bScriptCenterAutoSaveWhenAccepted)
	);
	g->addWidget(b, 2, 0);

	// Trick
	QFrame *f = new QFrame(this);
	g->addWidget(f, 3, 0);
	g->setRowStretch(3, 1);
}

KviOptionsScriptCenter::~KviOptionsScriptCenter()
{
	// Nothing here
}

void KviOptionsScriptCenter::commitChanges()
{
	KviBoolSelector::commitAll(this);
}

#include "m_kvi_options_scriptcenter.moc"
