#ifndef _KVI_WINPROPERTIES_H_INCLUDED_
#define _KVI_WINPROPERTIES_H_INCLUDED_

// =============================================================================
//
//      --- kvi_winproperties.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>
#include <qrect.h>

#include "kvi_string.h"

typedef struct KviWindowPackedProperty
{
	KviStr name;
	KviStr property;
};

typedef struct KviWindowProperty
{
	QRect rect;
	int   isDocked;
	int   timestamp;
	int   imagesVisible;
	int   splitWidth1;
	int   splitWidth2;
	int   topSplitWidth1;
	int   topSplitWidth2;
	int   topSplitWidth3;
	int   isMaximized;
};

class KviWindowPropertiesList
{
public:
	KviWindowPropertiesList();
	~KviWindowPropertiesList();
protected:
	QPtrList<KviWindowPackedProperty> *m_pPropertiesList;
public:
	KviWindowPackedProperty *findProperty(const char *winName);

	void    setProperty(const char *winName, KviWindowProperty  *prop);
	void   packProperty(KviWindowProperty *prop, KviWindowPackedProperty *packed);
	void unpackProperty(KviWindowProperty *prop, KviWindowPackedProperty *packed);

	bool load(const char *filename, KviStr &error);
	bool save(const char *filename);
};

#endif // _KVI_WINPROPERTIES_H_INCLUDED_
