// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#ifndef _KVI_MIRCCNTRL_CPP_
#define _KVI_MIRCCNTRL_CPP_

#include <qstring.h>

#include "kvi_mirccntrl.h"

/**
 * Scans the data_ptr for a mIrc color code XX,XX
 * and fills the color values in the two bytes.
 */
const char *getColorBytes(const char *data_ptr, unsigned char *byte_1, unsigned char *byte_2)
{
	// First we can have a digit or a coma
	if( ((*data_ptr >= '0') && (*data_ptr <= '9')) ) {
		// Something interesting
		(*byte_1) = (*data_ptr) - '0'; // Store the code
		data_ptr++;                    // And check the next
		if( ((*data_ptr >= '0') && (*data_ptr <= '9')) || (*data_ptr == ',') ) {
			// Yes, we can understand it
			if( *data_ptr == ',' ) {
				// A comma; need to check for background
				data_ptr++;
			} else {
				// A number
				(*byte_1) = ((((*byte_1)*10) + ((*data_ptr) - '0')) % 16);
				data_ptr++;
				if( *data_ptr == ',' ) {
					// A comma; need to check for background
					data_ptr++;
				} else {
					// Senseless, return
					(*byte_2) = KVI_NOCHANGE;
					return data_ptr;
				}
			}
		} else {
			// Senseless character control code: OK and return
			(*byte_2) = KVI_NOCHANGE;
			return data_ptr;
		}
	} else {
		// Senseless character; only a CTRL+K code
		(*byte_1) = KVI_NOCHANGE;
		(*byte_2) = KVI_NOCHANGE;
		return data_ptr;
	}

	if( (*data_ptr >= '0') && (*data_ptr <= '9') ) {
		// Background, a color code
		(*byte_2) = (*data_ptr) - '0';
		data_ptr++;
		if( (*data_ptr >= '0') && (*data_ptr <= '9') ) {
			(*byte_2) = ((((*byte_2)*10) + ((*data_ptr) - '0')) % 16);
			data_ptr++;
		}
		return data_ptr;
	} else {
		(*byte_2) = KVI_NOCHANGE;
		return data_ptr;
	}
}

/**
 * Scans the data_ptr for a mIrc color code XX,XX
 * and fills the color values in the two bytes.
 */
const Q_UINT16 *getColorBytesW(const Q_UINT16 *data_ptr, unsigned char *byte_1, unsigned char *byte_2)
{
	// First we can have a digit or a comma
	if( ((*data_ptr >= '0') && (*data_ptr <= '9')) ) {
		// Something interesting
		(*byte_1) = ((*data_ptr) - '0'); // Store the code
		data_ptr++;                      // And check the next
		if( ((*data_ptr >= '0') && (*data_ptr <= '9')) || (*data_ptr == ',') ) {
			// Yes, we can understand it
			if( *data_ptr == ',' ) {
				// A comma, need to check for background
				data_ptr++;
			} else {
				// A number
				(*byte_1) = ((((*byte_1)*10) + ((*data_ptr) - '0')) % 16);
				data_ptr++;
				if( *data_ptr == ',' ) {
					// A comma, need to check for background
					data_ptr++;
				} else {
					// Senseless, return
					(*byte_2) = KVI_NOCHANGE;
					return data_ptr;
				}
			}
		} else {
			// Senseless character control code: OK and return
			(*byte_2) = KVI_NOCHANGE;
			return data_ptr;
		}
	} else {
		// Senseless character; only a CTRL+K code
		(*byte_1) = KVI_NOCHANGE;
		(*byte_2) = KVI_NOCHANGE;
		return data_ptr;
	}

	if( (*data_ptr >= '0') && (*data_ptr <= '9') ) {
		// Background, a color code
		(*byte_2) = (*data_ptr) - '0';
		data_ptr++;
		if( (*data_ptr >= '0') && (*data_ptr <= '9') ) {
			(*byte_2) = ((((*byte_2)*10) + ((*data_ptr) - '0')) % 16);
			data_ptr++;
		}
		return data_ptr;
	} else {
		(*byte_2) = KVI_NOCHANGE;
		return data_ptr;
	}
}

/**
 * Scans the szData for a mIrc color code XX,XX
 * and fills the color values in the two bytes.
 */
unsigned int getUnicodeColorBytes(const QString &szData, unsigned int charIdx, unsigned char *byte_1, unsigned char *byte_2)
{
	if( charIdx >= szData.length() ) {
		(*byte_1) = KVI_NOCHANGE;
		(*byte_2) = KVI_NOCHANGE;
		return charIdx;
	}
	unsigned short c = szData[charIdx].unicode();

	// First we can have a digit or a coma
	if( ((c < '0') || (c > '9')) ) {
		// Senseless; only a CTRL+K code
		(*byte_1) = KVI_NOCHANGE;
		(*byte_2) = KVI_NOCHANGE;
		return charIdx;
	}

	// Something interesting
	(*byte_1) = c - '0'; // Store the code
	charIdx++;
	if( charIdx >= szData.length() ) {
		(*byte_2) = KVI_NOCHANGE;
		return charIdx;
	}

	c = szData[charIdx].unicode();

	if( ((c < '0') || (c > '9')) && (c != ',') ) {
		(*byte_2) = KVI_NOCHANGE;
		return charIdx;
	}

	if( (c >= '0') && (c <= '9') ) {
		(*byte_1) = (((*byte_1)*10) + (c - '0')) % 16;
		charIdx++;
		if( charIdx >= szData.length() ) {
			(*byte_2) = KVI_NOCHANGE;
			return charIdx;
		}
		c = szData[charIdx].unicode();
	}

	if( c == ',' ) {
		charIdx++;
		if( charIdx >= szData.length() ) {
			(*byte_2) = KVI_NOCHANGE;
			return charIdx;
		}
		c = szData[charIdx].unicode();
	}

	if( (c < '0') || (c > '9') ) {
		(*byte_2) = KVI_NOCHANGE;
		return charIdx;
	}

	// Background, a color code
	(*byte_2) = c - '0';
	charIdx++;
	if( charIdx >= szData.length() )
		return charIdx;
	c = szData[charIdx].unicode();

	if( (c >= '0') && (c <= '9') ) {
		(*byte_2) = (((*byte_2)*10) + (c - '0')) % 16;
		charIdx++;
	}

	return charIdx;
}

#endif // _KVI_MIRCCNTRL_CPP_
