/***************************************************************************
                          fileoperation.h  -  description
                             -------------------
    begin                : Sun Nov 11 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILEOPERATION_H
#define FILEOPERATION_H

#include <qobject.h>
#include <kio/jobclasses.h>
#include <kurl.h>

class QString;
class FileOperation: public QObject {
    Q_OBJECT
    public:
        FileOperation();
        ~FileOperation();

        bool start( KURL src, KURL dest, int mode, bool overwrite );
        bool fcopy( QString src, QString dest );
        QString error() { return m_error; }
        
        static QString getName( QString file );

    private slots:
        void slotResult( KIO::Job * job );

    private:
        bool locked;
        bool canceled;
        int result;

        QString m_error;
};

#endif
