/*******************************************************************************
**                          timeinterval.h
**                             part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/
#ifndef TIMEINTERVAL_H
#define TIMEINTERVAL_H

// Qt includes
#include <qstring.h>

// My includes

////////////////////////////////////////////////////////////////////////////////
//////////                  class TimeInterval                           ///////
////////////////////////////////////////////////////////////////////////////////

class TimeInterval
{
public:

    // Values for measurement
    static const unsigned int TIME_SEC  = 0;
    static const unsigned int TIME_MIN  = 1;
    static const unsigned int TIME_HOUR = 2;
    static const unsigned int TIME_DAY  = 3;

    TimeInterval( unsigned int value, unsigned int measurement );
    TimeInterval( unsigned int value, QString measurment);
    TimeInterval( const TimeInterval& t );
    ~TimeInterval();

    unsigned int secs() const { return mSecs; }
    unsigned int value() const;
    QString      measurement() const ;
    int          measurement( int dummy ) const
        { dummy++; return mMeasurement; }

private:
    unsigned int mSecs;
    unsigned int mMeasurement;
};

#endif
