/*******************************************************************************
**                             main.cpp
**                             part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/

// KDE includes
#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kwin.h>
#include <ktip.h>

// My includes
#include "config.h"
#include "konserve.h"
#include "configurationdlg.h"

static const char *description = I18N_NOOP(
    "A backup application that lives in the system tray"
    );

static const char *version = "0.10.3";

static KCmdLineOptions options[] =
{
    { 0, 0, 0 }
};

int main(int argc, char **argv)
{
    KAboutData about( "konserve",
                      I18N_NOOP( "Konserve" ),
                      version,
                      description,
                      KAboutData::License_GPL,
                      "(C) 2002 - 2004 Florian Simnacher",
                      0,
                      0,
                      "simnacher AT gmx DOT de" );

    about.addAuthor( "Florian Simnacher", 0, "simnacher AT gmx DOT de" );
    about.addAuthor( "Michael Bieligk", I18N_NOOP("Graphics"), "bikeB AT gmx DOT de" );
    about.addAuthor( "Kjell Morgenstern", I18N_NOOP("Drag-and-Drop support"), "" );
    about.addAuthor( "Janne Lähteenmäki", I18N_NOOP("Implemented check, if files have changed"), "" );

    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);

    KUniqueApplication::addCmdLineOptions();
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    if (!KUniqueApplication::start())
    {
        fprintf(stderr, "konserve is already running!\n");
        return 0;
    }

    KUniqueApplication app;

    // KApplication app;

    Konserve *konserve = new Konserve;
    app.setMainWidget( konserve );
    KWin::setSystemTrayWindowFor(konserve->winId(), 0);

    KTipDialog::showTip();

    konserve->show();
    args->clear();

    return app.exec();
}
