/* @(#) bigbuf.c 1.6 @(#) */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: VM
\***************************************************************/

#define _KOALAMUD_BIGBUF_C "@(#) nitehawk@winghove.1ststep.net|lib/vm/bigbuf.c|20000313060815|60214 @(#)"

#include "autoconf.h"
#include <sys/stat.h>

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"

#include "module.h"
#include "vm.h"
#include "vminternal.h"

/* This file handles allocation and management of the big arena buffer */

/* Global variables */
module_t bigbufmodule =
{
	"BigBuf handler",
	"@(#) bigbuf.c 1.6 @(#)",
	MODSTATE_UNDEFINED,
	bigbufstartup,
	bigbuflinkup,
	bigbufshutdown
};

/********************************
 * State Control				*
 *******************************/
/* Speed is not critical for the state control functions, as they are only
 * going to be called during startup and shutdown. */
/* bigbufstartup - initialize bigbuf state variables */
int bigbufstartup(void)
{
	/* Must either be undefined - meaning we have not done a startup this run,
	 * or stopped, meaning we are restarting during the same binary run */
	if (!(bigbufmodule.state == MODSTATE_UNDEFINED ||
			bigbufmodule.state == MODSTATE_STOPPED))
		return VMBADSTATE;
	/* Reflect that we are starting up */
	bigbufmodule.state = MODSTATE_STARTUPINPROGRESS;

	/* Startup code goes here */

	/* All done with startup */
	bigbufmodule.state = MODSTATE_STARTED;

	/* Everything happy :) */
	return VMSUCCESS;
}

/* bigbuflinkup - Allocate big memory arena buffer and setup hash tables
 */
int bigbuflinkup(void)
{
	/* If the current state is not 'STARTED', then we are not prepared to do
	 * the linkup */
	if (bigbufmodule.state != MODSTATE_STARTED)
		return VMBADSTATE;
	/* show that we are doing linkup */
	bigbufmodule.state = MODSTATE_LINKUPINPROGRESS;

	/* Linkup complete */
	bigbufmodule.state = MODSTATE_LINKED;

	/* Everything happy :) */
	return VMSUCCESS;
}

/* bigbufshutdown - Free all hash tables and the big memory arena
 */
int bigbufshutdown(void)
{
	/* Can't shutdown unless we are currently 'linked' */
	if (bigbufmodule.state != MODSTATE_LINKED)
		return VMBADSTATE;
	/* show that we are doing shutdown */
	bigbufmodule.state = MODSTATE_SHUTDOWNINPROGRESS;

	/* shutdown complete */
	bigbufmodule.state = MODSTATE_STOPPED;

	/* Everything happy :) */
	return VMSUCCESS;
}
