h20260
s 00022/00014/00073
d D 1.6 00/03/12 22:08:15 nitehawk 7 6
c Update to new module definition format
cC
cK60214
e
s 00002/00002/00085
d D 1.5 00/03/12 09:31:57 nitehawk 6 5
c Fix startup state check
cC
cK51280
e
s 00027/00017/00060
d D 1.4 00/03/07 23:01:36 nitehawk 5 4
c modstate is now a simple enum
c All module state change functions now have an error return
cC
cK51110
e
s 00042/00002/00035
d D 1.3 00/03/07 13:04:04 nitehawk 4 3
c Added state control to ensure that state change functions do
c not get called at the wrong times.
cC
cK42550
e
s 00014/00001/00023
d D 1.2 00/03/07 11:53:51 nitehawk 3 2
c Setup basic outline for vm driver state change functions
cC
cK53989
e
s 00024/00000/00000
d D 1.1 00/03/06 22:32:50 nitehawk 2 1
cF1
cK39814
cO-rw-rw-rw-
e
s 00000/00000/00000
d D 1.0 00/03/06 22:32:50 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/lib/vm/bigbuf.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK28516
cPlib/vm/bigbuf.c
cRfb9b228e5682f3b2
cV2
cX0xa1
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
D 3
*	Copyright (c) 1999 First Step Internet Services, Inc.
E 3
I 3
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
E 3
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: VM
\***************************************************************/

#define _KOALAMUD_BIGBUF_C "%Z% %K% %Z%"

#include "autoconf.h"
#include <sys/stat.h>

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"

I 4
#include "module.h"
#include "vm.h"
I 5
#include "vminternal.h"
E 5

E 4
/* This file handles allocation and management of the big arena buffer */

I 4
/* Global variables */
D 5
modstate_t bigbufmodstate = {MODSTATE_UNDEFINED};
E 5
I 5
D 7
modstate_t bigbufmodstate = MODSTATE_UNDEFINED;
E 7
I 7
module_t bigbufmodule =
{
	"BigBuf handler",
	"%Z% %M% %I% %Z%",
	MODSTATE_UNDEFINED,
	bigbufstartup,
	bigbuflinkup,
	bigbufshutdown
};
E 7
E 5

/********************************
 * State Control				*
 *******************************/
/* Speed is not critical for the state control functions, as they are only
 * going to be called during startup and shutdown. */
E 4
I 3
/* bigbufstartup - initialize bigbuf state variables */
E 3
D 5
void bigbufstartup(void)
E 5
I 5
D 7
vmerr_t bigbufstartup(void)
E 7
I 7
int bigbufstartup(void)
E 7
E 5
I 3
{
I 4
	/* Must either be undefined - meaning we have not done a startup this run,
	 * or stopped, meaning we are restarting during the same binary run */
D 5
	if (bigbufmodstate.status != MODSTATE_UNDEFINED ||
			bigbufmodstate.status != MODSTATE_STOPPED)
		return;
E 5
I 5
D 6
	if (bigbufmodstate != MODSTATE_UNDEFINED ||
			bigbufmodstate != MODSTATE_STOPPED)
E 6
I 6
D 7
	if (!(bigbufmodstate == MODSTATE_UNDEFINED ||
			bigbufmodstate == MODSTATE_STOPPED))
E 7
I 7
	if (!(bigbufmodule.state == MODSTATE_UNDEFINED ||
			bigbufmodule.state == MODSTATE_STOPPED))
E 7
E 6
		return VMBADSTATE;
E 5
	/* Reflect that we are starting up */
D 5
	bigbufmodstate.status = MODSTATE_STARTUPINPROGRESS;
E 5
I 5
D 7
	bigbufmodstate = MODSTATE_STARTUPINPROGRESS;
E 7
I 7
	bigbufmodule.state = MODSTATE_STARTUPINPROGRESS;
E 7
E 5

	/* Startup code goes here */

	/* All done with startup */
D 5
	bigbufmodstate.status = MODSTATE_STARTED;
E 5
I 5
D 7
	bigbufmodstate = MODSTATE_STARTED;
E 7
I 7
	bigbufmodule.state = MODSTATE_STARTED;
E 7

	/* Everything happy :) */
	return VMSUCCESS;
E 5
E 4
}

D 4
/* bigbuflinkup - 
E 4
I 4
/* bigbuflinkup - Allocate big memory arena buffer and setup hash tables
E 4
 */
D 5
void bigbuflinkup(void)
E 5
I 5
D 7
vmerr_t bigbuflinkup(void)
E 7
I 7
int bigbuflinkup(void)
E 7
E 5
{
I 4
	/* If the current state is not 'STARTED', then we are not prepared to do
	 * the linkup */
D 5
	if (bigbufmodstate.status != MODSTATE_STARTED)
		return;
E 5
I 5
D 7
	if (bigbufmodstate != MODSTATE_STARTED)
E 7
I 7
	if (bigbufmodule.state != MODSTATE_STARTED)
E 7
		return VMBADSTATE;
E 5
	/* show that we are doing linkup */
D 5
	bigbufmodstate.status = MODSTATE_LINKUPINPROGRESS;
E 5
I 5
D 7
	bigbufmodstate = MODSTATE_LINKUPINPROGRESS;
E 7
I 7
	bigbufmodule.state = MODSTATE_LINKUPINPROGRESS;
E 7
E 5

	/* Linkup complete */
D 5
	bigbufmodstate.status = MODSTATE_LINKED;
E 5
I 5
D 7
	bigbufmodstate = MODSTATE_LINKED;
E 7
I 7
	bigbufmodule.state = MODSTATE_LINKED;
E 7

	/* Everything happy :) */
	return VMSUCCESS;
E 5
E 4
}

D 4
/* bigbufshutdown - 
E 4
I 4
/* bigbufshutdown - Free all hash tables and the big memory arena
E 4
 */
D 5
void bigbufshutdown(void)
E 5
I 5
D 7
vmerr_t bigbufshutdown(void)
E 7
I 7
int bigbufshutdown(void)
E 7
E 5
E 3
{
I 4
	/* Can't shutdown unless we are currently 'linked' */
D 5
	if (bigbufmodstate.status != MODSTATE_LINKED)
		return;
E 5
I 5
D 7
	if (bigbufmodstate != MODSTATE_LINKED)
E 7
I 7
	if (bigbufmodule.state != MODSTATE_LINKED)
E 7
		return VMBADSTATE;
E 5
	/* show that we are doing shutdown */
D 5
	bigbufmodstate.status = MODSTATE_SHUTDOWNINPROGRESS;
E 5
I 5
D 7
	bigbufmodstate = MODSTATE_SHUTDOWNINPROGRESS;
E 7
I 7
	bigbufmodule.state = MODSTATE_SHUTDOWNINPROGRESS;
E 7
E 5

	/* shutdown complete */
D 5
	bigbufmodstate.status = MODSTATE_STOPPED;
E 5
I 5
D 7
	bigbufmodstate = MODSTATE_STOPPED;
E 7
I 7
	bigbufmodule.state = MODSTATE_STOPPED;
E 7

	/* Everything happy :) */
	return VMSUCCESS;
E 5
E 4
}
E 2
I 1
E 1
