/* @(#) init.c 1.5 @(#) */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: KoalaMod
\***************************************************************/

#define _KOALAMUD_INIT_C "@(#) nitehawk@winghove.1ststep.net|lib/koalamod/init.c|20001105050816|57456 @(#)"

#include "autoconf.h"
#include <sys/stat.h>
#include <dlfcn.h>

#include "version.h"
#include "module.h"
#include "llist.h"
#include "log.h"
#include "kparser.h"
#include "modcommands.h"

/* Really create vars */
functable_t functab;
moduleinfo_t modinf;

/* register module handler commands */
void registermodulecommands(void)
{
	char cmdname[100] = "loadmodule";
	commandentry cmd;
	cmd.next = NULL;
	cmd.command = cmdname;
	cmd.handler = do_loadmod;
	cmd.commandtype = CMD_MODULE;
	cmd.numargs = 0;
	cmd.arglist = NULL;
	cmd.unlock = NULL;
	registercommand(&cmd, NULL);

	strcpy(cmdname, "unloadmod");
	cmd.handler = do_unloadmod;
	registercommand(&cmd, NULL);

	strcpy(cmdname, "modlist");
	cmd.handler = do_modlist;
	registercommand(&cmd, NULL);

}

/* This file contains the code that initializes the dynamic loader */
void modinfoinit(void)
{
	/* Register module based commands */
	registermodulecommands();

	/* Fill in module info table */
	modinf.pdopts = &koptions;
	modinf.pdstate = &kstate;
	modinf.pfunc = &functab;

	/* Fill in function table */
	functab.modstartup = &modstartup;
	functab.modlinkup = &modlinkup;
	functab.modshutdown = &modshutdown;

	functab.logmsg = &logmsg;
}
