h00390
s 00041/00006/00140
d D 1.3 00/11/04 21:08:16 nitehawk 4 3
c Move do_modlist to modcommands.c in koalamod
cC
cK13706
e
s 00000/00239/00146
d D 1.2 00/11/04 20:41:50 nitehawk 3 2
c Only need load/unloadmods
cC
cK07855
e
s 00385/00000/00000
d D 1.1 00/11/04 20:31:32 nitehawk 2 1
cF1
cK55895
cO-rw-rw-r--
e
s 00000/00000/00000
d D 1.0 00/11/04 20:31:32 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/src/koalamud/lib/koalamod/modcommands.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK44220
cPlib/koalamod/modcommands.c
cRdf94b735d658e839
cV3
cX0x80
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: COMMANDS
\***************************************************************/

#define _KOALAMUD_COMMANDINFO_C "%Z% %K% %Z%"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "network.h"
#include "buffer.h"
#include "commands.h"
#include "uplinkprotocol.h"
#include "memory.h"
#include "llist.h"
#include "module.h"
#include "kparser.h"

D 3
/* Quit Command */
koalaerror do_quit(pdescriptor desc, argument *arglist[])
{
	char *quitmsg = "Thank you for trying KoalaMud\r\n";

	buffer_queue(desc, quitmsg, strlen(quitmsg));
	/* Make sure the buffer is emptied */
	buffer_sendbytes(desc, OUTRINGSIZE);

	desc->status = STATUS_CLOSE;

	return KESUCCESS;
}

/* Reboot command */
/* FIXME: we should accept a timer and wait until that time to send the
 * shutdown message to the appropriate node or set the shutdown flag
 */
koalaerror do_reboot(pdescriptor desc, argument *arglist[])
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;
	int timer = 0;
	unsigned int destnode = 0;
	message_data msgdat;
	listnodeptr tmplist;
	pdescriptor tmpdesc;

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
		line = kmalloc(len, ALLOC_TEMP);
		if (!line)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
			kmfree(line, ALLOC_TEMP);
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* We now have up to 10 arguments. argv[0] is the timer, argv[1] is the
	 * destination node to shutdown */
	if (argc == 0)
	{
		// No arguments, just shutdown current node right now
		kstate.running = DSTATE_REBOOT;
		kmfree(line, ALLOC_TEMP);
		return KESUCCESS;
	}
	else if (argc == 1)
	{
		destnode = (unsigned int)strtoul(argv[0], NULL, 10);
	}
	else if (argc >= 2)
	{
		timer = atoi(argv[0]);
		destnode = (unsigned int)strtoul(argv[1], NULL, 10);
	}

	if (destnode != 0)
	{
		tmplist = getdescriptorlist();
		for (;tmplist; tmplist = listnextnode(tmplist))
		{
			tmpdesc = tmplist->data.desc;
			
			if (tmpdesc->type == DESCRIPTOR_HUBSRV ||
					tmpdesc->type == DESCRIPTOR_ZONESRV ||
					tmpdesc->type == DESCRIPTOR_CLIENTSRV)
			{
				msgdat.data = NULL;
				uplinksendmessage(tmpdesc, destnode, MSGTYPE_REBOOT, &msgdat,
						0);
				kmfree(line, ALLOC_TEMP);
				return KESUCCESS;
			}
		}
	}

	/* We don't handle the timer yet */
	kstate.running = DSTATE_REBOOT;
	kmfree(line, ALLOC_TEMP);

	return KESUCCESS;
}

/* Shutdown command */
/* FIXME: we should accept a timer and wait until that time to send the
 * shutdown message to the appropriate node or set the shutdown flag
 */
koalaerror do_shutdown(pdescriptor desc, argument *arglist[])
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;
	int timer = 0;
	unsigned int destnode = 0;
	message_data msgdat;
	listnodeptr tmplist;
	pdescriptor tmpdesc;

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
		line = kmalloc(len, ALLOC_TEMP);
		if (!line)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
			kmfree(line, ALLOC_TEMP);
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* We now have up to 10 arguments. argv[0] is the timer, argv[1] is the
	 * destination node to shutdown */

	if (argc >= 2)
	{
		timer = atoi(argv[0]);
		destnode = (unsigned int)strtoul(argv[1], NULL, 10);
	}
	else if (argc == 1)
	{
		destnode = (unsigned int)strtoul(argv[0], NULL, 10);
	}
	else if (argc == 0)
	{
		// No arguments, just shutdown current node right now
		kstate.running = DSTATE_SHUTDOWN;
		kmfree(line, ALLOC_TEMP);
		return KESUCCESS;
	}

	if (destnode != 0)
	{
		tmplist = getdescriptorlist();
		for (;tmplist; tmplist = listnextnode(tmplist))
		{
			tmpdesc = tmplist->data.desc;
			
			if (tmpdesc->type == DESCRIPTOR_HUBSRV ||
					tmpdesc->type == DESCRIPTOR_ZONESRV ||
					tmpdesc->type == DESCRIPTOR_CLIENTSRV)
			{
				msgdat.data = NULL;
				uplinksendmessage(tmpdesc, destnode, MSGTYPE_SHUTDOWN, &msgdat,
						0);
				kmfree(line, ALLOC_TEMP);
				return KESUCCESS;
			}
		}
	}

	/* We don't handle the timer yet */
	kstate.running = DSTATE_SHUTDOWN;
	kmfree(line, ALLOC_TEMP);

	return KESUCCESS;
}

/* Display memory status */
koalaerror do_memstat(pdescriptor desc, argument *arglist[])
{
	char buf[120];

	snprintf(buf, 120, "Generic memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_GENERIC].allocsize,
			memstate[ALLOC_GENERIC].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf, 120, "Database memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_DATABASE].allocsize,
			memstate[ALLOC_DATABASE].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf,120, "Descriptor memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_DESCRIPTOR].allocsize,
			memstate[ALLOC_DESCRIPTOR].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf, 120, "Temporary memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_TEMP].allocsize,
			memstate[ALLOC_TEMP].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf,120,"Linked List memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_LLIST].allocsize,
			memstate[ALLOC_LLIST].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	return KESUCCESS;
}

E 3
koalaerror do_loadmod(pdescriptor desc, argument *arglist[])
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;
D 4
	char buf[256];
E 4

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
		line = kmalloc(len, ALLOC_TEMP);
		if (!line)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
			kmfree(line, ALLOC_TEMP);
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* Make sure we have an argument */
	if (argc < 2)
	{
D 4
		snprintf(buf, 256, "Huh?");
		buffer_queue(desc, buf, strlen(buf));
E 4
I 4
		buffer_queue(desc, UNKNOWNCOMMANDRESPONSE,
				strlen(UNKNOWNCOMMANDRESPONSE));
E 4
		return KESUCCESS;
	}

	/* Unload the module */
	loadmodule(argv[0], argv[1], MODTYPE_GENERIC, desc);

	/* Free line buffer */
	kmfree(line, ALLOC_TEMP);

	return KESUCCESS;
}

koalaerror do_unloadmod(pdescriptor desc, argument *arglist[])
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;
D 4
	char buf[256];
E 4

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
		line = kmalloc(len, ALLOC_TEMP);
		if (!line)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
			kmfree(line, ALLOC_TEMP);
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* Make sure we have an argument */
	if (argc == 0)
	{
D 4
		snprintf(buf, 256, "Huh?");
		buffer_queue(desc, buf, strlen(buf));
E 4
I 4
		buffer_queue(desc, UNKNOWNCOMMANDRESPONSE,
				strlen(UNKNOWNCOMMANDRESPONSE));
E 4
		return KESUCCESS;
	}

	/* Unload the module */
	unloadmodule(argv[0], desc);

	/* Free Line Buffer */
	kmfree(line, ALLOC_TEMP);
I 4

	return KESUCCESS;
}

/* modlist - Display a list of loaded modules */
koalaerror do_modlist(pdescriptor desc, argument *arglist[])
{
	listnodeptr modlist;
	char buf[256];
	dynmod_t *pmod;

	/* Get a pointer to the loaded module list */
	if ((modlist = getmodlisthead()) == NULL)
	{
		snprintf(buf, 256, "No modules loaded.\r\n");
		buffer_queue(desc, buf, strlen(buf));
		return KESUCCESS;
	}

	/* Display header */
	snprintf(buf, 256,
"Module Name\tFull Name\t\tVersion\r\n"
"-----------\t---------\t\t-------\r\n");
	buffer_queue(desc, buf, strlen(buf));

	/* Cycle through modules and display information */
	while (modlist)
	{
		pmod = (dynmod_t *)modlist->data.generic;
		if (pmod == NULL)
			break;
		snprintf(buf, 256, "%s\t%s\t\t%s\r\n", pmod->modname,
				pmod->module.name, pmod->module.version);
		buffer_queue(desc, buf, strlen(buf));

		modlist = listnextnode(modlist);
	}
E 4

	return KESUCCESS;
}
E 2
I 1
E 1
