h61769
s 00012/00010/00618
d D 1.24 00/08/26 19:52:48 nitehawk 25 24
c convert all logging calls into logmsg
cC
cHlocalhost.1ststep.net
cK47703
cZ-07:00
e
s 00000/00000/00628
d D 1.23 00/03/07 11:48:13 nitehawk 24 23
c Turn on SCCS flag
cC
cK25035
cX0xa1
e
s 00006/00004/00622
d D 1.22 00/02/26 22:34:25 nitehawk 23 22
c messageid now needed as parameter to uplinksend message
c messageid == 0 means start a new message exchange
cC
cK41717
e
s 00014/00011/00612
d D 1.21 00/02/24 19:29:05 nitehawk 22 21
c Convert memory calls to use wrapper functions
cC
cK33295
e
s 00000/00000/00623
d D 1.20 00/02/12 10:06:45 nitehawk 21 20
c Rename: lib/uplinkprotocol.c -> lib/koala/uplinkprotocol.c
cC
cK06611
cPlib/koala/uplinkprotocol.c
e
s 00001/00000/00622
d D 1.19 00/02/08 10:27:51 nitehawk 20 19
c Reboot messages don't have any message content
c don't try to relay such in routing
cC
cK19175
e
s 00000/00000/00622
d D 1.18 00/02/07 23:56:49 nitehawk 19 18
c Rename: src/uplinkprotocol.c -> lib/uplinkprotocol.c
cK05120
cPlib/uplinkprotocol.c
e
s 00017/00046/00605
d D 1.17 00/02/06 12:05:14 nitehawk 18 17
c uplinkreadmessage now uses message length field to read packet
cC
cK17502
e
s 00079/00037/00572
d D 1.16 00/02/05 15:57:30 nitehawk 17 16
c Message headers buffered as a part of uplink daemon data
cC
cK05632
e
s 00021/00043/00588
d D 1.15 00/02/05 13:50:52 nitehawk 16 15
c Uplink messages are now received via input buffers
cK53503
e
s 00038/00035/00593
d D 1.14 00/02/04 21:28:48 nitehawk 15 14
c Code to continue reading a packet until the entire packet is read
c implemented
cC
cK13589
e
s 00012/00001/00616
d D 1.13 00/02/04 20:18:49 nitehawk 14 13
c Added handling for MSGTYPE_REBOOT
cC
cK34125
e
s 00104/00002/00513
d D 1.12 00/02/03 19:40:25 nitehawk 13 12
c Handling for sending 'global' messages
c code to read global messages
c Server class global routing added
cC
cK11661
e
s 00092/00003/00423
d D 1.11 00/02/02 19:11:22 nitehawk 12 11
c Routing of global messages complete
cK46157
e
s 00120/00023/00306
d D 1.10 00/02/02 17:11:58 nitehawk 11 10
c Split message receive into read and handle or read and route
cC
cK06743
e
s 00001/00001/00328
d D 1.9 00/02/01 12:24:02 nitehawk 10 9
c Minor bugs fixed
cC
cK32222
e
s 00013/00000/00316
d D 1.8 00/02/01 11:59:10 nitehawk 9 8
c Added handling for MSGTYPE_SHUTDOWN
cK31838
e
s 00020/00003/00296
d D 1.7 00/02/01 11:23:35 nitehawk 8 7
c Added handling for MSGTYPE_DISCONNECT
cK04919
e
s 00002/00002/00297
d D 1.6 00/02/01 11:05:50 nitehawk 7 6
c nodeid no longer in options struct
cK29843
e
s 00005/00000/00294
d D 1.5 00/01/29 23:47:53 nitehawk 6 5
c Send an IDENT squak during uplink negotiation if we
c just finished negotiation
cC
cK30313
e
s 00133/00000/00161
d D 1.4 00/01/29 22:28:19 nitehawk 5 4
c Added protocol functions to send and receive messages
cK23091
e
s 00002/00002/00159
d D 1.3 00/01/20 21:32:07 nitehawk 4 3
c Fix small bugs in protocol negotiation
cC
cK14128
e
s 00143/00000/00018
d D 1.2 00/01/20 21:09:28 nitehawk 3 2
c Added uplink negotiation function
cK13412
e
s 00018/00000/00000
d D 1.1 00/01/20 10:22:51 nitehawk 2 1
cF1
cK31702
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/01/20 10:22:51 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/src/uplinkprotocol.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK19256
cPsrc/uplinkprotocol.c
cR5e0c627aac03b35
cV3
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999-2000 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
\***************************************************************/

#define _KOALAMUD_UPLINKPROTOCOL_C "%Z% %K% %Z%"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "daemon.h"
#include "network.h"
#include "log.h"
I 3
#include "uplinkprotocol.h"
I 12
#include "llist.h"
#include "memory.h"
I 16
#include "buffer.h"
E 16
E 12

/* uplinknegotiatestage -
 *		Read data from socket and handle current stage of protocol negotiation
 *		
 *		There must be data on the socket or the socket must be marked
 *		non-blocking, otherwise this function *will* block progress
 *
 *		This function does not handle the authentication of uplink daemons.
 */
koalaerror uplinknegotiatestage(pdescriptor desc)
{
D 4
	char buf[80];
E 4
I 4
	char buf[80] = {'\0'};
E 4
	unsigned numread = 80;
D 16
	char linkerrmsg[] = "Protocol Negotiation Error - Disconnecting";
E 16
I 16
	char linkerrmsg[] = "Protocol Negotiation Error - Disconnecting\r\n";
	koalaerror kerr;
E 16

	/* Validate descriptor */
	if (!desc || desc->type != DESCRIPTOR_UNKNOWN)
	{
D 25
		logerr("uplinknegotiatestage caught invalid descriptor");
E 25
I 25
		logmsg(LOGERR, "uplinknegotiatestage caught invalid descriptor");
E 25
		return KEBADOPT;
	}

	/* If the descriptor is NOMINAL or further in its lifeline, then we
	 * shouldn't be trying to handle creating an uplink
	 */
	if (desc->status >= STATUS_NOMINAL)
	{
		return KESUCCESS;
	}

	/* Read in data to determine current stage of uplink negotiation */
D 16
	netread(desc, buf, &numread);
	if (desc->status == STATUS_CLOSE)
	{
		/* Must have been an error during read, drop out */
		return KEREADERROR;
	}
	if (numread == 0)
E 16
I 16
	numread = MAGICLEN;
	kerr = buffer_readbytes(desc, buf, &numread, FALSE);
	if (kerr == KENOTENOUGH)
E 16
	{
		/* No data on socket, just return success now */
		return KESUCCESS;
	}

	/* At this point, we should have all the information we need to determine
	 * what stage we are at and make the appropriate reply */
	if (desc->status == STATUS_CONNECTING)
	{
		/* We havn't received a daemon type from the remote machine yet.  The
		 * data we just read should either be the protocol magic or the magic
		 * of the daemon type.
		 */
		if (strcmp(buf, magic.daemonmagic) == 0)
		{
			/* We are the initiator */
			/* First stage - Reply with the magic string for our daemon type
			 * and fall out */
			switch(koptions.daemontype)
			{
				case DAEMON_CLIENT:
					netwrite(desc, magic.clientmagic,
							strlen(magic.clientmagic));
					break;

				case DAEMON_HUB:
					netwrite(desc, magic.hubmagic,
							strlen(magic.hubmagic));
					break;

				case DAEMON_ZONE:
					netwrite(desc, magic.zonemagic,
							strlen(magic.zonemagic));
					break;
				
				case DAEMON_UNKNOWN:
					/* It is impossible to reach this point, do nothing */
			}
			/* Set the status to say we sent the type */
			desc->status = STATUS_TYPESENT;
			return KESUCCESS;
		}
	}

	/* We just received the type of daemon on the other side of the link.  If
	 * we received this data and the status is 'CONNECTING' then we need to
	 * send our type back.  Otherwise we should be in 'TYPESENT' status and
	 * we have already sent our daemon type.
	 */
	if (strcmp(buf, magic.clientmagic) == 0)
	{
		/* Remote is a client daemon */
		desc->type = DESCRIPTOR_CLIENTSRV;
D 22
		desc->data.clientsrv = malloc(sizeof(struct TAG_CLIENTSERVER));
E 22
I 22
		desc->data.clientsrv = kmalloc(sizeof(struct TAG_CLIENTSERVER),
				ALLOC_DESCRIPTOR);
E 22
I 17
		desc->data.clientsrv->curmsg.messageid = 0;
E 17
	}
	else if (strcmp(buf, magic.hubmagic) == 0)
	{
		/* Remote is a client daemon */
		desc->type = DESCRIPTOR_HUBSRV;
D 22
		desc->data.hubsrv = malloc(sizeof(struct TAG_HUBSERVER));
E 22
I 22
		desc->data.hubsrv = kmalloc(sizeof(struct TAG_HUBSERVER),
				ALLOC_DESCRIPTOR);
E 22
I 17
		desc->data.hubsrv->curmsg.messageid = 0;
E 17
	}
	else if (strcmp(buf, magic.zonemagic) == 0)
	{
		/* Remote is a client daemon */
		desc->type = DESCRIPTOR_ZONESRV;
D 4
		desc->data.hubsrv = malloc(sizeof(struct TAG_ZONESERVER));
E 4
I 4
D 22
		desc->data.zonesrv = malloc(sizeof(struct TAG_ZONESERVER));
E 22
I 22
		desc->data.zonesrv = kmalloc(sizeof(struct TAG_ZONESERVER),
				ALLOC_DESCRIPTOR);
E 22
I 17
		desc->data.zonesrv->curmsg.messageid = 0;
E 17
E 4
	}
	else
	{
		/* Protocol problem - Close the socket */
D 25
		logerr("Protocol negotiation error!  Closing socket");
E 25
I 25
		logmsg(LOGERR, "Protocol negotiation error!  Closing socket");
E 25
		netwrite(desc, linkerrmsg, strlen(linkerrmsg));
		desc->status = STATUS_CLOSE;
	}

	/* If we havn't sent the type yet, send it now */
	if (desc->status == STATUS_CONNECTING)
	{
		switch(koptions.daemontype)
		{
		case DAEMON_CLIENT:
			netwrite(desc, magic.clientmagic,
					strlen(magic.clientmagic));
			break;

		case DAEMON_HUB:
			netwrite(desc, magic.hubmagic,
					strlen(magic.hubmagic));
			break;

		case DAEMON_ZONE:
			netwrite(desc, magic.zonemagic,
					strlen(magic.zonemagic));
			break;
			
		case DAEMON_UNKNOWN:
			/* It is impossible to reach this point, do nothing */
		}
	}
I 6
	else
	{
I 23
		/* Send first part of ident squak */
E 23
		message_data data = {NULL};
D 8
		uplinksendmessage(desc, MSGTYPE_IDENT, &data);
E 8
I 8
D 23
		uplinksendmessage(desc, 0, MSGTYPE_IDENT, &data);
E 23
I 23
		uplinksendmessage(desc, 0, MSGTYPE_IDENT, &data, 0);
E 23
E 8
	}
E 6

	/* Set the status to say we sent the type */
	desc->status = STATUS_NOMINAL;
	return KESUCCESS;
}
I 5

/* Send Message - Fill in a message struct and send it to the remote host
 */
D 8
koalaerror uplinksendmessage(pdescriptor desc, msgtype type,
E 8
I 8
koalaerror uplinksendmessage(pdescriptor desc, unsigned int dest, msgtype type,
E 8
D 23
		message_data *msgstruct)
E 23
I 23
		message_data *msgstruct, unsigned int msgid)
E 23
{
	uplinkmsg_header header;

	/* first verify our pointers */
	if (!desc || !msgstruct)
	{
D 25
		logerr("Caught NULL pointer");
E 25
I 25
		logmsg(LOGERR, "Caught NULL pointer");
E 25
		return KEMISSINGARG;
	}

	/* Now fill in the message header */
D 23
	header.messageid = (unsigned int)random();
E 23
I 23
	header.messageid = msgid == 0 ? (unsigned int)random() : msgid;
E 23
D 7
	header.sourcenodeid = koptions.nodeid;
E 7
I 7
	header.sourcenodeid = kstate.nodeid;
E 7
	header.messagetype = type;
I 8
D 10
	header.destnodeid = 0;
E 10
I 10
	header.destnodeid = dest;
I 18
	header.messagedatalen = 0;
E 18
E 10
E 8

	/* The rest of the handling depends on the type of message being sent */
	switch (type)
	{
		case MSGTYPE_IDENT:
I 18
			/* Finish header */
			header.messagedatalen = sizeof(message_ident);
E 18
			header.destnodeid = desc->nodeid;
I 18

E 18
			/* First see if we were passed a struct to use, otherwise
			 * allocate one */
			if (msgstruct->data == NULL)
			{
D 22
				msgstruct->data = malloc(sizeof(message_ident));
E 22
I 22
				msgstruct->data = kmalloc(sizeof(message_ident), ALLOC_GENERIC);
E 22
				if (msgstruct->data == NULL)
				{
D 25
					logerr("Unable to allocate memory for ident struct");
E 25
I 25
					logmsg(LOGCRIT, "Unable to allocate memory"
							" for ident struct");
E 25
					return KENOMEM;
				}
			}
			/* Fill in the struct */
D 7
			msgstruct->msgident->mynodeid = koptions.nodeid;
E 7
I 7
			msgstruct->msgident->mynodeid = kstate.nodeid;
E 7
			/* This will be 0 if we don't yet know their ID */
			/* receiving 0 in 'yournodeid' is a signal to respond with the
			 * same message type */
			msgstruct->msgident->yournodeid = desc->nodeid;

			/* Send the data out */
			netwrite(desc, (char *)&header, sizeof(uplinkmsg_header));
			netwrite(desc, (char *)msgstruct->msgident, sizeof(message_ident));

			/* Free the message data, even if it wasn't us allocating it */
D 22
			free(msgstruct->data);
E 22
I 22
			kmfree(msgstruct->data, ALLOC_GENERIC);
E 22
			break;

I 13
		case MSGTYPE_GLOBAL_MSG:
			/* This isn't *really* global.  It is sent to a specific nodeid
			 * or the class global ID.  It can also be sent to an id group
			 * (this is a nodeid that sends to a group of nodes)
			 */
			/* If the caller didn't give us message data, we have no way to
			 * construct a message to send */
			if (msgstruct->data == NULL)
			{
D 25
				logerr("Global message cannot be sent without message data");
E 25
I 25
				logmsg(LOGWARN, "Global message cannot be sent"
						" without message data");
E 25
				return KEMISSINGARG;
			}

			if (dest == NODEID_UNSPEC ||
					dest == NODEID_GLOBAL ||
					dest == NODEID_ALLHUB ||
					dest == NODEID_ALLZONE)
			{
				header.destnodeid = NODEID_ALLCLIENT;
			}

			/* Write packet to the network */
			netwrite(desc, (char *)&header, sizeof(header));
			netwrite(desc, (char *)msgstruct->data, sizeof(message_global_msg));
			break;

E 13
I 8
		case MSGTYPE_DISCONNECT:
			// Set the destination to the remote nodeid
			header.destnodeid = desc->nodeid;
			
			// Write the packet to the network
			netwrite(desc, (char *)&header, sizeof(uplinkmsg_header));

			// Set the descriptor status to close it
			desc->status = STATUS_CLOSE;
			break;

I 9
		case MSGTYPE_SHUTDOWN:
			// Write the packet to the network
			netwrite(desc, (char *)&header, sizeof(uplinkmsg_header));
			break;

I 14
		case MSGTYPE_REBOOT:
			// Write the packet to the network
			netwrite(desc, (char *)&header, sizeof(uplinkmsg_header));
			break;

E 14
E 9
E 8
		default:
D 25
			logerr("Attempt to send unknown message type");
E 25
I 25
			logmsg(LOGWARN, "Attempt to send unknown message type");
E 25
			return KEUNKNOWNMESSAGE;
	}

	return KESUCCESS;
}

D 11
/* uplinkreceivemessage -- Receive a message from the network and do basic
 *		processing
E 11
I 11
/* Uplinkreadmessage -- Read message from network
I 15
 * Note: We will block progress until we get the entire message packet
E 15
E 11
 */
D 11
koalaerror uplinkreceivemessage(pdescriptor desc)
E 11
I 11
D 17
koalaerror uplinkreadmessage(pdescriptor desc, uplinkmsg_header *header,
E 17
I 17
koalaerror uplinkreadmessage(pdescriptor desc, uplinkmsg_header *header, 
E 17
		message_data *data)
E 11
{
D 11
	uplinkmsg_header header;
	message_data data;
E 11
D 15
	int num;
E 15
I 15
D 16
	int num, numtogo, pos;
E 16
I 16
	int num;
	koalaerror kerr;
E 16
E 15
I 11
D 17

E 17
I 17
	
E 17
	/* Verify we got pointers */
D 17
	if (!desc || !header || !data)
E 17
I 17
	if (!desc || !data)
E 17
	{
D 25
		logerr("Caught null pointers!");
E 25
I 25
		logmsg(LOGERR, "Caught null pointers!");
E 25
		return KEMISSINGARG;
	}
E 11
	
D 17
	/* Read the header from the network */
D 15
	num = sizeof(uplinkmsg_header);
D 11
	if (netread(desc, (char *)&header, &num) != KESUCCESS)
E 11
I 11
	if (netread(desc, (char *)header, &num) != KESUCCESS)
E 15
I 15
D 16
	numtogo = sizeof(uplinkmsg_header);
	num = pos = 0;
	while(numtogo > 0)
E 15
E 11
	{
D 15
		logerr("Error reading message header");
		return KENETFAIL;
	}
	if (num < sizeof(uplinkmsg_header))
	{
		/* We didn't get the entire header.  For now we will just fall out, we
		 * should cache what we have and the number of bytes already read for
		 * later and check the cache when we start this function */
		return KENETFAIL;
E 15
I 15
		pos += num;
		num = numtogo;
		if (netread(desc, (char*)header + pos, &num) != KESUCCESS)
		{
			logerr("Error reading message header");
			return KENETFAIL;
		}
		numtogo -= num;
E 16
I 16
	num = sizeof(uplinkmsg_header);
	kerr = buffer_readbytes(desc, (char *)header, &num, TRUE);
	if (kerr == KENOTENOUGH)
E 17
I 17
	/* If we aren't currently handling a message */
	if (header->messageid == 0)
E 17
	{
D 17
		return KENOTENOUGH;
E 17
I 17
		/* Read the header from the network */
		num = sizeof(uplinkmsg_header);
		kerr = buffer_readbytes(desc, (char *)header, &num, TRUE);
		if (kerr == KENOTENOUGH)
		{
			return KENOTENOUGH;
		}
E 17
E 16
E 15
	}

D 11
	switch (header.messagetype)
E 11
I 11
D 18
	switch (header->messagetype)
E 18
I 18
	if (header->messagedatalen > 0)
E 18
E 11
	{
D 18
		case MSGTYPE_IDENT:
			/* allocate memory to read the ident data (2 uints) */
D 11
			data.data = malloc(sizeof(message_ident));
			if (data.data == NULL)
E 11
I 11
			data->data = malloc(sizeof(message_ident));
			if (data->data == NULL)
E 11
			{
				logerr("Unable to allocate memory for ident struct");
				return KENOMEM;
			}

			/* Read message from the network */
D 15
			num = sizeof(message_ident);
D 11
			if (netread(desc, (char *)data.data, &num) != KESUCCESS)
E 11
I 11
			if (netread(desc, (char *)data->data, &num) != KESUCCESS)
E 11
			{
				logerr("Error reading message");
				return KENETFAIL;
			}
			if (num < sizeof(message_ident))
			{
				/* We didn't get the entire message.  For now fall out (as
				 * above), but this should be cached in some form */
				return KENETFAIL;
E 15
I 15
D 16
			numtogo = sizeof(message_ident);
			num = pos = 0;
			while(numtogo > 0)
E 16
I 16
			num = sizeof(message_ident);
			kerr = buffer_readbytes(desc, (char *)data->data, &num, TRUE);
			if (kerr == KENOTENOUGH)
E 16
			{
D 16
				pos += num;
				num = numtogo;
				if (netread(desc, (char*)data->data + pos, &num) != KESUCCESS)
				{
					logerr("Error reading message body");
					return KENETFAIL;
				}
				numtogo -= num;
E 16
I 16
				return KENOTENOUGH;
E 16
E 15
			}
D 11
			
E 11
I 11
			break;

I 13
		case MSGTYPE_GLOBAL_MSG:
D 15
			/* allocate memory to read the ident data (2 uints) */
E 15
I 15
			/* allocate memory to read the global message */
E 15
			data->data = malloc(sizeof(message_global_msg));
			if (data->data == NULL)
			{
				logerr("Unable to allocate memory for message struct");
				return KENOMEM;
			}

			/* Read message from the network */
D 15
			num = sizeof(message_global_msg);
			if (netread(desc, (char *)data->data, &num) != KESUCCESS)
			{
				logerr("Error reading message");
				return KENETFAIL;
			}
			if (num < sizeof(message_global_msg))
			{
				/* We didn't get the entire message.  For now fall out (as
				 * above), but this should be cached in some form */
				return KENETFAIL;
E 15
I 15
D 16
			numtogo = sizeof(message_global_msg);
			num = pos = 0;
			while(numtogo > 0)
E 16
I 16
			num = sizeof(message_global_msg);
			kerr = buffer_readbytes(desc, (char *)data->data, &num, TRUE);
			if (kerr == KENOTENOUGH)
E 16
			{
D 16
				pos += num;
				num = numtogo;
				if (netread(desc, (char*)data->data + pos, &num) != KESUCCESS)
				{
					logerr("Error reading message body");
					return KENETFAIL;
				}
				numtogo -= num;
E 16
I 16
				return KENOTENOUGH;
E 16
E 15
			}
			break;

E 13
		case MSGTYPE_DISCONNECT:  // No ack needed, just close it
		case MSGTYPE_SHUTDOWN:  // No ack needed, just close it
I 14
		case MSGTYPE_REBOOT:
E 14
			break;

		default:
			logerr("Unknown message type");
			return KEUNKNOWNMESSAGE;
E 18
I 18
D 22
		data->data = malloc(header->messagedatalen);
E 22
I 22
		data->data = kmalloc(header->messagedatalen, ALLOC_GENERIC);
E 22
		if (data->data == NULL)
		{
D 25
			logerr("Unable to allocate memory for message struct");
E 25
I 25
			logmsg(LOGCRIT, "Unable to allocate memory for message struct");
E 25
			return KENOMEM;
		}
		num = header->messagedatalen;
		kerr = buffer_readbytes(desc, (char*)data->data, &num, TRUE);
		if (kerr == KENOTENOUGH)
		{
			return KENOTENOUGH;
		}
E 18
	}
D 18

E 18
	return KESUCCESS;
}

/* uplinkhandlemessage -- Handle a packet that is destined for us
 */
koalaerror uplinkhandlemessage(pdescriptor desc, uplinkmsg_header *header,
		message_data *data)
{
	/* Verify we got pointers */
	if (!desc || !header || !data)
	{
D 25
		logerr("Caught null pointers!");
E 25
I 25
		logmsg(LOGERR, "Caught null pointers!");
E 25
		return KEMISSINGARG;
	}

	/* Switch into correct message handling */
	switch (header->messagetype)
	{
		case MSGTYPE_IDENT:
E 11
			/* Copy 'mynodeid' into the descriptor struct */
D 11
			desc->nodeid = data.msgident->mynodeid;
E 11
I 11
			desc->nodeid = data->msgident->mynodeid;
E 11

			/* If the 'yournodeid' field is zero, send a message back */
D 11
			if (data.msgident->yournodeid == 0)
E 11
I 11
			if (data->msgident->yournodeid == 0)
E 11
			{
D 11
				free(data.data);
				data.data = NULL;
D 8
				uplinksendmessage(desc, MSGTYPE_IDENT, &data);
E 8
I 8
				uplinksendmessage(desc, desc->nodeid, MSGTYPE_IDENT, &data);
E 11
I 11
D 22
				free(data->data);
E 22
I 22
				kmfree(data->data, ALLOC_GENERIC);
E 22
				data->data = NULL;
D 23
				uplinksendmessage(desc, desc->nodeid, MSGTYPE_IDENT, data);
E 23
I 23
				uplinksendmessage(desc, desc->nodeid, MSGTYPE_IDENT, data,
						header->messageid);
E 23
E 11
E 8
			}
			else
			{
D 11
				free(data.data);
				data.data = NULL;
E 11
I 11
D 22
				free(data->data);
E 22
I 22
				kmfree(data->data, ALLOC_GENERIC);
E 22
				data->data = NULL;
E 11
			}

I 8
			break;

I 13
		case MSGTYPE_GLOBAL_MSG:
			/* If this is not a client server, we don't handle this message */
			if (koptions.daemontype != DAEMON_CLIENT)
			{
D 22
				free(data->data);
E 22
I 22
				kmfree(data->data, ALLOC_GENERIC);
E 22
				return KESUCCESS;
			}
			break;

E 13
		case MSGTYPE_DISCONNECT:  // No ack needed, just close it
			// Set the descriptor status to close it
			desc->status = STATUS_CLOSE;
I 9
			break;

		case MSGTYPE_SHUTDOWN:  // No ack needed, just close it
D 11
			/* If this is indeed our message, shutdown the daemon */
			if (header.destnodeid == kstate.nodeid)
			{
				kstate.running = FALSE;
			}
E 11
I 11
D 14
			kstate.running = FALSE;
E 14
I 14
			kstate.running = DSTATE_SHUTDOWN;
			break;

		case MSGTYPE_REBOOT:  // No ack needed, just close it
			kstate.running = DSTATE_REBOOT;
E 14
E 11
E 9
E 8
			break;

		default:
D 25
			logerr("Unknown message type");
E 25
I 25
			logmsg(LOGWARN, "Unknown message type");
E 25
			return KEUNKNOWNMESSAGE;
I 11
	}
I 17
	header->messageid = 0;
E 17

	return KESUCCESS;
}

/* Uplinkroutemessage - Read message from network and route it on to its
 * destination
 */
koalaerror uplinkroutemessage(pdescriptor desc)
{
D 17
	uplinkmsg_header header;
E 17
I 17
	uplinkmsg_header *header;
E 17
	message_data data;
	koalaerror kerr = KESUCCESS;
I 12
	int transmitcount = 0;
	listnodeptr tmplist;
	pdescriptor tmpdesc;
	int msglen;
E 12

	/* Initialize stuff */
	data.data = NULL;

I 17
	/* Point local header to descriptors header */
	switch(desc->type)
	{
		case DESCRIPTOR_HUBSRV:
			header = &(desc->data.hubsrv->curmsg);
			break;
		case DESCRIPTOR_ZONESRV:
			header = &(desc->data.zonesrv->curmsg);
			break;
		case DESCRIPTOR_CLIENTSRV:
			header = &(desc->data.clientsrv->curmsg);
			break;
		default:
			return KEBADOPT;
	}

E 17
	/* Read the message from the network */
D 17
	kerr = uplinkreadmessage(desc, &header, &data);
E 17
I 17
	kerr = uplinkreadmessage(desc, header, &data);
E 17
	if (kerr != KESUCCESS)
	{
		/* We can't do anything useful if the read failed */
		return kerr;
	}
D 12
	
E 12
I 12

	/* Figure out the size of the message we are sending */
D 17
	switch(header.messagetype)
E 17
I 17
	switch(header->messagetype)
E 17
	{
		case MSGTYPE_GLOBAL_MSG:
			msglen = sizeof(message_global_msg);
			break;

		case MSGTYPE_XML:
			msglen = data.msgxml->xmllen + sizeof(short);
			break;

		default:
			msglen = 0;
	}

E 12
	/* Route the packet to target descriptors */
I 12
	/* first: If this is our packet, we can skip the entire routing loop and
	 * just handle it
	 */
D 17
	if (header.destnodeid != kstate.nodeid)
E 17
I 17
	if (header->destnodeid != kstate.nodeid)
E 17
	{
		/* If this is an ident squawk, it cannot be routed past us, toss it to
		 * the handler.  Same with disconnects. */
D 17
		if (header.messagetype == MSGTYPE_IDENT ||
				header.messagetype == MSGTYPE_DISCONNECT)
E 17
I 17
		if (header->messagetype == MSGTYPE_IDENT ||
				header->messagetype == MSGTYPE_DISCONNECT)
E 17
		{
D 17
			kerr = uplinkhandlemessage(desc, &header, &data);
E 17
I 17
			kerr = uplinkhandlemessage(desc, header, &data);
E 17
			return kerr;
		}

		/* This packet is not ours (or it is global or unknown),
		 * 	route it on its way */
D 17
		if (header.destnodeid == NODEID_GLOBAL)
E 17
I 17
		if (header->destnodeid == NODEID_GLOBAL)
E 17
		{
			/* This is a global message, loop through all descriptors and
			 * forward to all uplinks
			 */
			for (tmplist = getdescriptorlist(); tmplist;
					tmplist = listnextnode(tmplist))
			{
				tmpdesc = tmplist->data.desc;
E 12

D 12
	/* If this message is global or to us, handle it now */
	uplinkhandlemessage(desc, &header, &data);
E 12
I 12
				if (tmpdesc->type == DESCRIPTOR_HUBSRV ||
						tmpdesc->type == DESCRIPTOR_ZONESRV ||
						tmpdesc->type == DESCRIPTOR_CLIENTSRV)
				{
					transmitcount++;
D 17
					netwrite(tmpdesc, (char *)&header, sizeof(header));
E 17
I 17
					netwrite(tmpdesc, (char *)header, sizeof(uplinkmsg_header));
E 17

					/* Send out message data */
D 17
					switch(header.messagetype)
E 17
I 17
					switch(header->messagetype)
E 17
					{
						case MSGTYPE_SHUTDOWN:
I 20
						case MSGTYPE_REBOOT:
E 20
							/* No data piece to write */
							break;
						default:
							/* All other possible message types have message
							 * data to send */
							netwrite(tmpdesc, (char *)data.data, msglen);
					}
				}
			}
D 13
		}
E 13
I 13
		} // end Global message loop

		/* This packet is targeted for all servers of a specific class */
D 17
		if (header.destnodeid == NODEID_ALLHUB ||
				header.destnodeid == NODEID_ALLZONE ||
				header.destnodeid == NODEID_ALLCLIENT)
E 17
I 17
		if (header->destnodeid == NODEID_ALLHUB ||
				header->destnodeid == NODEID_ALLZONE ||
				header->destnodeid == NODEID_ALLCLIENT)
E 17
		{
			/* This is a global message, loop through all descriptors and
			 * forward to all uplinks
			 */
			for (tmplist = getdescriptorlist(); tmplist;
					tmplist = listnextnode(tmplist))
			{
				tmpdesc = tmplist->data.desc;

D 17
				if (tmpdesc->type == header.destnodeid)
E 17
I 17
				if (tmpdesc->type == header->destnodeid)
E 17
				{
					transmitcount++;
D 17
					netwrite(tmpdesc, (char *)&header, sizeof(header));
E 17
I 17
					netwrite(tmpdesc, (char *)header, sizeof(uplinkmsg_header));
E 17

					/* Send out message data */
D 17
					switch(header.messagetype)
E 17
I 17
					switch(header->messagetype)
E 17
					{
						case MSGTYPE_SHUTDOWN:
I 14
						case MSGTYPE_REBOOT:
E 14
							/* No data piece to write */
							break;

						default:
							/* All other possible message types have message
							 * data to send */
							netwrite(tmpdesc, (char *)data.data, msglen);
					}
				}
			}
		}  // end Server class global message loop

		/* Find entry in routing table and forward packet along */
E 13
	}

	/* If this message is global or to us, handle it now
	 * Two reasons for this:
	 * 		1: Global shutdowns need to be routed outward first
	 * 		2: Header and data are freed in the handler
	 */
D 17
	if (header.destnodeid == NODEID_GLOBAL ||
I 13
			header.destnodeid == NODEID_ALLHUB ||
E 13
			header.destnodeid == kstate.nodeid)
E 17
I 17
	if (header->destnodeid == NODEID_GLOBAL ||
			header->destnodeid == NODEID_ALLHUB ||
			header->destnodeid == kstate.nodeid)
E 17
	{
		/* Call the handler */
D 17
		kerr = uplinkhandlemessage(desc, &header, &data);
E 17
I 17
		kerr = uplinkhandlemessage(desc, header, &data);
E 17
		/* Data is freed by the message handler */
D 17

E 17
I 17
		header->messageid = 0;
E 17
		return kerr;
	}

	/* We didn't handle the packet ourselves, we need to free the memory used
	 * by the message data
	 */
	if (data.data)
	{
D 22
		free(data.data);
E 22
I 22
		kmfree(data.data, ALLOC_GENERIC);
E 22
	}
I 17
	header->messageid = 0;
E 17
E 12

	return KESUCCESS;
}

/* Uplinkreceivemessage - Read a message from network and handle it
 */
koalaerror uplinkreceivemessage(pdescriptor desc)
{
D 17
	uplinkmsg_header header;
E 17
I 17
	uplinkmsg_header *header;
E 17
	message_data data;
	koalaerror kerr = KESUCCESS;

	/* Initialize stuff */
	data.data = NULL;

I 17
	/* Point local header to descriptors header */
	switch(desc->type)
	{
		case DESCRIPTOR_HUBSRV:
			header = &(desc->data.hubsrv->curmsg);
			break;
		case DESCRIPTOR_ZONESRV:
			header = &(desc->data.zonesrv->curmsg);
			break;
		case DESCRIPTOR_CLIENTSRV:
			header = &(desc->data.clientsrv->curmsg);
			break;
		default:
			return KEBADOPT;
	}

E 17
	/* Read the message from the network */
D 17
	kerr = uplinkreadmessage(desc, &header, &data);
E 17
I 17
	kerr = uplinkreadmessage(desc, header, &data);
E 17
	if (kerr != KESUCCESS)
	{
		/* We can't do anything useful if the read failed */
		return kerr;
	}

	/* Verify that this message is either global or for us */
D 17
	if (header.destnodeid == NODEID_GLOBAL ||
D 13
			header.destnodeid == kstate.nodeid)
E 13
I 13
			header.destnodeid == kstate.nodeid ||
E 17
I 17
	if (header->destnodeid == NODEID_GLOBAL ||
			header->destnodeid == kstate.nodeid ||
E 17
			/* Hub servers don't use this loop so we don't need to check for
			 * them */
			((koptions.daemontype == DAEMON_CLIENT &&
D 17
			  header.destnodeid == DESCRIPTOR_CLIENTSRV) ||
E 17
I 17
			  header->destnodeid == DESCRIPTOR_CLIENTSRV) ||
E 17
			 (koptions.daemontype == DAEMON_ZONE &&
D 17
			  header.destnodeid == DESCRIPTOR_ZONESRV)))
E 17
I 17
			  header->destnodeid == DESCRIPTOR_ZONESRV)))
E 17
E 13
	{
		/* Call the handler */
D 17
		kerr = uplinkhandlemessage(desc, &header, &data);
E 17
I 17
		kerr = uplinkhandlemessage(desc, header, &data);
E 17
		/* Data is freed by the message handler */
D 17

E 17
I 17
		header->messageid = 0;
E 17
		return kerr;
	}

	/* Message wasn't for us, free the data and silently ignore it */
	if (data.data)
	{
D 22
		free(data.data);
E 22
I 22
		kmfree(data.data, ALLOC_GENERIC);
E 22
E 11
	}
I 17
	header->messageid = 0;
E 17

	return KESUCCESS;
}
E 5
E 3
E 2
I 1
E 1
