h63228
s 00020/00015/00718
d D 1.27 00/08/26 19:52:47 nitehawk 29 28
c convert all logging calls into logmsg
cC
cK29135
e
s 00004/00005/00729
d D 1.26 00/08/22 20:17:48 nitehawk 28 27
c Converting to new logmsg
cC
cK20825
e
s 00000/00000/00734
d D 1.25 00/05/07 22:06:55 nitehawk 27 25
i 26
c Auto merged
cC
cHlocalhost.1ststep.net
cK24853
cM26
cZ-07:00
e
s 00000/00012/00615
d D 1.23.1.1 00/05/07 08:33:07 nitehawk 26 24
c Removed special address definitions for IPv6
cC
cK41755
cZ-07:00
e
s 00119/00000/00627
d D 1.24 00/03/19 22:15:22 nitehawk 25 24
c Add confgetoptionsfromsection function as a generic options
c reading entry point
cC
cK43540
e
s 00000/00000/00627
d D 1.23 00/03/07 11:48:12 nitehawk 24 23
c Turn on SCCS flag
cC
cK57670
cX0xa1
e
s 00018/00005/00609
d D 1.22 00/02/29 00:52:51 nitehawk 23 22
c use IP style nodeids
cC
cK60442
e
s 00003/00003/00611
d D 1.21 00/02/24 18:55:44 nitehawk 22 21
c Convert memory calls to use wrapper functions
cC
cK26878
e
s 00003/00003/00611
d D 1.20 00/02/17 14:03:24 nitehawk 21 20
c Change dbbasepath to dbrootpath
cC
cK26352
e
s 00000/00000/00614
d D 1.19 00/02/12 10:04:48 nitehawk 20 19
c Rename: lib/conf.c -> lib/koala/conf.c
cC
cK38267
cPlib/koala/conf.c
e
s 00027/00000/00587
d D 1.18 00/02/12 09:58:02 nitehawk 19 18
c Add database options to xml configuration
c Add database option read code to generic option read
cC
cK26229
e
s 00000/00000/00587
d D 1.17 00/02/07 23:57:15 nitehawk 18 17
c Rename: src/conf.c -> lib/conf.c
cC
cK11688
cPlib/conf.c
e
s 00003/00003/00584
d D 1.16 00/02/07 19:19:59 nitehawk 17 16
c Zone daemon by default *will* connect to an uplink
cC
cK37677
e
s 00050/00000/00537
d D 1.15 00/02/05 21:58:24 nitehawk 16 15
c Added function to read generic options from the config file
cC
cK35471
e
s 00006/00006/00531
d D 1.14 00/02/05 19:34:35 nitehawk 15 14
c Change default path for log files
cK63383
e
s 00003/00005/00534
d D 1.13 00/02/04 10:27:39 nitehawk 14 13
c netlisten expects a list pointer instead of descriptor now
cC
cK61138
e
s 00004/00001/00535
d D 1.12 00/02/01 11:04:52 nitehawk 13 12
c nodeid no longer in options struct
cC
cK05984
e
s 00041/00003/00495
d D 1.11 00/01/29 17:47:28 nitehawk 12 11
c Added confgetnodeid function - update default configuration
c to include nodeid
cC
cK63320
e
s 00003/00002/00495
d D 1.10 00/01/23 20:45:29 nitehawk 11 10
c Converting descriptor memory allocation to use new functions
cC
cK39647
e
s 00001/00001/00496
d D 1.9 00/01/21 19:55:55 nitehawk 10 9
c Fix small bug in confcreateuplink
cC
cK38986
e
s 00004/00014/00493
d D 1.8 00/01/17 22:56:10 nitehawk 9 8
c updated default config file structure
cC
cK38759
e
s 00210/00000/00297
d D 1.7 00/01/17 22:51:27 nitehawk 8 7
c Added confcreateuplink
cK02585
e
s 00002/00002/00295
d D 1.6 00/01/11 12:27:31 nitehawk 7 6
c Converted RCS tags to SCCS tags
cC
cK16310
e
s 00019/00000/00278
d D 1.5 00/01/09 20:35:40 nitehawk 6 5
c Added confquerybackground function to get background status from config file
cC
cK22457
e
s 00046/00000/00232
d D 1.4 00/01/09 18:28:24 nitehawk 5 4
c confopenlogs added - open log files with paths from xml
c config file
cK60856
e
s 00126/00000/00106
d D 1.3 00/01/01 17:03:42 nitehawk 4 3
c Added function to read XML configuration
c Added function to find the section of the config for the
c    current daemon
c Added function to create a listen socket based on the
c    config file
cC
cK45034
e
s 00090/00000/00016
d D 1.2 99/12/31 17:37:39 nitehawk 3 2
c gendefaultconfig setup to create the xml default configuration file
cK42889
e
s 00016/00000/00000
d D 1.1 99/12/31 13:04:05 nitehawk 2 1
cF1
cK31988
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 99/12/31 13:04:05 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/src/conf.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK03084
cPsrc/conf.c
cR8a9ce2164ffa29dd
cV3
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
D 7
/* $Id: daemon.c,v 1.8 1999/12/08 05:11:22 nitehawk Exp $ */
E 7
I 7
/* %Z% %M% %I% %Z% */
E 7
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: CORE
\***************************************************************/

D 7
#define _KOALAMUD_CONF_C "$Id: daemon.c,v 1.8 1999/12/08 05:11:22 nitehawk Exp $"
E 7
I 7
#define _KOALAMUD_CONF_C "%Z% %K% %Z%"
E 7

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"

I 4
#include "conf.h"
I 11
#include "memory.h"
E 11
E 4
I 3
#include "log.h"
I 4
#include "network.h"
E 4

/* Gnome-XML (libxml) Includes */
#include "parser.h"

I 4
xmlDocPtr configfile = NULL;
xmlNodePtr daemonconfig = NULL;

E 4
koalaerror gendefaultconfig(const char *filename)
{
	xmlDocPtr doc;
	xmlNodePtr tree, subtree, uplinktree;

	doc = xmlNewDoc("1.0");
	doc->root = xmlNewDocNode(doc, NULL, "KOALACONFIG", "\n"
I 12
			"In order for this configuration to be used in a larger setup,\n"
			"the node ID's must be changed.\n"
E 12
			"This default configuration will work for either\n"
			"a client to zone setup or a client to hub to zone setup");
	xmlSetProp(doc->root, "configversion", "1");

	/* Build the tree for client daemon configuration */
	tree = xmlNewChild(doc->root, NULL, "CLIENT", "Client configuration section");
	xmlSetProp(tree, "Background", "false");
I 12
D 23
	xmlSetProp(tree, "NodeID", "10");
E 23
I 23
	xmlSetProp(tree, "NodeID", "10.0.0.2");
E 23
E 12
	subtree = xmlNewChild(tree, NULL, "Listen", NULL);
	xmlSetProp(subtree, "port", "6464");
	xmlSetProp(subtree, "bind", "any");
	subtree = xmlNewChild(tree, NULL, "Log", NULL);
D 15
	xmlSetProp(subtree, "message", "message.log");
	xmlSetProp(subtree, "error", "error.log");
E 15
I 15
	xmlSetProp(subtree, "message", "log/climsg.log");
	xmlSetProp(subtree, "error", "log/clierr.log");
I 16
	subtree = xmlNewChild(tree, NULL, "Timer", NULL);
	xmlSetProp(subtree, "ticklen", "100000");
	xmlSetProp(subtree, "reportingperiod", "600");
I 19
	subtree = xmlNewChild(tree, NULL, "Database", NULL);
	xmlSetProp(subtree, "path", "clientdb");
E 19
E 16
E 15
	subtree = xmlNewChild(tree, NULL, "Uplink", "\n"
			"Client daemons can only connect to a single uplink");
D 9
	uplinktree = xmlNewChild(subtree, NULL, "Link", "Link 1");
E 9
I 9
	uplinktree = xmlNewChild(subtree, NULL, "Link", "Localhost Uplink");
E 9
D 26
#if IPV6
	xmlSetProp(uplinktree, "address", "ip6-localhost");
#else
E 26
	xmlSetProp(uplinktree, "address", "localhost");
D 26
#endif
E 26
	xmlSetProp(uplinktree, "port", "8204");

	/* Build the tree for hub daemon configuration */
	tree = xmlNewChild(doc->root, NULL, "HUB", "Hub configuration section");
	xmlSetProp(tree, "Background", "false");
I 12
D 23
	xmlSetProp(tree, "NodeID", "12");
E 23
I 23
	xmlSetProp(tree, "NodeID", "10.0.0.1");
E 23
E 12
	subtree = xmlNewChild(tree, NULL, "Listen", NULL);
	xmlSetProp(subtree, "port", "8204");
	xmlSetProp(subtree, "bind", "any");
	subtree = xmlNewChild(tree, NULL, "Log", NULL);
D 15
	xmlSetProp(subtree, "message", "message.log");
	xmlSetProp(subtree, "error", "error.log");
E 15
I 15
	xmlSetProp(subtree, "message", "log/hubmsg.log");
	xmlSetProp(subtree, "error", "log/huberr.log");
I 16
	subtree = xmlNewChild(tree, NULL, "Timer", NULL);
	xmlSetProp(subtree, "ticklen", "100000");
	xmlSetProp(subtree, "reportingperiod", "600");
E 16
E 15
	subtree = xmlNewChild(tree, NULL, "Uplink", "\n"
D 9
			"Hub Daemons by default do not create any uplinks\n"
			"The count property determines which uplinks will be connected to\n"
			"Two link lines are provided for example purposes");
	xmlSetProp(subtree, "Count", "0");
	uplinktree = xmlNewChild(subtree, NULL, "Link", "Link 1");
#if IPV6
	xmlSetProp(uplinktree, "address", "ip6-localhost");
#else
	xmlSetProp(uplinktree, "address", "localhost");
#endif
	xmlSetProp(uplinktree, "port", "8204");
	uplinktree = xmlNewChild(subtree, NULL, "Link", "Link 2");
E 9
I 9
			"Hub Daemons by default do not create any uplinks\n");
	uplinktree = xmlNewChild(subtree, NULL, "Link", "Localhost Uplink");
E 9
D 26
#if IPV6
	xmlSetProp(uplinktree, "address", "ip6-localhost");
#else
E 26
	xmlSetProp(uplinktree, "address", "localhost");
D 26
#endif
E 26
	xmlSetProp(uplinktree, "port", "8204");

	/* Build the tree for zone daemon configuration */
	tree = xmlNewChild(doc->root, NULL, "ZONE", "Zone configuration section");
	xmlSetProp(tree, "Background", "false");
I 12
D 23
	xmlSetProp(tree, "NodeID", "15");
E 23
I 23
	xmlSetProp(tree, "NodeID", "10.0.0.3");
E 23
E 12
	subtree = xmlNewChild(tree, NULL, "Listen", NULL);
	xmlSetProp(subtree, "port", "8204");
	xmlSetProp(subtree, "bind", "any");
	subtree = xmlNewChild(tree, NULL, "Log", NULL);
D 15
	xmlSetProp(subtree, "message", "message.log");
	xmlSetProp(subtree, "error", "error.log");
E 15
I 15
	xmlSetProp(subtree, "message", "log/zonmsg.log");
	xmlSetProp(subtree, "error", "log/zonerr.log");
I 16
	subtree = xmlNewChild(tree, NULL, "Timer", NULL);
	xmlSetProp(subtree, "ticklen", "100000");
	xmlSetProp(subtree, "reportingperiod", "600");
I 19
	subtree = xmlNewChild(tree, NULL, "Database", NULL);
	xmlSetProp(subtree, "path", "zonedb");
E 19
E 16
E 15
	subtree = xmlNewChild(tree, NULL, "Uplink", "\n"
D 17
			"zone daemons by default do not connect to an uplink\n"
			"Change 'connect=no' to 'connect=yes'");
	xmlSetProp(subtree, "connect", "no");
E 17
I 17
			"zone daemons by default connect to a local uplink\n"
			"Change 'connect=yes' to 'connect=no' to change this behavior");
	xmlSetProp(subtree, "connect", "yes");
E 17
D 9
	uplinktree = xmlNewChild(subtree, NULL, "Link", "Link 1");
E 9
I 9
	uplinktree = xmlNewChild(subtree, NULL, "Link", "Localhost Uplink");
E 9
D 26
#if IPV6
	xmlSetProp(uplinktree, "address", "ip6-localhost");
#else
E 26
	xmlSetProp(uplinktree, "address", "localhost");
D 26
#endif
E 26
	xmlSetProp(uplinktree, "port", "8204");

	xmlSetDocCompressMode(doc, 0);
	xmlSaveFile(filename, doc);
	
	return KESUCCESS;
I 4
}

koalaerror readxmlconfig(const char *filename)
{
	configfile = xmlParseFile(filename);
	if (configfile == NULL)
	{
D 29
		logerr("Error parsing config file");
E 29
I 29
		logmsg(LOGERR, "Error parsing config file");
E 29
		return KEINVALIDCONFIG;
	}

	if (strcmp(configfile->root->name, "KOALACONFIG"))
	{
D 29
		logerr("Invalid configuration file");
E 29
I 29
		logmsg(LOGERR, "Invalid configuration file");
E 29
		return KEINVALIDCONFIG;
	}

	finddaemonconfig();

	return KESUCCESS;
}

I 12
/*	finddaemonconfig - Locate the configuration section covering the currently
 *		running daemon type
 */
E 12
koalaerror finddaemonconfig(void)
{
	daemonconfig = configfile->root->childs;
	while (daemonconfig)
	{
		switch(koptions.daemontype)
		{
		case DAEMON_CLIENT:
			if (strcasecmp(daemonconfig->name, "CLIENT") == 0)
			{
D 12
				return KESUCCESS;
E 12
I 12
				return confgetnodeid();
E 12
			}
			break;
		case DAEMON_ZONE:
			if (strcasecmp(daemonconfig->name, "ZONE") == 0)
			{
D 12
				return KESUCCESS;
E 12
I 12
				return confgetnodeid();
E 12
			}
			break;
		case DAEMON_HUB:
			if (strcasecmp(daemonconfig->name, "HUB") == 0)
			{
D 12
				return KESUCCESS;
E 12
I 12
				return confgetnodeid();
E 12
			}
			break;
		default:
D 29
			logerr("Can't locate the correct daemon config section until the"
					" daemon type is known");
E 29
I 29
			logmsg(LOGWARN, "Can't locate the correct daemon config"
					" section until the daemon type is known");
E 29
			return KEUNKNOWNDAEMONTYPE;
		}
		daemonconfig = daemonconfig->next;
	}
	return KESUCCESS;
}

I 12
/*	confgetnodeid - Retrieve the nodeid from the configuration and stuff it
 *		into koptions
 *	
 *	This function should only be called via finddaemonconfig.
 */
koalaerror confgetnodeid(void)
{
	xmlAttrPtr attr = NULL;

D 14
	/* listencfg now points to the node containing listen configuration */
	/* find the 'port' and 'bind' properties */
E 14
	attr = daemonconfig->properties;
	while (attr)
	{
		/* Check to see if this is the port attributed */
		if (strcasecmp(attr->name, "nodeid") == 0)
		{
D 13
			koptions.nodeid = (unsigned int)strtoul((char *)attr->val->content,
E 13
I 13
D 23
			kstate.nodeid = (unsigned int)strtoul((char *)attr->val->content,
E 13
											NULL, 10);
E 23
I 23
			/* we need to read and interpret the eight bit octets into a
			 * single 32bit value. */
			char str[strlen(attr->val->content)];
			char *pos = str;
			char *tok = str;
			int shiftcount;
			strcpy(str, attr->val->content);  // copy the val to preserve the o

			/*  We start by shifting 24 bits and work down to a 0 bit shift */
			for ( shiftcount = 24 ; shiftcount >= 0; shiftcount -= 8)
			{
				tok = strsep(&pos, ".");
				kstate.nodeid |= (u_int8_t)strtoul(tok, NULL, 10) << shiftcount;
			}

E 23
			return KESUCCESS;
		}

		attr = attr->next;
	}
I 13

	/* default nodeid to a random number, just to be safe */
	kstate.nodeid = (unsigned int)random();
E 13

	return KEINVALIDCONFIG;
}

/*	confcreatelisten - Create listen socket from the configuration file
 */
E 12
D 14
koalaerror confcreatelisten(pdescriptor listen)
E 14
I 14
koalaerror confcreatelisten(listnodeptr list)
E 14
{
	xmlNodePtr listencfg = NULL;
	int port = 0;
	char *bindaddr = NULL;
	xmlAttrPtr attr = NULL;

	listencfg = daemonconfig->childs;
	while(listencfg)
	{
		if (strcasecmp(listencfg->name, "Listen") == 0)
		{
			break;
		}
		listencfg = listencfg->next;
		if (!listencfg)
		{
			/* We walked off the end of the list, break out */
D 29
			logerr("Listen configuration not found, not opening listen port");
E 29
I 29
			logmsg(LOGWARN, "Listen configuration not found,"
					" not opening listen port");
E 29
			return -KEBIND;
		}
	}

	/* listencfg now points to the node containing listen configuration */
	/* find the 'port' and 'bind' properties */
	attr = listencfg->properties;
	while (attr)
	{
		/* Check to see if this is the port attributed */
		if (strcasecmp(attr->name, "port") == 0)
		{
			if (port == 0)
			{
				port = atoi(attr->val->content);
			}
		}

		/* Check to see if this is the bind attribute */
		if (strcasecmp(attr->name, "bind") == 0)
		{
			if (bindaddr == NULL)
			{
				bindaddr = attr->val->content;
			}
		}

		attr = attr->next;
	}

	/* Verify both attributes were specified */
	if (port == 0)
	{
D 29
		logerr("Listen tag did not include port attribute, not opening listener");
E 29
I 29
		logmsg(LOGWARN, "Listen tag did not include port attribute,"
				" not opening listener");
E 29
		return -KEBIND;
	}

	if (bindaddr == NULL)
	{
D 29
		logerr("Listen tag did not include bind attribute, not opening listener");
E 29
I 29
		logmsg(LOGWARN, "Listen tag did not include bind attribute,"
				" not opening listener");
E 29
		return -KEBIND;
	}

D 14
	/* Open the listen socket */
	return netlisten(listen, bindaddr, port);
E 14
I 14
	/* Open the listen socket(s) */
	return netlisten(list, bindaddr, port);
E 14
E 4
}
I 5

koalaerror confopenlogs(void)
{
	xmlAttrPtr attr = NULL;
	xmlNodePtr logcfg = NULL;
	char outlogpath[PATH_MAX] = "output.log";
	char errlogpath[PATH_MAX] = "error.log";

	logcfg = daemonconfig->childs;
	while(logcfg)
	{
		if (strcasecmp(logcfg->name, "Log") == 0)
		{
			break;
		}
		logcfg = logcfg->next;
		if (!logcfg)
		{
			/* We walked off the end of the list, break out */
D 29
			logerr("Log configuration not found, not opening log files");
E 29
I 29
			logmsg(LOGERR, "Log configuration not found,"
					" not opening log files");
E 29
			return -KEINVALIDCONFIG;
		}
	}

	/* logcfg now points to the node containing log configuration */
	/* find the 'message' and 'error' properties */
	attr = logcfg->properties;
	while (attr)
	{
		/* Check to see if this is the port attributed */
		if (strcasecmp(attr->name, "message") == 0)
		{
			strcpy(outlogpath, attr->val->content);
		}

		/* Check to see if this is the bind attribute */
		if (strcasecmp(attr->name, "error") == 0)
		{
			strcpy(errlogpath, attr->val->content);
		}

		attr = attr->next;
	}

	return loginit(outlogpath, errlogpath);
}
I 6

bool confquerybackground(void)
{
	xmlAttrPtr attr = NULL;

	attr = daemonconfig->properties;
	while(attr)
	{
		if (strcasecmp(attr->name, "Background") == 0)
		{
			if (strcasecmp(attr->val->content, "true") == 0)
				return TRUE;
			if (strcasecmp(attr->val->content, "yes") == 0)
				return TRUE;
		}
		attr = attr->next;
	}
	return FALSE;
}
I 8

/* 	confcreateuplink -
 * 		Create an uplink connection to each uplink listed in the config file.
 * 		Client daemons will only create a single uplink.
 * 		Zone daemons will only create one uplink and only if the connect
 *	 		property is 'yes' or 'true' or '1'
 *	 	Hub daemons will connect to every uplink listed in the config section
 *
 *	 	The single parameter is a pointer to the linked list that the new
 *	 	descriptors should be linked into.
 */
koalaerror confcreateuplink(listnodeptr uplinklist)
{
	xmlNodePtr uplinkcfg = NULL;
	int port = 0;
	char *targaddr = NULL;
	xmlAttrPtr attr = NULL;
	pdescriptor uplink = NULL;
	bool zoneuplink = FALSE;
	koalaerror uplinkreturn;
	int uplinkscreated=0;
D 28
	char logbuf[MAXLOGLINELEN];
E 28

	uplinkcfg = daemonconfig->childs;
	/* First off, we need to find the section of the config that contains
	 * uplink data
	 */
	while(uplinkcfg)
	{
		if (strcasecmp(uplinkcfg->name, "uplink") == 0)
		{
			break;
		}
		uplinkcfg = uplinkcfg->next;
		if (!uplinkcfg)
		{
			/* We walked off the end of the list, break out */
D 29
			logerr("No uplink configuration found.  No uplinks will be"
					" connected.");
			logerr("An admin can create an uplink in game using 'link'");
E 29
I 29
			logmsg(LOGWARN, "No uplink configuration found."
					"  No uplinks will be connected.");
			logmsg(LOGWARN, "An admin can create an uplink"
					" in game using 'link'");
E 29
			return -KENOUPLINK;
		}
	}

	/* uplinkcfg now contains the node with 'uplinkcfg->childs' containing
	 * uplink configurations
	 */

	/* If this is a zone daemon, we now have the information to see if we need
	 * to create an uplink
	 */
	if (koptions.daemontype == DAEMON_ZONE)
	{
		/* Look for 'connect' property */
		attr = uplinkcfg->properties;
		while(attr)
		{
			if (strcasecmp(attr->name, "connect") == 0)
			{
				/* Check for 'yes', 'true', and '1'.  Anything else is assumed
				 * to be no
				 */
				if (strcasecmp(attr->val->content, "yes") == 0)
				{
					zoneuplink = TRUE;
					break;
				}
D 10
				if (strcasecmp(attr->val->content, "no") == 0)
E 10
I 10
				if (strcasecmp(attr->val->content, "true") == 0)
E 10
				{
					zoneuplink = TRUE;
					break;
				}
				if (strcasecmp(attr->val->content, "1") == 0)
				{
					zoneuplink = TRUE;
					break;
				}
			}
			attr = attr->next;
		}
		if (!zoneuplink)
		{
			/* Connect property not found, assuming to be no */
D 28
			logmsg("No connect property found, running zone daemon in"
E 28
I 28
			logmsg(LOGINFO, "No connect property found, running zone daemon in"
E 28
					"listen mode");
			return KENOUPLINK;
		}
	}

	/* At this point, we know that we are going to create at least one uplink.
	 *	Set uplinkcfg to point to what should be the first uplink config and
	 *	start creating uplinks - fall out of the loop when one uplink is
	 *	created for zone or client daemons
	 *
	 *	Only Client and Zone daemons are limited on the number of uplinks they
	 *	can create.  A hub daemon will attempt to connect to every uplink
	 *	listed in its config.  Client and zone daemons connect to the first
	 *	link listed that yields a successful connect.
	 */
	uplinkcfg = uplinkcfg->childs;
	/* Here's to complex while conditions :P */
	while ((((koptions.daemontype == DAEMON_CLIENT) ||
			(koptions.daemontype == DAEMON_ZONE)) && (uplinkscreated < 1))
			&& uplinkcfg)
	{
		/* First, make sure the current 'uplinkcfg' is actually an uplink
		 * config.  If it isn't, cycle until we find one then continue.
		 * Falling off the end of the list while 'uplinkscreated' is still 0
		 * is an error
		 */
		if (strcasecmp(uplinkcfg->name, "link") != 0)
		{
			/* Start looking for a node named 'link' */
			uplinkcfg = uplinkcfg->next;
			while(uplinkcfg)
			{
				/* Good, we found one */
				if (strcasecmp(uplinkcfg->name, "link") == 0)
					break;

				/* Keep Looking */
				uplinkcfg = uplinkcfg->next;
			}
		}

		/* Oops, we didn't find any links */
		if (uplinkcfg == NULL && uplinkscreated==0)
		{
D 29
			logerr("No valid links found, proceeding offline");
E 29
I 29
			logmsg(LOGWARN, "No valid links found, proceeding offline");
E 29
			return KENOUPLINK;
		}
		/* Catch a null before we have problems */
		if (uplinkcfg == NULL)
			continue;

		/* Now that we know uplinkcfg points to a 'link', find the address and
		 * port that we are going to connect to
		 */
		attr = uplinkcfg->properties;
		while (attr)
		{
			/* Check to see if this is the port attributed */
			if (strcasecmp(attr->name, "port") == 0)
			{
				port = atoi(attr->val->content);
			}

			/* Check to see if this is the address attribute */
			if (strcasecmp(attr->name, "address") == 0)
			{
				targaddr = attr->val->content;
			}

			attr = attr->next;
		}

		/* Verify both attributes were specified */
		if (port == 0)
		{
D 29
			logerr("Link tag did not include port attribute, not"
E 29
I 29
			logmsg(LOGWARN, "Link tag did not include port attribute, not"
E 29
					"connecting to uplink");
			uplinkcfg = uplinkcfg->next;
			continue;
		}

		if (targaddr == NULL)
		{
D 29
			logerr("Link tag did not include address attribute, not"
E 29
I 29
			logmsg(LOGWARN, "Link tag did not include address attribute, not"
E 29
					"connecting to uplink");
			uplinkcfg = uplinkcfg->next;
			continue;
		}

		/* Log that we are attempting to uplink to the current uplink */
D 28
		snprintf(logbuf, MAXLOGLINELEN, "Attempting to create uplink to: %s",
E 28
I 28
		logmsg(LOGINFO, "Attempting to create uplink to: %s",
E 28
				uplinkcfg->childs->content);
D 28
		logmsg(logbuf);
E 28

		/* We need to allocate memory for the uplink descriptor now */
D 11
		uplink = (pdescriptor)malloc(sizeof(descriptor));
E 11
I 11
D 22
		uplink = allocdescriptor();
E 11
		if (uplink == NULL)
E 22
I 22
		if ((uplink = allocdescriptor()) == NULL)
E 22
		{
			/* EEK!! malloc fail! */
D 28
			logerr("Unable to allocate memory for new uplink descriptor!");
E 28
I 28
			logmsg(LOGERR,
				"Unable to allocate memory for new uplink descriptor!");
E 28
			return KENOMEM;
		}
		
		/* Open the uplink socket */
		uplinkreturn = netuplink(uplink, targaddr, port);
		/* Did we get an uplink? */
		if (uplinkreturn == KESUCCESS)
		{
			uplinkscreated++;
			/* Link the new descriptor into the list and null the pointer */
			listaddnode(uplinklist, uplink);
			uplink = NULL;
		}
		else
		{
			/* Uhoh, bad things happened.  Lets try the next one */
			/* Free memory from uplink */
D 11
			free(uplink);
E 11
I 11
			freedescriptor(uplink);
E 11
			uplink = NULL;
		}

		uplinkcfg = uplinkcfg->next;
	}
I 16

	return KESUCCESS;
}

/* confgetoptions - get generic options from the config file */
koalaerror confgetoptions(void)
{
	xmlAttrPtr attr = NULL;
	xmlNodePtr cfg = NULL;

	cfg = daemonconfig->childs;
	while(cfg)
	{
		if (strcasecmp(cfg->name, "timer") == 0)
		{
			/* cfg now points to the node containing log configuration */
			/* find the 'message' and 'error' properties */
			attr = cfg->properties;
			while (attr)
			{
				/* Check to see if this is the port attributed */
				if (strcasecmp(attr->name, "ticklen") == 0)
				{
					koptions.ticklen = 
						(unsigned int)strtol(attr->val->content, NULL, 10);
				}

				/* Check to see if this is the bind attribute */
				if (strcasecmp(attr->name, "reportingperiod") == 0)
				{
					koptions.reportingperiod = 
						(unsigned int)strtol(attr->val->content, NULL, 10);
I 19
				}

				attr = attr->next;
			}

		}
		if (strcasecmp(cfg->name, "Database") == 0)
		{
			/* cfg now points to the node containing database configuration */
			attr = cfg->properties;
			while (attr)
			{
				/* Get path attribute */
				if (strcasecmp(attr->name, "path") == 0)
				{
					// Allocate Memory
D 21
					koptions.dbbasepath = malloc(strlen(attr->val->content));
					if (koptions.dbbasepath == NULL)
E 21
I 21
D 22
					koptions.dbrootpath = malloc(strlen(attr->val->content));
E 22
I 22
					koptions.dbrootpath = kmalloc(strlen(attr->val->content),
							ALLOC_GENERIC);
E 22
					if (koptions.dbrootpath == NULL)
E 21
					{
						return KENOMEM;
					}
					// Copy the path
D 21
					strcpy(koptions.dbbasepath, attr->val->content);
E 21
I 21
					strcpy(koptions.dbrootpath, attr->val->content);
E 21
E 19
				}

				attr = attr->next;
			}

		}
		cfg = cfg->next;
	}

E 16

	return KESUCCESS;
}
I 25

/* confgetoptionsfromsection
 *	Read a section of options from the configuration file.  The section is
 *	described by the string 'section'.  The options to be read are in an array
 *	of 'confoption_t' structs containing the option name, an enum of the
 *	option type, and a union with pointers to the object variables.  In the
 *	case of strings, this function will allocate memory for the string.
 *
 *	If an option is not found, the variables sent are left unchanged.
 */
koalaerror confgetoptionsfromsection(char *section, confoption_t *optionlist,
		int num)
{
	int i = 0;
	xmlAttrPtr opt = NULL;
	xmlNodePtr sect = NULL;

	/* Find the section */
	sect = daemonconfig->childs;
	while (sect)
	{
		if (strcasecmp(sect->name, section) == 0)
			/* We found it */
			break;
		
		sect = sect->next;
	}

	/* Make sure we found the section */
	if (sect == NULL)
	{
		return KECONFSECTIONNOTFOUND;
	}

	/* Now that we found the appropriate section, we now have to scan through
	 * the attributes for the matching options */
	opt = sect->properties;
	while (i < num)
	{
		if (opt == NULL)
		{
			opt = sect->properties;
			i++;
		}

		if (strcasecmp(opt->name, optionlist[i].optname) == 0)
		{
			/* We found the current option, copy data to target pointer */
			switch (optionlist[i].opttype)
			{
			case OPT_STRING:
				/* First we need to allocate memory for the string */
				*(optionlist[i].opt.ostring)=kmalloc(strlen(opt->val->content),
						ALLOC_DATABASE);
				if (*(optionlist[i].opt.ostring) == NULL)
				{
					return KENOMEM;
				}
				/* Copy option string */
				strcpy(*(optionlist[i].opt.ostring), opt->val->content);
				break;

			case OPT_UINT:
				*(optionlist[i].opt.ouint) = 
						(unsigned int)strtoul(opt->val->content, NULL, 10);
				break;

			case OPT_INT:
				*(optionlist[i].opt.oint) = 
						(int)strtol(opt->val->content, NULL, 10);
				break;

			case OPT_ULONG:
				*(optionlist[i].opt.oulong) = 
						strtoul(opt->val->content, NULL, 10);
				break;

			case OPT_LONG:
				*(optionlist[i].opt.olong) = 
						strtol(opt->val->content, NULL, 10);
				break;

			case OPT_DOUBLE:
				*(optionlist[i].opt.odouble) = atof(opt->val->content);
				break;

			case OPT_BOOL:
				if (strcasecmp(opt->val->content, "yes") == 0)
					*(optionlist[i].opt.obool) = TRUE;
				if (strcasecmp(opt->val->content, "true") == 0)
					*(optionlist[i].opt.obool) = TRUE;
				if (strcasecmp(opt->val->content, "1") == 0)
					*(optionlist[i].opt.obool) = TRUE;
				if (strcasecmp(opt->val->content, "on") == 0)
					*(optionlist[i].opt.obool) = TRUE;
				if (strcasecmp(opt->val->content, "no") == 0)
					*(optionlist[i].opt.obool) = FALSE;
				if (strcasecmp(opt->val->content, "false") == 0)
					*(optionlist[i].opt.obool) = FALSE;
				if (strcasecmp(opt->val->content, "0") == 0)
					*(optionlist[i].opt.obool) = FALSE;
				if (strcasecmp(opt->val->content, "off") == 0)
					*(optionlist[i].opt.obool) = FALSE;
				break;

			default:
				/* Major problems here */
D 29
				logerr("Fatal error reading configuration options");
E 29
I 29
				logmsg(LOGCRIT, "Fatal error reading configuration options");
E 29
			}

			i++;
			opt = sect->properties;
			continue;
		}
		opt = opt->next;
	}

	return KESUCCESS;
}
E 25
E 8
E 6
E 5
E 3
E 2
I 1
E 1
