h11062
s 00001/00001/00635
d D 1.18 00/08/26 19:52:47 nitehawk 19 18
c convert all logging calls into logmsg
cC
cHlocalhost.1ststep.net
cK12619
cZ-07:00
e
s 00000/00000/00636
d D 1.17 00/03/07 11:48:12 nitehawk 18 17
c Turn on SCCS flag
cC
cK23592
cX0xa1
e
s 00055/00000/00581
d D 1.16 00/02/17 12:05:34 nitehawk 17 16
c Add buffer_isalinein to check for whole input line
cC
cK12086
e
s 00000/00000/00581
d D 1.15 00/02/12 10:04:24 nitehawk 16 15
c Rename: lib/buffer.c -> lib/koala/buffer.c
cC
cK33663
cPlib/koala/buffer.c
e
s 00000/00000/00581
d D 1.14 00/02/07 23:57:30 nitehawk 15 14
c Rename: src/buffer.c -> lib/buffer.c
cC
cK15255
cPlib/buffer.c
e
s 00003/00002/00578
d D 1.13 00/02/07 17:21:26 nitehawk 14 13
c Read line does not null terminate partial lines now
cC
cK55856
e
s 00002/00002/00578
d D 1.12 00/02/05 15:58:55 nitehawk 13 12
c Use memcpy instead of strcpy for byte copy
cC
cK52585
e
s 00001/00001/00579
d D 1.11 00/02/05 00:25:32 nitehawk 12 11
c buffer_readbytes *is* implemented
cK52857
e
s 00007/00000/00573
d D 1.10 00/02/04 12:35:14 nitehawk 11 10
c Remove space that causes word break in buffer_readword
cC
cK53303
e
s 00017/00000/00556
d D 1.9 00/02/04 11:43:45 nitehawk 10 9
c readword gets a word consisting of special characters if the first
c char is not alphanumeric
cK40034
e
s 00033/00002/00523
d D 1.8 00/01/30 21:27:10 nitehawk 9 8
c Purge full crlf pair during line buffer reads
cC
cK04670
e
s 00202/00002/00323
d D 1.7 00/01/30 21:03:23 nitehawk 8 7
c All input buffer management code complete - FIXME in line
c buffer commands to remove crlf pair upon receiving first half
cK21371
e
s 00079/00004/00246
d D 1.6 00/01/30 18:17:08 nitehawk 7 6
c buffer_readbytes completed
cK21662
e
s 00006/00000/00244
d D 1.5 00/01/29 13:14:12 nitehawk 6 5
c Added buffer_outbufempty to check for an empty out buffer
cC
cK43503
e
s 00060/00003/00184
d D 1.4 00/01/25 23:37:18 nitehawk 5 4
c Added input buffer receive function and function to get
c single char from in buffer
cK30950
e
s 00170/00000/00017
d D 1.3 00/01/25 21:52:09 nitehawk 4 3
c Output ring buffer handling functions complete
cK40364
e
s 00001/00001/00016
d D 1.2 00/01/23 20:43:51 nitehawk 3 2
c Added buffer.h include
cC
cK29606
e
s 00017/00000/00000
d D 1.1 00/01/23 19:37:55 nitehawk 2 1
cF1
cK27947
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/01/23 19:37:55 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/src/buffer.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK51330
cPsrc/buffer.c
cR83121261e881fe44
cV3
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: BUFFER
\***************************************************************/

#define _KOALAMUD_BUFFER_C "%Z% %K% %Z%"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
I 3
#include "buffer.h"
E 3
#include "network.h"
I 17
#include "log.h"
E 17
I 4

/* Ring state parameters */
/* head = first byte of the buffer
 * tail = one byte past the end of the buffer
 * If head == tail, the buffer is empty
 * if head == tail+1 || (head == 0 && tail == RINGSIZE), the buffer is full
 * If tail < head, we have wrapped around the end of the ring
 *
 * Maximum ring fill level is RINGSIZE-1
 */

/* Output buffer functions */
/* Queue data to be sent */
koalaerror buffer_queue(pdescriptor desc, const char *data, int len)
{
	int space = 0;
	int numtocopytoend = 0;
	int numtocopytohead = 0;
	int totaltocopy = 0;

	/* If the head is the same as the tail, then we want to put the data at
	 * the beginning of the ring for easier handling
	 */
	if (desc->buffer.outhead == desc->buffer.outtail)
	{
		desc->buffer.outhead = 0;
		desc->buffer.outtail = len < OUTRINGSIZE ? len : OUTRINGSIZE;
D 5
		strncpy(desc->buffer.outring, data, desc->buffer.outtail - 1);
E 5
I 5
		strncpy(desc->buffer.outring, data, desc->buffer.outtail);
E 5
		return KESUCCESS;
	}

	/* determine how much space is available in the ring */
	if ((desc->buffer.outtail < desc->buffer.outhead))
	{
		space = desc->buffer.outhead - desc->buffer.outtail;
		totaltocopy = len < space ? len : space;
		numtocopytoend = totaltocopy;
		numtocopytohead = 0;
	}
	else
	{
		space = OUTRINGSIZE - desc->buffer.outtail + desc->buffer.outhead;
		totaltocopy = len < space ? len : space;
		if ((OUTRINGSIZE - desc->buffer.outtail) < totaltocopy)
		{
			numtocopytoend = OUTRINGSIZE - desc->buffer.outtail;
			numtocopytohead = totaltocopy - numtocopytoend;
		}
		else
		{
			numtocopytoend = totaltocopy;
			numtocopytohead = 0;
		}
	}

	if (numtocopytoend)
	{
		strncpy(desc->buffer.outring + desc->buffer.outtail, data,
				numtocopytoend);
		desc->buffer.outtail += numtocopytoend;
	}
	if (numtocopytohead)
	{
		strncpy(desc->buffer.outring, data, numtocopytohead);
		desc->buffer.outtail = numtocopytohead;
	}

	return KESUCCESS;
}

/* Write data out to descriptor */
koalaerror buffer_sendbytes(pdescriptor desc, int len)
{
	int numtosend = 0;
	int fromhead = 0;
	int fromtail = 0;
	int buffered = 0;

	/* If the buffer is empty, do a quick return */
	if (desc->buffer.outhead == desc->buffer.outtail)
		return KESUCCESS;

	/* figure out how much is in the buffer to be sent */
	if (desc->buffer.outtail > desc->buffer.outhead)
	{
		buffered = desc->buffer.outtail - desc->buffer.outhead;
		numtosend = buffered > len ? len : buffered;
		fromhead = numtosend;
		fromtail = 0;
	}
	else
	{
		buffered = OUTRINGSIZE - desc->buffer.outtail + desc->buffer.outhead;
		numtosend = buffered > len ? len : buffered;
		fromhead = OUTRINGSIZE - desc->buffer.outhead;
		if (fromhead >= numtosend)
		{
			fromhead = numtosend;
			fromtail = 0;
		}
		else
		{
			fromtail = numtosend - fromhead;
		}
	}
	
	/* Send data out to socket */
	if (fromhead)
	{
		netwrite(desc, desc->buffer.outring + desc->buffer.outhead, fromhead);
	}
	if (fromtail)
	{
		netwrite(desc, desc->buffer.outring, fromtail);
	}

	/* Update the position pointers */
	if (numtosend >= buffered) /* should never be greater then, but just in
								  case */
	{
		/* If we just sent all the data in the buffer, we can just set the
		 * position to 0
		 */
		desc->buffer.outhead = desc->buffer.outtail = 0;
	}
	else
	{
		if (fromtail) /* Buffer is currently wrapped */
		{
			desc->buffer.outhead = fromtail;
		}
		else
		{
			desc->buffer.outhead += numtosend;
		}
	}

	return KESUCCESS;
}

I 6
/* Is the out buffer empty? */
inline bool buffer_outbufempty(pdescriptor desc)
{
	return (desc->buffer.outhead == desc->buffer.outtail);
}

E 6
/* Input buffer functions */
/* Read data from socket to input buffer */
koalaerror buffer_receive(pdescriptor desc)
{
D 5
	return KEUNIMPLEMENTED;
E 5
I 5
	unsigned int numread;
	int space = 0;
	int numtocopytoend = 0;
	int numtocopytohead = 0;
	int totaltocopy = 0;

	/* If the head is the same as the tail, then we want to put the data at
	 * the beginning of the ring for easier handling
	 */
	if (desc->buffer.inhead == desc->buffer.intail)
	{
		space = INRINGSIZE - 1;
		numtocopytoend = space;
		numtocopytohead = 0;
I 9
		desc->buffer.inhead = desc->buffer.intail = 0;
E 9
	}
	/* determine how much space is available in the ring */
	else if (desc->buffer.intail < desc->buffer.inhead)
	{
		space = desc->buffer.inhead - desc->buffer.intail;
		numtocopytoend = space;
		numtocopytohead = 0;
	}
	else
	{
		space = INRINGSIZE - desc->buffer.intail + desc->buffer.inhead;
		totaltocopy = space;
		if ((INRINGSIZE - desc->buffer.intail) < totaltocopy)
		{
			numtocopytoend = INRINGSIZE - desc->buffer.intail;
			numtocopytohead = totaltocopy - numtocopytoend;
		}
		else
		{
			numtocopytoend = totaltocopy;
			numtocopytohead = 0;
		}
	}
	/* Read as much data as possible from the descriptor */
	if (numtocopytoend)
	{
		numread = numtocopytoend;
		netread(desc, desc->buffer.inring + desc->buffer.intail, &numread);
D 7
		desc->buffer.intail += numread;
E 7
I 7
		desc->buffer.intail += (numread - 1);
E 7
		if (numread < numtocopytoend)
		{
			/* We have already read everything that is available, return now
			 * to prevent blocking */
			return KESUCCESS;
		}
	}
	if (numtocopytohead)
	{
		numread = numtocopytohead;
		netread(desc, desc->buffer.inring, &numread);
D 7
		desc->buffer.intail = numread;
E 7
I 7
		desc->buffer.intail = numread - 1;
E 7
	}

	return KESUCCESS;
E 5
}

/* Read a number of bytes from buffer */
D 7
koalaerror buffer_readbytes(pdescriptor desc, char *buf, int len, bool exact)
E 7
I 7
koalaerror buffer_readbytes(pdescriptor desc, char *buf, int *len, bool exact)
E 7
{
I 7
	int buffered = 0;
	int fromhead = 0;
	int fromtail = 0;

	if (desc->buffer.inhead == desc->buffer.intail)
	{
		*len = 0;
		return KENOTENOUGH;
	}

	/* Figure out how much data is in the buffer */
	if (desc->buffer.inhead > desc->buffer.intail)
	{
		/* Buffer is wrapped */
		buffered = INRINGSIZE - desc->buffer.inhead + desc->buffer.intail;
	}
	else
	{
		/* Buffer is not wrapped */
		buffered = desc->buffer.intail - desc->buffer.inhead;
	}

	/* Do we have enough data? */
	if (exact && buffered < *len)
	{
		*len = 0;
		return KENOTENOUGH;
	}

	/* Figure out how much data to copy from each half of the buffer */
	if (*len > buffered)
	{
		*len = buffered;
	}
	
	if (*len + desc->buffer.inhead > INRINGSIZE)
	{
		/* We have to handle buffer wrapping */
		fromtail = INRINGSIZE - desc->buffer.inhead;
		fromhead = *len - fromtail;
	}
	else
	{
		/* We won't wrap the buffer during byte grabbing, only need to deal
		 * with fromtail
		 */
		fromtail = *len;
	}

	/* Copy data into the buffer */
	if (fromtail)
	{
D 13
		strncpy(buf, desc->buffer.inring + desc->buffer.inhead, *len);
E 13
I 13
		memcpy(buf, desc->buffer.inring + desc->buffer.inhead, *len);
E 13
		desc->buffer.inhead += *len;
	}
	if (fromhead)
	{
D 13
		strncpy(buf, desc->buffer.inring, *len);
E 13
I 13
		memcpy(buf, desc->buffer.inring, *len);
E 13
		desc->buffer.inhead = *len - 1;
	}

E 7
D 12
	return KEUNIMPLEMENTED;
E 12
I 12
	return KESUCCESS;
E 12
}

/* Read single char from buffer */
char buffer_readchar(pdescriptor desc)
{
D 5
	return KEUNIMPLEMENTED;
E 5
I 5
D 7
	return desc->buffer.inring[desc->buffer.inhead++];
E 7
I 7
	char c = '\0';

	if (desc->buffer.inhead == desc->buffer.intail)
	{
		return '\0';
	}

	c = desc->buffer.inring[desc->buffer.inhead];
	desc->buffer.inhead++;
	if (desc->buffer.inhead >= INRINGSIZE - 1)
	{
		desc->buffer.inhead = 0;
	}

	return c;
E 7
E 5
}

/* Read a single word delimited by whitespace from the buffer */
I 10
/* special note:  if the first non-whitespace is not alphanumeric, we end the
 * word on the first alphanumeric */
E 10
koalaerror buffer_readword(pdescriptor desc, char *word, int maxlen)
{
D 8
	return KEUNIMPLEMENTED;
E 8
I 8
	/* For now search the buffer ourselves.  It may be possible to adopt
	 * strsep to do the work, but the semantics for wraping the buffer are
	 * currently unclear */

	char *position = desc->buffer.inring + desc->buffer.inhead;
	char *cpy = word; 
	int num = 0;
	bool wordstarted = FALSE;
I 10
	bool special = FALSE;
E 10

	/* If the buffer is empty */
	if (desc->buffer.inhead == desc->buffer.intail)
	{
		return KENOTENOUGH;
	}

	while (TRUE)
	{
		/* Make sure we havn't ran out of buffer space */
		if (desc->buffer.inhead == desc->buffer.intail)
		{
			if (!wordstarted)
			{
				/* We emptied the buffer without reaching the start of a word,
				 * Report that we didn't have enough buffer */
				return KENOTENOUGH;
			}
			else
			{
				/* We emptied the buffer without reaching an end char */
				/* This could mean that the rest of the word is still pending on
				 * the network or we have the entire word with no termination.
				 * In either case, we report it as a success */
				return KESUCCESS;
			}
		}

		/* If we havn't started the word yet */
		if (!wordstarted)
		{
			if (isgraph(*position))
			{
				wordstarted = TRUE;
I 10
				if (!isalnum(*position))
				{
					special = TRUE;
				}
E 10
			}
			else
			{
				position++;
				desc->buffer.inhead++;
				if (desc->buffer.inhead > INRINGSIZE)
				{
					desc->buffer.inhead = 0;
					position = desc->buffer.inring;
				}
				continue;
			}
		}

		/* Is the current character white space? */
		if (isspace(*position))
I 10
		{
			/* We must have reached the end of the word, null terminate it and
			 * return success */
			*cpy = '\0';
I 11
			/* Skip the terminating space */
			desc->buffer.inhead++;
			if (desc->buffer.inhead > INRINGSIZE)
			{
				desc->buffer.inhead = 0;
				position = desc->buffer.inring;
			}
E 11
			return KESUCCESS;
		}

		/* If this is a special word and we have an alphanumeric, end the word
		 */
		if (special && isalnum(*position))
E 10
		{
			/* We must have reached the end of the word, null terminate it and
			 * return success */
			*cpy = '\0';
			return KESUCCESS;
		}

		if ((num + 1) == maxlen)
		{
			/* We ran out of buffer space for the word.  Caller can allocate
			 * more memory and call us again while pointing to the null
			 * terminator to finish getting the word
			 */
			*cpy = '\0';
			return KENOMEM;
		}

		/* If we get to this point, we want to copy the current character and
		 * increment our position */
		*cpy++ = *position++;
		num++;
		desc->buffer.inhead++;
		if (desc->buffer.inhead > INRINGSIZE)
		{
			desc->buffer.inhead = 0;
			position = desc->buffer.inring;
		}
	}

	return KESUCCESS;
E 8
}

/* Read one line from the buffer terminated by \r or \n */
koalaerror buffer_readline(pdescriptor desc, char *line, int maxlen)
{
D 8
	return KEUNIMPLEMENTED;
E 8
I 8
	/* For now search the buffer ourselves.  It may be possible to adopt
	 * strsep to do the work, but the semantics for wraping the buffer are
	 * currently unclear */

	char *position = desc->buffer.inring + desc->buffer.inhead;
	char *cpy = line; 
	int num = 0;

	/* If the buffer is empty */
	if (desc->buffer.inhead == desc->buffer.intail)
	{
		return KENOTENOUGH;
	}

	/* When copying a line, we copy everything, including leading white space
	 */
	while (TRUE)
	{
		/* Make sure we havn't ran out of buffer space */
		if (desc->buffer.inhead == desc->buffer.intail)
		{
			/* We emptied the buffer without reaching an end char */
			/* This could mean that the rest of the line is still pending on
			 * the network or we have the entire line with no termination.
			 * In either case, we report it as a success */
			return KESUCCESS;
		}

		/* Is the current character white space? */
		if (*position == '\r' || *position == '\n')
		{
			/* Purge the pairing character as well, if it exists */
D 9
			/* FIXME */
E 9
I 9
			if (*position == '\r' && (*(position + 1) == '\n'))
			{
				desc->buffer.inhead++;
				if (desc->buffer.inhead >= INRINGSIZE)
				{
					desc->buffer.inhead = 0;
				}
			}
			if (*position == '\n' && (*(position + 1) == '\r'))
			{
				desc->buffer.inhead++;
				if (desc->buffer.inhead >= INRINGSIZE)
				{
					desc->buffer.inhead = 0;
				}
			}
E 9

			/* We must have reached the end of the line, null terminate it and
			 * return success */
			*cpy = '\0';
			return KESUCCESS;
		}

D 14
		if ((num + 1) == maxlen)
E 14
I 14
		if (num == maxlen)
E 14
		{
			/* We ran out of buffer space for the line.  Caller can allocate
			 * more memory and call us again while pointing to the null
			 * terminator to finish getting the line
I 14
			 * Don't null terminate this (testing)
E 14
			 */
D 14
			*cpy = '\0';
E 14
I 14
			//*cpy = '\0';
E 14
			return KENOMEM;
		}

		/* If we get to this point, we want to copy the current character and
		 * increment our position */
		*cpy++ = *position++;
		num++;
		desc->buffer.inhead++;
		if (desc->buffer.inhead > INRINGSIZE)
		{
			desc->buffer.inhead = 0;
			position = desc->buffer.inring;
		}
	}

	return KESUCCESS;
}

/* Flush remainder of current line from the input buffer */
koalaerror buffer_flushline(pdescriptor desc)
{
	/* For now search the buffer ourselves.  It may be possible to adopt
	 * strsep to do the work, but the semantics for wraping the buffer are
	 * currently unclear */

	char *position = desc->buffer.inring + desc->buffer.inhead;

	/* If the buffer is empty */
	if (desc->buffer.inhead == desc->buffer.intail)
	{
		return KESUCCESS;
	}

	/* When copying a line, we copy everything, including leading white space
	 */
	while (TRUE)
	{
		/* Make sure we havn't ran out of buffer space */
		if (desc->buffer.inhead == desc->buffer.intail)
		{
			/* If we are out of buffer space, we are definatly at the end of
			 * the current line */
			return KESUCCESS;
		}

		/* Is the current character a cr or lf? */
		if (*position == '\r' || *position == '\n')
		{
			/* Purge the pairing character as well, if it exists */
D 9
			/* FIXME */
E 9
I 9
			if (*position == '\r' && (*(position + 1) == '\n'))
			{
				desc->buffer.inhead++;
				if (desc->buffer.inhead >= INRINGSIZE)
				{
					desc->buffer.inhead = 0;
				}
			}
			if (*position == '\n' && (*(position + 1) == '\r'))
			{
				desc->buffer.inhead++;
				if (desc->buffer.inhead >= INRINGSIZE)
				{
					desc->buffer.inhead = 0;
				}
			}
E 9

			/* We reached the end of the line, return */
			return KESUCCESS;
		}

		/* Once we get here, we know that we are on a character of the line,
		 * hop past it */
		position++;
		desc->buffer.inhead++;
		if (desc->buffer.inhead > INRINGSIZE)
		{
			desc->buffer.inhead = 0;
			position = desc->buffer.inring;
		}
	}

	return KESUCCESS;
I 17
}

/* Verify that we have a full line of input buffered */
bool buffer_isalinein(pdescriptor desc)
{
	char *pos;
	int count = 0;
	int buffered;
	bool wrapped = FALSE;

	/* Verify descriptor to be safe */
	if (!desc)
	{
D 19
		logerr("Bad descriptor caught");
E 19
I 19
		logmsg(LOGERR, "Bad descriptor caught");
E 19
		return FALSE;
	}

	/* Point the start of the buffer */
	pos = desc->buffer.inring + desc->buffer.inhead;

	/* Ammount buffered */
	buffered = desc->buffer.inhead < desc->buffer.intail ?
			desc->buffer.intail - desc->buffer.inhead :
			INRINGSIZE - (desc->buffer.inhead - desc->buffer.intail);

	/* If the buffer is empty */
	if (desc->buffer.inhead == desc->buffer.intail)
	{
		return FALSE;
	}

	 /* Look for the end of a line
	 */
	while (count < buffered)
	{
		/* Is the current character a cr or lf? */
		if (*pos == '\r' || *pos == '\n')
		{
			/* We have an EOL character */
			return TRUE;
		}

		/* Once we get here, we know that we are on a character of the line,
		 * hop past it */
		pos++;
		count++;
		if (desc->buffer.inhead + count > INRINGSIZE && !wrapped)
		{
			pos = desc->buffer.inring;
			wrapped = TRUE;
		}
	}

	return FALSE;
E 17
E 8
}
E 4
D 3

E 3
E 2
I 1
E 1
