/* @(#) info.c 1.16 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: COMMANDS
\***************************************************************/

#define _KOALAMUD_COMMANDINFO_C "@(#) nitehawk@winghove.1ststep.net|lib/basecommand/info.c|20001105050815|21094 @(#)"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "network.h"
#include "buffer.h"
#include "commands.h"
#include "memory.h"
#include "llist.h"
#include "module.h"
#include "kparser.h"

/* Command list - Send a list of commands to player */
koalaerror do_commandlist(pdescriptor desc, argument *arglist[])
{
	char buf[256];
	pcommandentry cur = ctablehead;

	/* Queue Header */
	snprintf(buf, 256, "Available Commands:\r\n");
	buffer_queue(desc, buf, strlen(buf));

	/* We are going to dynamically create a list of commands - currently
	 * without usage information */
	while (cur)
	{
		snprintf(buf, 256, " %s\r\n", cur->command);
		buffer_queue(desc, buf, strlen(buf));
		cur = cur->next;
	}
	
	/* Just build a list of commands and queue it */
	return KESUCCESS;
}

/* We make a lot of assumptions in this command:
 * 	All player descriptors in the master list have the character memory
 *	 	allocated
 *	We have been passed a valid descriptor
 */
koalaerror do_who(pdescriptor desc, argument *arglist[])
{
	char buf[120];
	listnodeptr tmplist;
	pdescriptor tmpdesc;
	int numprinted = 0;

	/* Get a pointer to the master descriptor list */
	tmplist = getdescriptorlist();

	/* Send the header */
	snprintf(buf, 120, "The following players are in the realm on your"
			" server:\r\n");
	buffer_queue(desc, buf, strlen(buf));

	/* Loop through the descriptor list */
	while (tmplist)
	{
		tmpdesc = tmplist->data.desc;

		/* Filter on descriptor type */
		if (tmpdesc->type != DESCRIPTOR_PLAYER)
		{
			tmplist = listnextnode(tmplist);
			continue;
		}

		/* Send the name on the current descriptor */
		memset(buf, ' ', 40);
		snprintf(buf, 30, "%s", tmpdesc->data.character->name);
		buffer_queue(desc, buf, 30);

		/* increment numprinted */
		numprinted++;

		/* Print the separator */
		if ((numprinted % 2) == 0)
		{
			buffer_queue(desc, "\r\n", 2);
		}
		else
		{
			buffer_queue(desc, "\t", 1);
		}

		/* Advance to the next node */
		tmplist = listnextnode(tmplist);
	}

	/* Print out a summary line */
	snprintf(buf, 120, "\r\nThere are %d players connected.\r\n", numprinted);
	buffer_queue(desc, buf, strlen(buf));

	return KESUCCESS;
}

/* Version command - Send version string to player */
koalaerror do_version(pdescriptor desc, argument *arglist[])
{
	/* Easy one :) */
	buffer_queue(desc, COPYRIGHTSTR, strlen(COPYRIGHTSTR));
	return KESUCCESS;
}

