/* @(#) control.c 1.18 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: COMMANDS
\***************************************************************/

#define _KOALAMUD_COMMANDINFO_C "@(#) nitehawk@paranor.1ststep.net|lib/basecommand/control.c|20001105192643|10446 @(#)"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "network.h"
#include "buffer.h"
#include "commands.h"
#include "uplinkprotocol.h"
#include "memory.h"
#include "llist.h"
#include "module.h"
#include "kparser.h"

/* Quit Command */
koalaerror do_quit(pdescriptor desc, argument *arglist[])
{
	char *quitmsg = "Thank you for trying KoalaMud\r\n";

	buffer_queue(desc, quitmsg, strlen(quitmsg));
	/* Make sure the buffer is emptied */
	buffer_sendbytes(desc, OUTRINGSIZE);

	desc->status = STATUS_CLOSE;

	return KESUCCESS;
}

/* Reboot command */
/* FIXME: we should accept a timer and wait until that time to send the
 * shutdown message to the appropriate node or set the shutdown flag
 */
koalaerror do_reboot(pdescriptor desc, argument *arglist[])
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;
	int timer = 0;
	unsigned int destnode = 0;
	message_data msgdat;
	listnodeptr tmplist;
	pdescriptor tmpdesc;

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
		line = kmalloc(len, ALLOC_TEMP);
		if (!line)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
			kmfree(line, ALLOC_TEMP);
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* We now have up to 10 arguments. argv[0] is the timer, argv[1] is the
	 * destination node to shutdown */
	if (argc == 0)
	{
		// No arguments, just shutdown current node right now
		kstate.running = DSTATE_REBOOT;
		kmfree(line, ALLOC_TEMP);
		return KESUCCESS;
	}
	else if (argc == 1)
	{
		destnode = (unsigned int)strtoul(argv[0], NULL, 10);
	}
	else if (argc >= 2)
	{
		timer = atoi(argv[0]);
		destnode = (unsigned int)strtoul(argv[1], NULL, 10);
	}

	if (destnode != 0)
	{
		tmplist = getdescriptorlist();
		for (;tmplist; tmplist = listnextnode(tmplist))
		{
			tmpdesc = tmplist->data.desc;
			
			if (tmpdesc->type == DESCRIPTOR_HUBSRV ||
					tmpdesc->type == DESCRIPTOR_ZONESRV ||
					tmpdesc->type == DESCRIPTOR_CLIENTSRV)
			{
				msgdat.data = NULL;
				uplinksendmessage(tmpdesc, destnode, MSGTYPE_REBOOT, &msgdat,
						0);
				kmfree(line, ALLOC_TEMP);
				return KESUCCESS;
			}
		}
	}

	/* We don't handle the timer yet */
	kstate.running = DSTATE_REBOOT;
	kmfree(line, ALLOC_TEMP);

	return KESUCCESS;
}

/* Shutdown command */
/* FIXME: we should accept a timer and wait until that time to send the
 * shutdown message to the appropriate node or set the shutdown flag
 */
koalaerror do_shutdown(pdescriptor desc, argument *arglist[])
{
	char **ap, *argv[10], *line;
	int len = 120;
	koalaerror readerr;
	int argc = 0;
	int timer = 0;
	unsigned int destnode = 0;
	message_data msgdat;
	listnodeptr tmplist;
	pdescriptor tmpdesc;

	/* Read the rest of the line from the buffer */
	{
		/* Allocate memory */
		line = kmalloc(len, ALLOC_TEMP);
		if (!line)
		{
			logmsg(LOGCRIT, "Unable to allocate memory for line buffer");
			return KENOMEM;
		}

		/* Read data from the buffer */
		readerr = buffer_readline(desc, line, len);
		if (readerr == KENOTENOUGH)
		{
			kmfree(line, ALLOC_TEMP);
			return KENOTENOUGH;
		}
		if (readerr == KENOMEM)
		{
			buffer_flushline(desc);
		}
		
		/* Separate the input into words */
		for (ap = argv; (*ap = strsep(&line, " \t")) != NULL;)
		{
			if (**ap != '\0')
			{
				if (++ap >= &argv[10])
				{
					break;
				}
				++argc;
			}
		}
	}

	/* We now have up to 10 arguments. argv[0] is the timer, argv[1] is the
	 * destination node to shutdown */

	if (argc >= 2)
	{
		timer = atoi(argv[0]);
		destnode = (unsigned int)strtoul(argv[1], NULL, 10);
	}
	else if (argc == 1)
	{
		destnode = (unsigned int)strtoul(argv[0], NULL, 10);
	}
	else if (argc == 0)
	{
		// No arguments, just shutdown current node right now
		kstate.running = DSTATE_SHUTDOWN;
		kmfree(line, ALLOC_TEMP);
		return KESUCCESS;
	}

	if (destnode != 0)
	{
		tmplist = getdescriptorlist();
		for (;tmplist; tmplist = listnextnode(tmplist))
		{
			tmpdesc = tmplist->data.desc;
			
			if (tmpdesc->type == DESCRIPTOR_HUBSRV ||
					tmpdesc->type == DESCRIPTOR_ZONESRV ||
					tmpdesc->type == DESCRIPTOR_CLIENTSRV)
			{
				msgdat.data = NULL;
				uplinksendmessage(tmpdesc, destnode, MSGTYPE_SHUTDOWN, &msgdat,
						0);
				kmfree(line, ALLOC_TEMP);
				return KESUCCESS;
			}
		}
	}

	/* We don't handle the timer yet */
	kstate.running = DSTATE_SHUTDOWN;
	kmfree(line, ALLOC_TEMP);

	return KESUCCESS;
}

/* Display memory status */
koalaerror do_memstat(pdescriptor desc, argument *arglist[])
{
	char buf[120];

	snprintf(buf, 120, "Current memory allocation (note, only the object
		counts are accurate.  The bytes remaining are\r\n
		not currently tracked precisely)\r\n");
	buffer_queue(desc, buf, strlen(buf));

	snprintf(buf, 120, "Generic memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_GENERIC].allocsize,
			memstate[ALLOC_GENERIC].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf, 120, "Database memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_DATABASE].allocsize,
			memstate[ALLOC_DATABASE].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf,120, "Descriptor memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_DESCRIPTOR].allocsize,
			memstate[ALLOC_DESCRIPTOR].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf, 120, "Temporary memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_TEMP].allocsize,
			memstate[ALLOC_TEMP].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf,120,"Linked List memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_LLIST].allocsize,
			memstate[ALLOC_LLIST].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf,120,"Command Table memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_CMDTABLE].allocsize,
			memstate[ALLOC_CMDTABLE].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	snprintf(buf,120,"String memory allocated: %d bytes in %d objects\r\n",
			memstate[ALLOC_STRING].allocsize,
			memstate[ALLOC_STRING].numobjects);
	buffer_queue(desc, buf, strlen(buf));
	return KESUCCESS;
}
