/* @(#) uplinkprotocol.h 1.11 @(#) */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*
*	Module: Daemon
\***************************************************************/

#ifndef _KOALAMUD_UPLINKPROTOCOL_H
#define _KOALAMUD_UPLINKPROTOCOL_H "@(#) nitehawk@winghove.1ststep.net|include/uplinkprotocol.h|20000307194808|55976 @(#)"

#include "koalatypes.h"

/* Special node IDs */
#define NODEID_UNSPEC		0
#define NODEID_UNKNOWN		0
#define NODEID_GLOBAL		1
/* Send a message to all servers of the specific class */
#define NODEID_ALLHUB		DESCRIPTOR_HUBSRV
#define NODEID_ALLZONE		DESCRIPTOR_ZONESRV
#define NODEID_ALLCLIENT	DESCRIPTOR_CLIENTSRV

/* Types */
/* Valid Message Types */
typedef enum {
	MSGTYPE_XML = 1,	// Use 'message_xml' structure for message data
	MSGTYPE_IDENT,		// Identify ourselves to the remote uplink
	MSGTYPE_GLOBAL_MSG,	// Request that a message be sent to every player
						// currently logged onto a specific server or the
						// network
	MSGTYPE_DISCONNECT, // Tell the connected server to disconnect the uplink
						// no message struct needed
	MSGTYPE_SHUTDOWN,	// Tell the target server to shutdown and exit - No
						// message struct needed
	MSGTYPE_REBOOT,		// Tell the target server to reboot - No
						// message struct needed
} msgtype;

/* Structures for individual message type */
/* NOTE:  This structure cannot be directly sent across the link, length must
 * be sent first, then the data */
typedef struct TAG_MESSAGE_XML
{
	unsigned short xmllen;
	char *xmlmessageptr;  // Pointer to the message
} message_xml;

/* This structure is used to identify a server to the remote uplink
 * 	Remote should respond with the same with the 'yournodeid' field filled in */
typedef struct TAG_MESSAGE_IDENT
{
	unsigned int mynodeid;
	unsigned int yournodeid;
} message_ident;

/* This structure used for sending global messages */
#define MAXGLOBALMSGSIZE	80
typedef struct TAG_MESSAGE_GLOBAL_MSG
{
	unsigned int minlevel;	// Minimim level required to see the message
	char msgtxt[MAXGLOBALMSGSIZE];  // This should only be the message untouched
} message_global_msg;

/* This structure is simply used as a storage container for passing message
 * data to and from the descriptor
 */
typedef union TAG_MESSAGE_DATA
{
	message_xml *msgxml;
	message_ident *msgident;
	message_global_msg *msgglobalmsg;
	void *data;
} message_data;

/* Prototypes */
koalaerror uplinknegotiatestage(pdescriptor desc);
koalaerror uplinksendmessage(pdescriptor desc, unsigned int dest, msgtype type,
		message_data *msgstruct, unsigned int msgid);
koalaerror uplinkreadmessage(pdescriptor desc, uplinkmsg_header *header,
		message_data *msgstruct);
koalaerror uplinkhandlemessage(pdescriptor desc, uplinkmsg_header *header,
		message_data *msgstruct);
koalaerror uplinkreceivemessage(pdescriptor desc);
koalaerror uplinkroutemessage(pdescriptor desc);

#endif
