h20321
s 00000/00000/00254
d D 1.8 00/03/07 11:48:03 nitehawk 9 8
c Turn on SCCS flag
cC
cK38498
cX0xa1
e
s 00000/00000/00254
d D 1.7 00/03/06 22:42:10 nitehawk 8 7
c Delete: lib/vm/dbfsmount.c
cK56515
cPBitKeeper/deleted/.del-dbfsmount.c
e
s 00000/00000/00254
d D 1.6 00/03/06 18:41:44 nitehawk 7 6
c Rename: lib/db/dbfsmount.c -> lib/vm/dbfsmount.c
cK32531
cPlib/vm/dbfsmount.c
e
s 00020/00014/00234
d D 1.5 00/02/24 18:30:40 nitehawk 6 5
c Convert memory calls to use wrapper functions
cC
cK30600
e
s 00086/00002/00162
d D 1.4 00/02/22 19:08:22 nitehawk 5 4
c Finish up dbfsmount for mounting root filesystem - Still need
c to add allocation size tracking and handling for non-root
c mounts
cC
cK63343
e
s 00113/00004/00051
d D 1.3 00/02/20 21:50:18 nitehawk 4 3
c Root filesystem mounting mostly complete - still need to load
c superblock mapping and read root directory into memory
cC
cK08952
e
s 00001/00001/00054
d D 1.2 00/02/19 17:54:56 nitehawk 3 2
c Move lib specific include files
cK44697
e
s 00055/00000/00000
d D 1.1 00/02/17 18:48:20 nitehawk 2 1
cC
cF1
cK44339
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/02/17 18:48:20 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/lib/db/dbfsmount.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK10670
cPlib/db/dbfsmount.c
cRe2efa310d02920d0
cV2
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: DB
\***************************************************************/

#define _KOALAMUD_DBFSMOUNT_C "%Z% %K% %Z%"

#include "autoconf.h"
#include <sys/stat.h>

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "conf.h"
D 3
#include "dbinternal.h"
E 3
I 3
#include "lib/dbinternal.h"
E 3
#include "db.h"
I 6
#include "memory.h"
E 6

/* This file contains mount and unmount routines.  Mounting the root file
 * system has the effect of creating a new database if one does not already
 * exist.  Mounting the root filesystem also does state initialization.
 */

/* Database code state */
dbstate_t dbstate =
{
	BLOCKSIZE,	/* If dbinitstate never gets called to get the real page size
				 *	we still have a reasonable default */
I 4
	NULL,		/* mountlist starts off null */
	NULL,		/* root vnode is null until we mount '/' */
E 4
D 5
	NULL		/* To start off, there is no memory state. */
E 5
I 5
	NULL,		/* To start off, there is no memory state. */
	0,			/* No mappings to start */
D 6
	0,			/* no mallocs to start */
E 6
E 5
};

/* Initialize database state */
void dbinitstate(void)
{
	dbstate.pagesize = getpagesize();
}

/* Mount a database filesystem.
 *
 * 	A mountpoint of NULL has the special meaning that we are mounting the root
 *		database.
 */
D 4
koalaerror dbfsmount(char *devicepath, char *mountpoint)
E 4
I 4
koalaerror dbfsmount(char *devicepath, char *mountpoint, int mountflags)
E 4
{
I 4
	int openflags;
	pmountstat newmount;
I 5
	bool mountingroot=FALSE;
E 5

E 4
	/* First we initialize state */
	dbinitstate();

D 4
	/* For now, stub this to create a new database */
	dbinitdb(devicepath);
E 4
I 4
	/* Figure out what we flags we need to use while opening the database file
	 */
	if (mountflags == MF_NORMAL)
	{
		openflags = O_RDWR;
	}

	/* We need to allocate a new mountstat structure */
D 6
	if ((newmount = malloc(sizeof(mountstat))) == NULL)
E 6
I 6
	if ((newmount = kmalloc(sizeof(mountstat), ALLOC_DATABASE)) == NULL)
E 6
	{
		logerr("Unable to allocate memory for mount struct.");
		return KENOMEM;
	}

	/* First try to open the database file */
	while ((newmount->dbfd = open(devicepath, openflags)) == -1)
	{
		switch(errno)
		{
			case ENOTDIR:
			case ENAMETOOLONG:
I 6
				kmfree(newmount, ALLOC_DATABASE);
E 6
				logerr("Invalid database path");
				return KEFOPEN;
			case EACCES:
				if (openflags == O_RDWR)
				{
					logerr("Unable to mount read/write - retrying read only");
					openflags = O_RDONLY;
				}
				else
				{
I 6
					kmfree(newmount, ALLOC_DATABASE);
E 6
					logerr("Permissions failure - check permissions on file");
					return KEFOPEN;
				}
				break;

			case EISDIR:
I 6
				kmfree(newmount, ALLOC_DATABASE);
E 6
				logerr("Must specify file, not directory for database");
				return KEFOPEN;
			case EROFS:
I 6
				kmfree(newmount, ALLOC_DATABASE);
E 6
				logerr("Disk filesystem mounted read only");
				return KEFOPEN;
			case ELOOP:
I 6
				kmfree(newmount, ALLOC_DATABASE);
E 6
				logerr("Symbolic link limit reached");
				return KEFOPEN;
			case ENXIO:
I 6
				kmfree(newmount, ALLOC_DATABASE);
E 6
				logerr("Device does not exist");
				return KEFOPEN;
			default:
				dbinitdb(devicepath);
		}
	}

	/* At this point, we should have an open database file */
	/* Copy state data into the mount stat */
D 6
	newmount->devicepath = malloc(strlen(devicepath));
E 6
I 6
	newmount->devicepath = kmalloc(strlen(devicepath), ALLOC_DATABASE);
E 6
	strcpy(newmount->devicepath, devicepath);

	/* Mount path is special - If it is null, we are mounting the root
	 * filesystem and there cannot be any existing mounts */
D 5
	if (mountpoint == NULL)
E 5
I 5
	if (mountpoint == NULL || (strcmp(mountpoint, "/") == 0))
E 5
	{
I 5
		mountingroot = TRUE;

E 5
		/* If root is already mounted... */
		if (dbstate.mountlist != NULL)
		{
			logerr("Root already mounted!");
			close(newmount->dbfd);
D 6
			free(newmount->devicepath);
			free(newmount);
E 6
I 6
			kmfree(newmount->devicepath, ALLOC_DATABASE);
			kmfree(newmount, ALLOC_DATABASE);
E 6
			return KEDBMOUNTERROR;
		}

		/* allocate memory for the mount path to be 0 */
D 6
		newmount->mountpath = malloc(2);
E 6
I 6
		newmount->mountpath = kmalloc(2, ALLOC_DATABASE);
E 6
		strcpy(newmount->mountpath, "/");
		newmount->next = NULL;

		/* Setup vnode and state pointers */
D 6
		if ((newmount->root = malloc(sizeof(kvnode))) == NULL)
E 6
I 6
		if ((newmount->root = kmalloc(sizeof(kvnode), ALLOC_DATABASE)) == NULL)
E 6
		{
			logerr("Unable to allocate root vnode");
			close(newmount->dbfd);
D 6
			free(newmount->devicepath);
			free(newmount->mountpath);
			free(newmount);
E 6
I 6
			kmfree(newmount->devicepath, ALLOC_DATABASE);
			kmfree(newmount->mountpath, ALLOC_DATABASE);
			kmfree(newmount, ALLOC_DATABASE);
E 6
			return KENOMEM;
		}

		/* we now have the head of the mount list and root vnode */
		dbstate.mountlist = newmount;
		dbstate.rootvnode = newmount->root;

		/* Fixup root vnode */
		newmount->root->mount = newmount;
		newmount->root->parent = NULL;
		newmount->root->dnodenum = 0;
		newmount->root->superblock = 0;
	}
	else  // Not mounting root
	{
		/* otherwise, we need to search the directory tree to find the
		 * mountpoint and make sure it is empty */
	}

	/* At this point, we just need to read in the root directory tree.  We
	 * don't need to read the entire directory tree at this point */
I 5
	{
		//dnode *dn;
		kdb_dirent *dir;
		pkvdirent memdir;
		void *blk;

		/* Start by mapping the super block so we can find things */
		newmount->sb = mmapblockaligned(newmount->dbfd, 0, 1);
		
		/* Now that we know where the superblock is, we need to map the dnode
		 * table and block table */
		newmount->dnodetbl = mmapblockaligned(newmount->dbfd,
				newmount->sb->fs_dbno, newmount->sb->fs_dtsize);
		newmount->blktbl = mmapblockaligned(newmount->dbfd,
				newmount->sb->fs_btno, newmount->sb->fs_btsize);

		/* Read the root directory entry */
		newmount->root->dn = newmount->dnodetbl + sizeof(dnode) * DNODE_ROOT;
		blk = mmapblockaligned(newmount->dbfd, newmount->root->dn->d_db[0], 1);
		dir = blk;
		
		/* While there is a directory entry */
		while(dir->d_reclen)
		{
			/* First we need to allocate a virtual directory entry */
D 6
			if ((memdir = malloc(sizeof(kvdirent))) == NULL)
E 6
I 6
			if ((memdir = kmalloc(sizeof(kvdirent), ALLOC_DATABASE)) == NULL)
E 6
			{
				/* Out of memory.  Attempt to free the list before falling out
				 */
				memdir = newmount->root->dir;
				while (memdir)
				{
					pkvdirent tdir = memdir;
					memdir = memdir->next;

D 6
					free(tdir->name);
					free(tdir);
E 6
I 6
					kmfree(tdir->name, ALLOC_DATABASE);
					kmfree(tdir, ALLOC_DATABASE);
E 6
				}
				/* Free the rest of the memory used for this mount - state
				 * should be the same as it was at the start of this function */
				return KENOMEM;
			}  // No mem

			/* We have a new vdirent - link it in */
			memdir->next = newmount->root->dir;
			newmount->root->dir = memdir;

			/* Allocate room for the entry name and copy the name in */
D 6
			memdir->name = malloc(dir->d_namelen + 1);
E 6
I 6
			memdir->name = kmalloc(dir->d_namelen + 1, ALLOC_DATABASE);
E 6
			strcpy(memdir->name, dir->d_name);

			/* Copy the rest of the information in */
			memdir->mount = newmount;
			memdir->type = dir->d_type;
			memdir->dnodenum = dir->d_dnode;
			memdir->vn = NULL;

			/* Point special directories to the right place */
			if (strcmp(memdir->name, ".") == 0)
			{
				memdir->vn = newmount->root;
			}
			else
			if (strcmp(memdir->name, "..") == 0)
			{
				if (mountingroot)
				{
					memdir->vn = newmount->root;
				}
				else
				{
					/* Point to parent directory */
				}
			}

			/* get to the next directory entry */
			dir = (void*)dir + dir->d_reclen + 1;
		}  // While there are more directory entries
	} // Done reading root directory
E 5
E 4

D 4
	return KEUNIMPLEMENTED;
E 4
I 4
	return KESUCCESS;
E 4
}
E 2
I 1
E 1
