#include "hk_kdedriverselect.h"
#include <qlistbox.h>
#include <qnamespace.h>
#include <qpushbutton.h>
#include <qkeycode.h>
#include <kapplication.h>
#include <hk_drivermanager.h>
#include <kapplication.h>
#include <kconfig.h>



/* 
 *  Constructs a hk_kdedriverselect which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
hk_kdedriverselect::hk_kdedriverselect( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : hk_kdedriverselectbase( parent, name, modal, fl )
{
    vector<hk_string>* drv=hk_drivermanager::driverlist();
    vector<hk_string>::iterator it;
    int i=0;
    for(it=drv->begin();it!=drv->end();it++)
    {   
        connectbutton->setEnabled(true);
        driverlist->insertItem(QString::fromLocal8Bit((*it).c_str()));
        if ((*it)==hk_class::defaultdriver())
            driverlist->setCurrentItem(i);
        i++;
    }
    driverlist->installEventFilter(this);
    driverlist->setFocus();
  KConfig* c=kapp->config();
  QRect rect(0,0,500,300);
  c->setGroup("Driverselectdialog");
  QRect g;
  g=c->readRectEntry("Geometry",&rect);
  setGeometry(g);
}

/*  
 *  Destroys the object and frees any allocated resources
 */
hk_kdedriverselect::~hk_kdedriverselect()
{
    // no need to delete child widgets, Qt does it all for us
}

void hk_kdedriverselect::list_clicked()
{
   if (driverlist->currentItem()>-1) accept();
}



bool hk_kdedriverselect::eventFilter(QObject* o,QEvent* e)
{
  if (o==driverlist)
  {
     if (e->type()==QEvent::KeyPress)
     {
       QKeyEvent* k=(QKeyEvent*)(e);
       if (k->key()==Qt::Key_Return)
         {
	   accept();
	   return true;
	 }
     }
  }
  
  return hk_kdedriverselectbase::eventFilter(o,e);
}



void hk_kdedriverselect::keyPressEvent ( QKeyEvent * e )
{
  if (e->key()==Key_F1) kapp->invokeHelp();
}

void hk_kdedriverselect::accept(void)
{
KConfig* c=kapp->config();
  c->setGroup("Driverselectdialog");
  c->writeEntry("Geometry",geometry());
QDialog::accept();
}
