/***************************************************************************
                          setpagedisplay.cpp  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "setpagedisplay.moc"
#include <kstddirs.h>
#include <kmessagebox.h>
#include <kcolordialog.h>
#include <kfontdialog.h>
#include <qstyle.h>
#include <qregexp.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <kio/netaccess.h>

setPageDisplay::setPageDisplay(QWidget *parent, resource *Rsrc  ) : QVBoxLayout(parent)
{	
	QStyle& Style = QApplication::style();
	Resource = Rsrc;
	margin = Style.defaultFrameWidth();
	NewBoards = 0;
	NewChessmen = 0;
	changeTheme = FALSE;
	refreshBoard = FALSE;
	rebuildConsole = FALSE;

	TabParent = new QTabWidget( parent, "setPageDisplay" );
	initTab1();
	initTab2();
	addWidget( TabParent );
}
setPageDisplay::~setPageDisplay()
{
	delete Show_Splashscreen;
	delete Board_Orientation;
	delete GROUP_General_Graphics;
	delete Size_Max;
	delete Size_Min;
	delete Current_Theme_Size;
	delete Current_Boards;
	delete Current_Chessmen;
	delete GROUP_Boards;
	delete GROUP_Chessmen;
	delete BOX_Themes;
	delete Tab1;
	delete Tab2;
	delete TabParent;
}
///////////////////////////////////////
//
//	setPageDisplay::initTab1
//
///////////////////////////////////////
void setPageDisplay::initTab1( void )
{
	Tab1 = new QVBox( TabParent );
	Tab1->setMargin( margin );
	BOX_Themes = new QHBox( Tab1 );
	GROUP_Boards = new QGroupBox( 1,
																Qt::Vertical,
																i18n( "Board Themes" ),
																BOX_Themes );
	Current_Boards = new KComboBox ( GROUP_Boards );
	GROUP_Chessmen = new QGroupBox( 1,
																Qt::Vertical,
																i18n( "Chessman Themes" ),
																BOX_Themes );
	Current_Chessmen = new KComboBox ( GROUP_Chessmen );
	
	GROUP_Theme_Size = new QGroupBox( 3,
																Qt::Horizontal,
																i18n( "Theme Size" ),
																Tab1 );
	
	Size_Min = new QLabel( i18n( "Small" ), GROUP_Theme_Size );
	Current_Theme_Size = new QSlider ( 	0,
																			14,
																			2,
																			( Resource->ThemeSize - IMAGE_MIN ) / 8 ,
																			QSlider::Horizontal,
																			GROUP_Theme_Size );
	Size_Max = new QLabel( i18n( "Large" ), GROUP_Theme_Size );
	
	GROUP_SCID_Images = new QGroupBox( 2, Qt::Horizontal, i18n("Player Images File:"), Tab1 );
	EDIT_SCID_Images = new KLineEdit( GROUP_SCID_Images );
	EDIT_SCID_Images->setText( Resource->SCID_Image_Path );
	connect( EDIT_SCID_Images, SIGNAL( textChanged(const QString&) ), this, SLOT( slot_SCID_Images(const QString&) ) );
	BUTTON_SCID_Images = new QPushButton( GROUP_SCID_Images );
	BUTTON_SCID_Images->setPixmap( Resource->LoadIcon( QString( "fileopen" ), KIcon::Toolbar ) );
	connect( BUTTON_SCID_Images, SIGNAL( clicked() ), this, SLOT( slot_SCID_Images_Button() ) );

	GROUP_General_Graphics = new QGroupBox( 4,
																Qt::Vertical,
																i18n( "Other Display Options" ),
																Tab1 );

	Board_Orientation = new QCheckBox( i18n( "Reverse Board Orientation" ), GROUP_General_Graphics );
	Board_Orientation->setChecked( Resource->OPTION_Board_Orientation );
	connect(	Board_Orientation, SIGNAL( toggled(bool) ),
						this, SLOT( slotToggle_Board_Orientation(bool) ) );

	Show_Splashscreen = new QCheckBox( i18n( "Display Startup Logo" ), GROUP_General_Graphics );
	Show_Splashscreen->setChecked( Resource->OPTION_Show_Splash );
	connect(	Show_Splashscreen, SIGNAL( toggled(bool) ),
						this, SLOT( slotToggle_Splashscreen(bool) ) );

	Auto_Preview = new QCheckBox( i18n( "Automatic Preview" ), GROUP_General_Graphics );
	Auto_Preview->setChecked( Resource->OPTION_Auto_Preview );
	connect(	Auto_Preview, SIGNAL( toggled(bool) ),
						this, SLOT( slotToggle_Auto_Preview(bool) ) );

	Show_Last_Move = new QCheckBox( i18n( "Show Last Move" ), GROUP_General_Graphics );
	Show_Last_Move->setChecked( Resource->OPTION_Show_Last_Move );
	connect(	Show_Last_Move, SIGNAL( toggled(bool) ),
						this, SLOT( slotToggle_Show_Last_Move(bool) ) );

	Animate_Move = new QCheckBox( i18n( "Animate Moves" ), GROUP_General_Graphics );
	Animate_Move->setChecked( Resource->OPTION_Animate_Moves );
	connect(	Animate_Move, SIGNAL( toggled(bool) ),
						this, SLOT( slotToggle_Animate_Move(bool) ) );

	Show_Coord = new QCheckBox( i18n( "Show Coordinates" ), GROUP_General_Graphics );
	Show_Coord->setChecked( Resource->OPTION_Show_Coord );
	connect(	Show_Coord, SIGNAL( toggled(bool) ),
						this, SLOT( slotToggle_Show_Coord(bool) ) );

	Current_Theme_Size->setTickmarks( QSlider::Below );
	Current_Boards->setEditable( FALSE );
	Current_Chessmen->setEditable( FALSE );
	buildThemeList();
	connect(	Current_Boards, SIGNAL( activated(int) ),
						this, SLOT( slotCurrent_Boards(int) ) );
	connect(	Current_Chessmen, SIGNAL( activated(int) ),
						this, SLOT( slotCurrent_Chessmen(int) ) );
	connect(	Current_Theme_Size, SIGNAL( valueChanged(int) ),
						this, SLOT( slotCurrent_Theme_Size(int) ) );
	TabParent->addTab( Tab1, i18n("General") );
}
///////////////////////////////////////
//
//	setPageDisplay::initTab2
//
///////////////////////////////////////
void setPageDisplay::initTab2( void )
{
	QPixmap ColorsIcon( Resource->LoadIcon( QString("colorize"), KIcon::Toolbar ) );
	Tab2 = new QFrame( TabParent );
	Tab2->setMargin( margin );

	GRID_Style = new QGridLayout( Tab2, 11, 5, margin );

		Console_Sample = new QTextView( Tab2 );
		Console_Sample->setTextFormat( Qt::RichText );
		GRID_Style->addMultiCellWidget( Console_Sample, 5, 10, 1, 1 );

		Default_Button = new QPushButton( i18n("Restore Defaults"), Tab2 );
		connect( Default_Button, SIGNAL( clicked() ), this, SLOT( slot_setDefault() ) );
		GRID_Style->addWidget( Default_Button, 11, 1 );

		Fonts_Button_Standard = new QPushButton( i18n("Standard Font..."), Tab2 );
		connect( Fonts_Button_Standard, SIGNAL( clicked() ), this, SLOT( slot_Font_Standard() ) );
		GRID_Style->addWidget( Fonts_Button_Standard, 5, 3 );

		Colors_Button_Standard = new QPushButton( Tab2 );
		Colors_Button_Standard->setPixmap( ColorsIcon );
		connect( Colors_Button_Standard, SIGNAL( clicked() ), this, SLOT( slot_Color_Standard() ) );
		GRID_Style->addWidget( Colors_Button_Standard, 5, 5 );

		Fonts_Button_PrivateTell = new QPushButton( i18n("Private Font..."), Tab2 );
		connect( Fonts_Button_PrivateTell, SIGNAL( clicked() ), this, SLOT( slot_Font_PrivateTell() ) );
		GRID_Style->addWidget( Fonts_Button_PrivateTell, 6, 3 );

		Colors_Button_PrivateTell = new QPushButton( Tab2 );
		Colors_Button_PrivateTell->setPixmap( ColorsIcon );
		connect( Colors_Button_PrivateTell, SIGNAL( clicked() ), this, SLOT( slot_Color_PrivateTell() ) );
		GRID_Style->addWidget( Colors_Button_PrivateTell, 6, 5 );

		Fonts_Button_ChannelTell = new QPushButton( i18n("Channel Font..."), Tab2 );
		connect( Fonts_Button_ChannelTell, SIGNAL( clicked() ), this, SLOT( slot_Font_ChannelTell() ) );
		GRID_Style->addWidget( Fonts_Button_ChannelTell, 7, 3 );

		Colors_Button_ChannelTell = new QPushButton( Tab2 );
		Colors_Button_ChannelTell->setPixmap( ColorsIcon );
		connect( Colors_Button_ChannelTell, SIGNAL( clicked() ), this, SLOT( slot_Color_ChannelTell() ) );
		GRID_Style->addWidget( Colors_Button_ChannelTell, 7, 5 );

		Fonts_Button_Shout = new QPushButton( i18n("Shout Font..."), Tab2 );
		connect( Fonts_Button_Shout, SIGNAL( clicked() ), this, SLOT( slot_Font_Shout() ) );
		GRID_Style->addWidget( Fonts_Button_Shout, 8, 3 );

		Colors_Button_Shout = new QPushButton( Tab2 );
		Colors_Button_Shout->setPixmap( ColorsIcon );
		connect( Colors_Button_Shout, SIGNAL( clicked() ), this, SLOT( slot_Color_Shout() ) );
		GRID_Style->addWidget( Colors_Button_Shout, 8, 5 );

		Fonts_Button_Whisper = new QPushButton( i18n("Whisper Font..."), Tab2 );
		connect( Fonts_Button_Whisper, SIGNAL( clicked() ), this, SLOT( slot_Font_Whisper() ) );
		GRID_Style->addWidget( Fonts_Button_Whisper, 9, 3 );

		Colors_Button_Whisper = new QPushButton( Tab2 );
		Colors_Button_Whisper->setPixmap( ColorsIcon );
		connect( Colors_Button_Whisper, SIGNAL( clicked() ), this, SLOT( slot_Color_Whisper() ) );
		GRID_Style->addWidget( Colors_Button_Whisper, 9, 5 );

		Fonts_Button_Notification = new QPushButton( i18n("Notification Font..."), Tab2 );
		connect( Fonts_Button_Notification, SIGNAL( clicked() ), this, SLOT( slot_Font_Notification() ) );
		GRID_Style->addWidget( Fonts_Button_Notification, 10, 3 );

		Colors_Button_Notification = new QPushButton( Tab2 );
		Colors_Button_Notification->setPixmap( ColorsIcon );
		connect( Colors_Button_Notification, SIGNAL( clicked() ), this, SLOT( slot_Color_Notification() ) );
		GRID_Style->addWidget( Colors_Button_Notification, 10, 5 );

		Colors_Button_Background = new QPushButton( Tab2 );
		Colors_Button_Background->setPixmap( ColorsIcon );
		connect( Colors_Button_Background, SIGNAL( clicked() ), this, SLOT( slot_Color_Background() ) );
		GRID_Style->addWidget( Colors_Button_Background, 11, 5 );

	resetSampleConsole();
	TabParent->addTab( Tab2, i18n("Console") );
}
///////////////////////////////////////
//
//	setPageDisplay::slot_setDefault
//
///////////////////////////////////////
void setPageDisplay::slot_setDefault(void)
{
	Resource->FONT_Standard = KGlobalSettings::fixedFont();
	Resource->FONT_PrivateTell = KGlobalSettings::fixedFont();
	Resource->FONT_ChannelTell = KGlobalSettings::fixedFont();
	Resource->FONT_Shout = KGlobalSettings::fixedFont();
	Resource->FONT_Whisper = KGlobalSettings::fixedFont();
	Resource->FONT_Notification = KGlobalSettings::fixedFont();
	Resource->COLOR_Background = Resource->COLOR_White;
	Resource->COLOR_Standard = Resource->COLOR_Black;
	Resource->COLOR_PrivateTell = QColor( 128, 0, 128 );	// Purple
	Resource->COLOR_ChannelTell = QColor( 0, 0, 160 );	// Blue
	Resource->COLOR_Shout = QColor( 160, 0, 0 );	// Red
	Resource->COLOR_Whisper = QColor( 0, 160, 0 );	// Green
	Resource->COLOR_Notification = QColor( 0, 128, 128 );	// Cyan
	resetSampleConsole();
	rebuildConsole = TRUE;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageDisplay::slot_Font_?????
//
///////////////////////////////////////
void setPageDisplay::slot_Font_Standard(void)
{
	int value = KFontDialog::getFont( Resource->FONT_Standard );
	if( value != KFontDialog::Accepted ) return;
	resetSampleConsole();
	rebuildConsole = TRUE;
	emit enableApply();
}
void setPageDisplay::slot_Font_PrivateTell(void)
{
	int value = KFontDialog::getFont( Resource->FONT_PrivateTell );
	if( value != KFontDialog::Accepted ) return;
	resetSampleConsole();
	rebuildConsole = TRUE;
	emit enableApply();
}
void setPageDisplay::slot_Font_ChannelTell(void)
{
	int value = KFontDialog::getFont( Resource->FONT_ChannelTell );
	if( value != KFontDialog::Accepted ) return;
	resetSampleConsole();
	rebuildConsole = TRUE;
	emit enableApply();
}
void setPageDisplay::slot_Font_Shout(void)
{
	int value = KFontDialog::getFont( Resource->FONT_Shout );
	if( value != KFontDialog::Accepted ) return;
	resetSampleConsole();
	rebuildConsole = TRUE;
	emit enableApply();
}
void setPageDisplay::slot_Font_Whisper(void)
{
	int value = KFontDialog::getFont( Resource->FONT_Whisper );
	if( value != KFontDialog::Accepted ) return;
	resetSampleConsole();
	rebuildConsole = TRUE;
	emit enableApply();
}
void setPageDisplay::slot_Font_Notification(void)
{
	int value = KFontDialog::getFont( Resource->FONT_Notification );
	if( value != KFontDialog::Accepted ) return;
	resetSampleConsole();
	rebuildConsole = TRUE;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageDisplay::slot_Color_?????
//
///////////////////////////////////////
void setPageDisplay::slot_Color_Background(void)
{
	int value = KColorDialog::getColor( Resource->COLOR_Background );
	if( value != KColorDialog::Accepted ) return;
	resetSampleConsole();
	rebuildConsole = TRUE;
	emit enableApply();
}
void setPageDisplay::slot_Color_Standard(void)
{
	int value = KColorDialog::getColor( Resource->COLOR_Standard );
	if( value != KColorDialog::Accepted ) return;
	resetSampleConsole();
	rebuildConsole = TRUE;
	emit enableApply();
}
void setPageDisplay::slot_Color_PrivateTell(void)
{
	int value = KColorDialog::getColor( Resource->COLOR_PrivateTell );
	if( value != KColorDialog::Accepted ) return;
	resetSampleConsole();
	rebuildConsole = TRUE;
	emit enableApply();
}
void setPageDisplay::slot_Color_ChannelTell(void)
{
	int value = KColorDialog::getColor( Resource->COLOR_ChannelTell );
	if( value != KColorDialog::Accepted ) return;
	resetSampleConsole();
	rebuildConsole = TRUE;
	emit enableApply();
}
void setPageDisplay::slot_Color_Shout(void)
{
	int value = KColorDialog::getColor( Resource->COLOR_Shout );
	if( value != KColorDialog::Accepted ) return;
	resetSampleConsole();
	rebuildConsole = TRUE;
	emit enableApply();
}
void setPageDisplay::slot_Color_Whisper(void)
{
	int value = KColorDialog::getColor( Resource->COLOR_Whisper );
	if( value != KColorDialog::Accepted ) return;
	resetSampleConsole();
	rebuildConsole = TRUE;
	emit enableApply();
}
void setPageDisplay::slot_Color_Notification(void)
{
	int value = KColorDialog::getColor( Resource->COLOR_Notification );
	if( value != KColorDialog::Accepted ) return;
	resetSampleConsole();
	rebuildConsole = TRUE;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageDisplay::slotCurrent_Boards
//
///////////////////////////////////////
void setPageDisplay::slotCurrent_Boards( int Index )
{
	NewBoards = Index;
	changeTheme = TRUE;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageDisplay::slotCurrent_Chessmen
//
///////////////////////////////////////
void setPageDisplay::slotCurrent_Chessmen( int Index )
{
	NewChessmen = Index;
	changeTheme = TRUE;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageDisplay::slotCurrent_Theme_Size
//
///////////////////////////////////////
void setPageDisplay::slotCurrent_Theme_Size( int Index )
{
	Resource->ThemeSize = 32 + ( Index * 8 );
	changeTheme = TRUE;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageDisplay::slotToggle_Board_Orientation
//
///////////////////////////////////////
void setPageDisplay::slotToggle_Board_Orientation( bool state )
{
	Resource->OPTION_Board_Orientation = state;
	refreshBoard = TRUE;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageDisplay::slotToggle_Splashscreen
//
///////////////////////////////////////
void setPageDisplay::slotToggle_Splashscreen( bool state )
{
	Resource->OPTION_Show_Splash = state;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageDisplay::slotToggle_Auto_Preview
//
///////////////////////////////////////
void setPageDisplay::slotToggle_Auto_Preview( bool state )
{
	Resource->OPTION_Auto_Preview = state;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageDisplay::slotToggle_Show_Last_Move
//
///////////////////////////////////////
void setPageDisplay::slotToggle_Show_Last_Move( bool state )
{
	Resource->OPTION_Show_Last_Move = state;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageDisplay::slotToggle_Animate_Move
//
///////////////////////////////////////
void setPageDisplay::slotToggle_Animate_Move( bool state )
{
	Resource->OPTION_Animate_Moves = state;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageDisplay::slotToggle_Show_Coord
//
///////////////////////////////////////
void setPageDisplay::slotToggle_Show_Coord( bool state )
{
	Resource->OPTION_Show_Coord = state;
	refreshBoard = TRUE;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageDisplay::buildThemeList
//
///////////////////////////////////////
void setPageDisplay::buildThemeList( void )
{
	QString buffer;
	int tmp(0);

	Current_Boards->clear();
	Current_Chessmen->clear();
	Resource->readThemeDir();
	while(1)
	{
		buffer = Resource->getBoard( tmp );
		if( buffer.isEmpty() ) break;
		buffer.remove( 0, 2 );
		buffer.replace( QRegExp("_"), " " );
		buffer.replace( QRegExp(".tar"), "" );
		buffer.replace( QRegExp(".gz"), "" );
		buffer.replace( QRegExp(".bz2"), "" );
		Current_Boards->insertItem( buffer, tmp );
		if( Resource->getBoard() == Resource->getBoard( tmp ) )
		{
			Current_Boards->setCurrentItem( tmp );
			NewBoards = tmp;
		}
		tmp++;
	}
	/* ...and for Chessmen */
	tmp = 0;
	while(1)
	{
		buffer = Resource->getChessmen( tmp );
		if( buffer.isEmpty() ) break;
		buffer.remove( 0, 2 );
		buffer.replace( QRegExp("_"), " " );
		buffer.replace( QRegExp(".tar"), "" );
		buffer.replace( QRegExp(".gz"), "" );
		buffer.replace( QRegExp(".bz2"), "" );
		Current_Chessmen->insertItem( buffer, tmp );
		if( Resource->getChessmen() == Resource->getChessmen( tmp ) )
		{
			Current_Chessmen->setCurrentItem( tmp );
			NewChessmen = tmp;
		}
		tmp++;
	}
}
///////////////////////////////////////
//
//	setPageDisplay::resetSampleConsole
//
///////////////////////////////////////
void setPageDisplay::resetSampleConsole( void )
{
	Resource->buildStyle();
	Console_Sample->setPaper( QBrush( Resource->COLOR_Background ) );
	Console_Sample->setText( QString( "<K_STD>" + i18n( "Standard" ) + "</K_STD>\n" ) );
	Console_Sample->append( QString( "<K_PVT>" + i18n( "Private Tell" ) + "</K_PVT>\n" ) );
	Console_Sample->append( QString( "<K_CH>" + i18n( "Channel Tell" ) + "</K_CH>\n" ) );
	Console_Sample->append( QString( "<K_SHT>" + i18n( "Shout" ) + "</K_SHT>\n" ) );
	Console_Sample->append( QString( "<K_WSP>" + i18n( "Whisper" ) + "</K_WSP>\n" ) );
	Console_Sample->append( QString( "<K_NOT>" + i18n( "Notification" ) + "</K_NOT>" ) );
}
///////////////////////////////////////
//
//	setPageDisplay::slot_SCID_Images
//
///////////////////////////////////////
void setPageDisplay::slot_SCID_Images( const QString& string )
{
	Resource->SCID_Image_Path = string;
	emit enableApply();
}
///////////////////////////////////////
//
//	setPageDisplay::slot_SCID_Images_Button
//
///////////////////////////////////////
void setPageDisplay::slot_SCID_Images_Button( void )
{
	QString temp;

	temp = KFileDialog::getOpenFileName(	QString::null,
																				QString( "*" ),
																				Tab1,
																				i18n( "Find Player Images File..." ) );
	if( temp.isEmpty() ) return;
	EDIT_SCID_Images->setText( temp );
	Resource->SCID_Image_Path = temp;
	emit enableApply();
}


