
/***************************************************************************
 *                                                                         *
 *   KNetLoad is copyright (c) 1999-2000, Markus Gustavsson                *
 *                         (c) 2002, Ben Burton                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "devicedialog.h"

#include <kcombobox.h>
#include <klocale.h>
#include <qlabel.h>
#include <qhbox.h>

#ifdef Q_OS_LINUX
#include <qdir.h>
#include <cstdio>
#include <cstdlib>
#include <cstring>
#endif

#define MAX_NET_DEV_LINE 512

DeviceDialog::DeviceDialog(const QString& defaultDevice, QWidget* parent) :
        KDialogBase(parent, "device dialog", true,
        i18n("Select Network Device"), Ok|Cancel, Ok),
        device(defaultDevice) {
    QHBox* page = makeHBoxMainWidget();

    new QLabel(i18n("Network device to monitor:"), page);

    // Items in the combo box are not wrapped with i18n() since they're
    // literal interface names.
    KComboBox* deviceBox = new KComboBox(true, page);
    
#ifndef Q_OS_LINUX
    deviceBox->insertItem("lo");
    deviceBox->insertItem("eth0");
    deviceBox->insertItem("ippp0");
    deviceBox->insertItem("ppp0");
#else
    if ( QDir::root().exists("/sys/class/net") )
    { // Exists /sys, 2.6 series kernel
        QDir sys("/sys/class/net");
        QStringList l = sys.entryList();
        for(QStringList::iterator it = l.begin(); it != l.end(); it++)
        {
            if ( (*it)[0] == '.' )
                continue;
            deviceBox->insertItem( *it );
        }
    } else { // Doesn't exists, kernel 2.4 or earlier
        static FILE* fd;
        static char line[MAX_NET_DEV_LINE];
        static char* pos;
        static char* iface;

    
        if ((fd = fopen("/proc/net/dev", "r")) == 0)
            return;

        // Read the unwanted header lines.
        fgets(line, MAX_NET_DEV_LINE, fd);
        fgets(line, MAX_NET_DEV_LINE, fd);

        // Read through the remaining lines until we find all devices
        while (! feof(fd)) {
            fgets(line, MAX_NET_DEV_LINE, fd);

            // Find the interface name for this line.
            for (iface = line; *iface == ' '; iface++)
                ; // (skip initial spaces)
            for (pos = iface; *pos != ':' && *pos != 0; pos++)
                ; // (move to next ':' or end of string)
            if (*pos == 0)
                continue; // (was not ':')
            *pos = 0;

            // Now iface points to a null-terminated string containing the
            // interface name for this particular line.
            deviceBox->insertItem( iface );
        }
        fclose(fd);
    }
#endif
    deviceBox->setCurrentText(defaultDevice);

    connect(deviceBox, SIGNAL(textChanged(const QString&)),
        this, SLOT(updateDevice(const QString&)));
}

const QString& DeviceDialog::getDevice() const {
    return device;
}

void DeviceDialog::updateDevice(const QString& text) {
    device = text;
}

#include "devicedialog.moc"
