/***************************************************************************
                          awards.h  -  description
                             -------------------
    begin                : mar ago 27 2002
    copyright            : (C) 2002 by Jaime Robles
    email                : jaime@robles.nu
 ***************************************************************************/
/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
*  it under the terms of the GNU General Public License as published by     *
*  the Free Software Foundation; either version 2 of the License, or        *
*  (at your option) any later version.                                      *
 *                                                                            *
*  This program is distributed in the hope that it will be useful,          *
*  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the            *
*  GNU General Public License for more details.                             *
 *                                                                            *
*  You should have received a copy of the GNU General Public License        *
*  along with this program; if not, write to the Free Software              *
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA*
 *****************************************************************************/
#ifndef GLOBAL_DATA
#define GLOBAL_DATA
const int ENTITIES = 341;
const int ZONES = 40+1;
const int BANDS = 17;
const int MODES = 30;
#endif

#ifndef AWARDS_H
#define AWARDS_H
 
#define COUNTRIES 340
#define BANDS 9
#define MODES 5

#include <klocale.h>
#include "adif.h"

//ENTITIES 340
// BANDS 9 {2/6/10/12/15/17/20/30/40/80/160}
//MODES 11 {SSB/CW/FM/PSK31/SSTV/RTTY/TOR/PKT/
//          AM/ATV/PAC/CLO

class Awards  {

public:

  Awards();


  ~Award();

  void clear();
  void worked(const QString& tqrz, const int tband, const int tmode);
  void workedString(const QString& tqrz, const QString& tband, const QString& tmode);
  void notWorkedEntity(const int tentity, const int tband, const int tmode);
  void notWorkedEntityString(const int tentity, const QString& tband, const QString& tmode);
  bool isEntityWorked(const int tentity);
  bool isEntityWorkedBand (const int tentity, const int tband);
  bool isEntityWorkedMode (const int tentity, const int tmode);
  int howManyEntityWorkedBand(const int tband);
  int howManyEntityWorkedMode(const int tmode);
  int howManyEntityWorked();


  void confirmedEntity(const int tentity, const int band, const int tmode);
  bool isEntityConfirmed(const int tentity);
  bool isEntityConfirmedBand (const int tentity, const int tband);
  bool isEntityConfirmedMode (const int tentity, const int tmode);
  void confirmedString(const int tentity, const QString& tband, const QString& tmode);
  int howManyConfirmedBand(const int tband);
  int howManyConfirmedMode(const int tmode);
  void notConfirmed(const int tentity, const int tband, const int tmode);
  void notConfirmedString(const int tentity, const QString& tband, const QString& tmode);  
  int howManyConfirmed();
  
private:
  Adif adif;
  int dxccCountConfirmed; // How many DXCC confirmed
  int dxccCountWorked; // How many DXCC worked

  int i, j, k; // just index
  int dxccb[ENTITIES][BANDS]; // -1 Not worked, 0 = worked, 1 = confirmed
  int dxccm[ENTITIES][MODES]; // -1 Not worked, 0 = worked, 1 = confirmed
  bool dxccW[ENTITIES];
  bool dxccC[ENTITIES];  
  QString sAux;
  bool aux;
  int iAux;

};

#endif








#endif
