<xsl:stylesheet version = '1.0'
  xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:template name="date_get_month_name">
  <xsl:param name="month"/>
  <xsl:variable name="m_str" select="concat('january  ', 'february ',
    'march    ', 'april    ', 'may      ', 'june     ', 'july     ',
    'august   ', 'september', 'october  ', 'november ', 'december ')"/>
     
  <xsl:value-of select="normalize-space (substring($m_str, ($month - 1) * 9, 9))"/>
</xsl:template>


<xsl:template name="date_get_month_len">
  <xsl:param name="month"/>
  <xsl:param name="year"/>
  <!-- if leap => 28->29  -->

  <xsl:variable name="months" select="concat('31', '28', '31', '30',
    '31', '30', '31', '31', '30', '31', '30', '31')"/>

  <xsl:choose>
    <xsl:when test="$month = '2'">
      <xsl:variable name="leap">
        <xsl:call-template name="leapYear">
          <xsl:with-param name="year" select="$year"/>
        </xsl:call-template>
      </xsl:variable>
    
      <xsl:choose>
        <xsl:when test="$leap = true()">
          <xsl:value-of select="29"/>
        </xsl:when>        
        <xsl:otherwise>
          <xsl:value-of select="28"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
        
    <xsl:otherwise>
      <xsl:value-of select="substring($months, 1 + ($month - 1) * 2, 2)"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="leapYear">
    <xsl:param name="year"/>
    <xsl:if test="$year mod 4 = 0">
      <xsl:if test="$year mod 100 = 0">
        <xsl:if test="$year mod 400 = 0">
          <xsl:value-of select="true()"/>
        </xsl:if>
        <xsl:value-of select="false()"/>
      </xsl:if>
      <xsl:value-of select="true()"/>
    </xsl:if>
</xsl:template>

<xsl:template name="date_days_in_months">
  <xsl:param name="month"/>
  <xsl:param name="leap"/>

  <xsl:if test="not($leap = '0' or $leap = '1')">
    <xsl:message terminate="yes">
      Invalid value passed to date_days_in_months -template
    </xsl:message>
  </xsl:if>

  <xsl:variable name="k">
    <xsl:choose>
      <xsl:when test="$month &gt; 1">
        <xsl:text>1</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>0</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <xsl:variable name="months" select="concat('031', '059', '090',
   '120', '151', '181', '212', '243', '273', '304', '334', '365')"/>

  <xsl:value-of select="number(substring($months, 1 + ($month - 1) * 3, 3))
    + number($k)"/>
</xsl:template>


<xsl:template name="date_format">
<xsl:param name="date"/>

  <xsl:value-of select='concat(
                        substring($date,9,2), ".",
                        substring($date,6,2), ".",
                        substring($date,1,4))'/> 
 
  <xsl:text> W(</xsl:text>
  <xsl:call-template name="date_weeknum">
    <xsl:with-param name="d" select="substring($date,9,2)"/>
    <xsl:with-param name="m" select="substring($date,6,2)"/>
    <xsl:with-param name="y" select="substring($date,1,4)"/>
  </xsl:call-template>
  <xsl:text>)</xsl:text>
</xsl:template>


<xsl:template name="date_weeknum">
  <xsl:param name="d"/>
  <xsl:param name="m"/>
  <xsl:param name="y"/>
  <xsl:variable name="n1">
    <xsl:call-template name="date_julian">
      <xsl:with-param name="d" select="$d"/>
      <xsl:with-param name="m" select="$m"/>
      <xsl:with-param name="y" select="$y"/>
    </xsl:call-template>   
  </xsl:variable>
  <xsl:variable name="n2" select="7 * (floor(number($n1) div 7)) + 10"/>
  <xsl:variable name="w">
    <xsl:call-template name="date_recurse_for_week">
      <xsl:with-param name="y" select="$y + 1"/>
      <xsl:with-param name="n2" select="$n2"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:value-of select="$w"/>
</xsl:template>

<xsl:template name="date_recurse_for_week">
  <xsl:param name="y"/>
  <xsl:param name="n2"/>
  <xsl:variable name="tmp">
    <xsl:call-template name="date_julian">
      <xsl:with-param name="d" select="1"/>
      <xsl:with-param name="m" select="1"/>
      <xsl:with-param name="y" select="$y"/>
    </xsl:call-template>   
  </xsl:variable>
  <xsl:variable name="w" select="floor(($n2 - $tmp) div 7)"/>
  <xsl:choose>
    <xsl:when test="$w &lt;= 0">
      <xsl:call-template name="date_recurse_for_week">
        <xsl:with-param name="d" select="1"/>
        <xsl:with-param name="m" select="1"/>
        <xsl:with-param name="y" select="$y - 1"/>
        <xsl:with-param name="n2" select="$n2"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$w"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="date_julian">
  <xsl:param name="d"/>
  <xsl:param name="m"/>
  <xsl:param name="y"/>
  <xsl:variable name="n1" select="number(12 * number($y) + number($m) - 3)"/>
  <xsl:variable name="n2" select="floor(number($n1) div 12)"/>
  <xsl:value-of select="floor((734 * $n1 + 15) div 24) - 2 * $n2 +
                        floor($n2 div 4) - floor($n2 div 100)
                      + floor($n2 div 400) + $d + 1721119"/>
</xsl:template>
</xsl:stylesheet>
