#!/bin/sh

usage()
{
	# Title
	echo "Title: FFMPEG DivX Export"

	# Usable?
	which ffmpeg > /dev/null
	[ $? -eq 0 ] && echo Status: Active || echo Status: Inactive

	# Type
	echo Flags: single-pass file-producer

	# Profiles
	echo "Profile: High Quality (640x480, 4200 Kbps)"
	echo "Profile: Medium Quality (320x240, 2200 Kbps)"
	echo "Profile: Broadband Quality (320x240, 564 Kbps)"
	echo "Profile: Low Quality (160x120, 15fps, 128 Kbps)"
}

execute()
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"
	file="$4"
	[ "x$file" = "x" ] && file="kino_export_"`date +%Y-%m-%d_%H.%M.%S`
	
	# Determine audio codec (MP3 if avail)
	acodec="mp2"
	mp3=0
	mp3=`ffmpeg -formats | egrep "(Encoders:)|(.*E.*mp3)" | grep mp3 | wc -l`
	[ "$mp3" -gt 0 ] && acodec="mp3"

	# Run the command
	case "$profile" in 
		"0" ) 	ffmpeg -f dv -i - -f avi -deinterlace -s 640x480 -hq -b 4096 -acodec "$acodec" -ab 192 -y "$file".avi ;;
		"1" ) 	ffmpeg -f dv -i - -f avi -deinterlace -s 320x240 -b 2048 -acodec "$acodec" -ab 128 -y "$file".avi ;;
		"2" ) 	ffmpeg -f dv -i - -f avi -deinterlace -s 320x240 -b 500 -acodec "$acodec" -ab 64 -y "$file".avi ;;
		"3" ) 	ffmpeg -f dv -i - -f avi -deinterlace -r 15 -s 160x120 -b 96 -acodec "$acodec" -ab 32 -y "$file".avi ;;
	esac
}

[ "$1" = "--usage" ] || [ -z "$1" ] && usage "$@" || execute "$@"
