/**************************************************************************
 *                                                                        *
 *  KDoomsDay - Copyright (C) 2004-2005 Helen Faulkner                    *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   * 
 *                                                                        *
 *                                                                        * 
 * Parts of this code are based on the KDE clock applet, which has the    *
 * following license:                                                     *
 *                                                                        *
 *                                                                        *    
 *  Copyright (c) 1996-2002 the kicker authors. See file KICKER-AUTHORS.  *
 *                                                                        *    
 *  Permission is hereby granted, free of charge, to any person obtaining *
 * a copy of this software and associated documentation files (the        *
 * "Software"), to deal in the Software without restriction, including    *
 * without limitation the rights to use, copy, modify, merge, publish,    * 
 * distribute, sublicense, and/or sell copies of the Software, and to     *
 * permit persons to whom the Software is furnished to do so, subject to  *
 * the following conditions:                                              *
 *                                                                        *
 * The above copyright notice and this permission notice shall be         *
 * included in all copies or substantial portions of the Software.        *
 *                                                                        * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,        *
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF     *
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. * 
 * IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR      *
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,  *
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR  *
 * OTHER DEALINGS IN THE SOFTWARE.                                        *
 *                                                                        * 
 **************************************************************************/

#ifndef KDOOMSDAY_H
#define KDOOMSDAY_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qlabel.h>
#include <kpanelapplet.h>

#include "settings.h"

class CounterWidget;

class kdoomsday : public KPanelApplet
{
    Q_OBJECT
    
public:

    kdoomsday(const QString& configFile, Type t = Normal, int actions = 0,
        QWidget *parent = 0, const char *name = 0);
    ~kdoomsday();
    
    virtual int widthForHeight(int height) const;
    virtual int heightForWidth(int width) const;

    virtual void about();
    virtual void preferences();

    KConfig *config;    
        
protected slots: 
    void slotUpdate();  

private:

    CounterWidget *counter;
    QTimer *timer;
 
};


class CounterWidget : public QLabel
{
  Q_OBJECT

public:
    CounterWidget(kdoomsday *appletIn, const char *name=0);
    
    int preferedWidthForHeight(int height) const;
    int preferedHeightForWidth(int width) const;
    
    void updateCounter();
    void loadSettings();
    
    void updateToolTip();
    
    void writeConfig();  
        
    Settings *mySettings;   
    double timeLeft;
   
private:

    kdoomsday *applet;
    
    void readConfig();
    
    // default values for settings
    QDateTime defaultDateTime;
    QFont defaultFont;
    QColor defaultFontColor;   
    QString defaultEventName;
    int defaultUnit;
    QString unitString;

};

#endif
