/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _DISSERTBASE_H
#define _DISSERTBASE_H

#include <qmap.h>

#include "DItem.h"

/**
 * This class is the necessary parent for all
 * mindmap handlers (views and data)
 *
 * @short Common handler for mindmap items
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.1
 */
class DBase
{
    public:
	/// default constructor
	DBase(QWidget* parent=0, const char* name=0);
	/// destructur
	virtual ~DBase();

	/// return the item corresponding to the id given
	DItem * Item(int) const;

	/// adding a new mindmap item must call this method to register it
	void registerItem(DItem *);

	/// deleting a mindmap item must unregister it first
	void unregisterItem(int);

	/// this method is used to check if a particular id corresponds to an existing mindmap item
	bool isRegistered(int) const;

	
	/// count of items registered
	int Total() const;

	/// debugging method, prints how items are handled
	void printallids();

	/// debugging tool, check if the mindmap items are properly handled
	virtual void checkConsistency() {}

    protected:
	/// this dictionnary holds the registered mindmap items
	QMap<int, DItem*> m_map;
};

#endif // _DISSERTBASE_H
