/***************************************************************************
                          kbeartoolsplugin.cpp  -  description
                             -------------------
    begin                : lr mar 2 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////
// Qt specific includes
#include <qcursor.h>
#include <qtimer.h>
//////////////////////////////////////////////////////
// KDE specific includes
#include <kiconloader.h>
#include <klocale.h>
#include <kdialogbase.h>
#include <kconfig.h>
#include <kapplication.h>
#include <kdesktopfile.h>
#include <ktoolbar.h>
#include <kparts/mainwindow.h>
#include <kxmlguifactory.h>
#include <kinstance.h>
#include <kgenericfactory.h>
#include <kaboutapplication.h>
#include <kdebug.h>
//////////////////////////////////////////////////////
// Application specific includes
#include "kbeartoolsplugin.h"
#include "kbeartoolswidget.h"

typedef KGenericFactory<KBearToolsPlugin> KBearToolsPluginFactory;
K_EXPORT_COMPONENT_FACTORY( libkbeartoolsplugin, KBearToolsPluginFactory( "KBearToolsPlugin" ) );
//-----------------------------------------------
KBearToolsPlugin::KBearToolsPlugin(QObject *parent, const char *name, const QStringList& )
	:	KParts::Plugin(parent,name)
{
//	setInstance ( KBearToolsPluginFactory::instance() );
	KGlobal::locale()->insertCatalogue("kbear");
	new KAction( i18n("C&onfigure Tools..."), "run" , 0,
					this, SLOT(slotConfigureToolsMenu()), actionCollection(), "options_configure_tools" );
	m_showToolbarAction = new KToggleAction( i18n("Show Toolbar"), 0, this, SLOT( slotToggleToolBar() ), actionCollection(), "tools_show_toolbar" );

	kapp->config()->setGroup("MainWindow Toolbar toolsToolBar");
	m_showToolbarAction->setChecked( ! kapp->config()->readBoolEntry( "Hidden", false ) );

	setXMLFile("kbeartoolsplugin.rc");

	QTimer::singleShot( 0, this, SLOT( updateMenu() ) );

	QTimer::singleShot( 500, this, SLOT( connectToolbar() ) );
}
//-----------------------------------------------
KBearToolsPlugin::~KBearToolsPlugin(){
	kdDebug()<<"KBearToolsPlugin::~KBearToolsPlugin()="<<this<<endl;
}
//-----------------------------------------------
void KBearToolsPlugin::connectToolbar() {
	KToolBar* toolBar = 0L;
	if( factory() )
		toolBar = static_cast<KToolBar*>(factory()->container("toolsToolBar", this));
	if( toolBar )
		connect( toolBar, SIGNAL( visibilityChanged( bool ) ), m_showToolbarAction, SLOT( setChecked( bool ) ) );
	else
		QTimer::singleShot( 100, this, SLOT( connectToolbar() ) );
}
//-----------------------------------------------
void KBearToolsPlugin::slotConfigureToolsMenu() {
	QApplication::setOverrideCursor( QCursor(Qt::WaitCursor) );
	KDialogBase dlg( 0L, "KBearToolsEditDialog", true, i18n("Edit Tools"), (KDialogBase::Ok | KDialogBase::Cancel) );
	KBearToolsWidget* w = new KBearToolsWidget( &dlg, "KBearToolsWidget" );
	dlg.setMainWidget( w );
	connect( &dlg, SIGNAL( okClicked() ), w, SLOT( saveToolsList() ) );
	connect( &dlg, SIGNAL( destroyed() ), this, SLOT( updateMenu() ) );
	QApplication::restoreOverrideCursor();
	dlg.exec();
}
//-----------------------------------------------
void KBearToolsPlugin::slotToggleToolBar() {
	KToolBar* toolBar = static_cast<KToolBar*>(factory()->container("toolsToolBar", this));
	if( m_showToolbarAction->isChecked() )
		toolBar->show();
	else
		toolBar->hide();
}
//-----------------------------------------------
void KBearToolsPlugin::updateMenu() {
	QPtrList<KAction> actions;
	unplugActionList("tools_list");

	QString oldGroup = kapp->config()->group();
	kapp->config()->setGroup("Tools");
	QStringList list = kapp->config()->readListEntry("Tools");
	for(QStringList::Iterator it = list.begin(); it != list.end(); ++it) 	{
		QString name = *it;

		KDesktopFile df(name, true);
		if(df.readName().isNull())
			continue;

		KAction *action = new KAction(df.readName(), df.readIcon(), 0,
							this, SLOT(slotToolActivated()), actionCollection(), name.latin1());
		action->setGroup( "list" );
		actions.append(action);
	}
	plugActionList("tools_list", actions);
	kapp->config()->setGroup( oldGroup );
}
//-----------------------------------------------
void KBearToolsPlugin::slotToolActivated() {
	QString df = sender()->name();
	kapp->startServiceByDesktopPath(df);
}
//-----------------------------------------------
