/***************************************************************************
                          dirsynchtreeviewitem.cpp  -  description
                             -------------------
    begin                : lr okt 19 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
#include <qdatetime.h>
#include <qpalette.h>
#include <qpainter.h>
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kfiletreebranch.h>
#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "dirsynchtreeviewitem.h"
#include "dirsynchtreeview.h"
#include "dirsynchtreebranch.h"

//-----------------------------------------------
DirSynchTreeViewItem::DirSynchTreeViewItem( KFileTreeViewItem* parent , KFileItem* item, KFileTreeBranch* brnch )
	:	KFileTreeViewItem( parent, item, brnch ),
		m_correspondingMissing( false ), m_isDifferent( false ),
		m_diffColor( 237, 190, 190 ), m_missingRemoteColor( 190, 237, 190 ),
		m_missingLocalColor( 190, 190, 237 ),
		m_missingAbove( false ), m_missingBelow( false ),
		m_selectedAbove( false ), m_selectedBelow( false ),
		m_timeDiff( 0 )
{
	setText( 1, QString("%1B").arg( (unsigned long)( fileItem()->size() ) ) /*KIO::convertSize( fileItem()->size() )*/ );
	setText( 2, /*fileItem()->*/timeString( KIO::UDS_MODIFICATION_TIME ) );
	setText( 3, fileItem()->permissionsString() );
}
//-----------------------------------------------
DirSynchTreeViewItem::DirSynchTreeViewItem( KFileTreeView* parent, KFileItem* item, KFileTreeBranch *brnch )
	:	KFileTreeViewItem( parent, item, brnch ),
		m_correspondingMissing( false ), m_isDifferent( false ),
		m_diffColor( 237, 190, 190 ), m_missingRemoteColor( 190, 237, 190 ),
		m_missingLocalColor( 190, 190, 237 ),
		m_missingAbove( false ), m_missingBelow( false ),
		m_selectedAbove( false ), m_selectedBelow( false ),
		m_timeDiff( 0 )
{
	setText( 1, KIO::convertSize( fileItem()->size() ) );
	setText( 2, /*fileItem()->*/timeString( KIO::UDS_MODIFICATION_TIME ) );
	setText( 3, fileItem()->permissionsString() );
}
//-----------------------------------------------
DirSynchTreeViewItem::~DirSynchTreeViewItem(){
}
//-----------------------------------------------
time_t DirSynchTreeViewItem::time( unsigned int which ) {
	time_t t = fileItem()->time( which );
	if( fileItem()->isLocalFile() )
		return t;

/*
	return mktime( localtime( &t ) );
*/
	return t - ( m_timeDiff * 3600 );
}
//-----------------------------------------------
QString DirSynchTreeViewItem::timeString( unsigned int which ) {
	if( fileItem()->isLocalFile() )
		return fileItem()->timeString( which );

	time_t remoteTime = time( which );
	QDateTime t;
	t.setTime_t( remoteTime );
	return KGlobal::locale()->formatDateTime( t );
}
//-----------------------------------------------
void DirSynchTreeViewItem::paintCell(QPainter *p, const QColorGroup &cg, int column, int width, int align ) {
	QColorGroup myCg = cg;
	bool selected = isSelected();
	const BackgroundMode bgmode = listView()->viewport()->backgroundMode();
	QColorGroup::ColorRole crole = selected ? QColorGroup::Highlight : QPalette::backgroundRoleFromMode( bgmode );
	QColor bg = myCg.brush( crole ).color();
	if( m_correspondingMissing ) {
		if( fileItem()->isLocalFile() )  
			bg =  selected ? m_missingRemoteColor.dark( 150 ) : m_missingRemoteColor;
		else 
			bg =  selected ? m_missingLocalColor.dark( 150 ) : m_missingLocalColor;
	}
	else if( m_isDifferent ) 
		bg =  selected ? m_diffColor.dark( 150 ) : m_diffColor;
	else if( isAlternate() ) {
		crole = QColorGroup::Base;
		bg = static_cast< KListView* >(listView())->alternateBackground();
	}

	QBrush brush = myCg.brush( crole );
	brush.setColor( bg );
	myCg.setBrush( crole, brush );
	
	QListViewItem::paintCell(p, myCg, column, width, align);

	if( m_missingAbove ) {
		QColor pCol;
		if( fileItem()->isLocalFile() )
			pCol =  m_selectedAbove ? m_missingLocalColor.dark( 150 ) : m_missingLocalColor;
		else
			pCol =  m_selectedAbove ? m_missingRemoteColor.dark( 150 ) : m_missingRemoteColor;
		p->setPen( QPen( pCol, 2 ) );
		p->drawLine( 0, 0, width, 0 );
	}
	if( m_missingBelow ) {
		QColor pCol;
		if( fileItem()->isLocalFile() )
			pCol =  m_selectedBelow ? m_missingLocalColor.dark( 150 ) : m_missingLocalColor;
		else
			pCol =  m_selectedBelow ? m_missingRemoteColor.dark( 150 ) : m_missingRemoteColor;
		p->setPen( QPen( pCol, 2 ) );
		p->drawLine( 0, height() - 2, width, height() - 2 );
	}

}
//-----------------------------------------------
void DirSynchTreeViewItem::setTimeDiff( int diff ) {
	m_timeDiff = diff;
	setText( 2, /*fileItem()->*/timeString( KIO::UDS_MODIFICATION_TIME ) );
	kdDebug()<<"DirSynchTreeViewItem::setTimeDiff diff="<<diff<<" string="<<timeString( KIO::UDS_MODIFICATION_TIME )<<endl;
}
//-----------------------------------------------
void DirSynchTreeViewItem::setColors( const QColor& diff, const QColor& mRemote, const QColor& mLocal ) {
	//kdDebug()<<"DirSynchTreeViewItem::setColors"<<endl;
	m_diffColor = diff;
	m_missingRemoteColor = mRemote;
	m_missingLocalColor = mLocal;
	repaint();
}
//-----------------------------------------------
