/***************************************************************************
                          dirsynchtreebranch.cpp  -  description
                             -------------------
    begin                : lr okt 19 2002
    copyright            : (C) 2002 by Bjrn Sahlstrm
    email                : kbjorn@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//////////////////////////////////////////////////////////////////////
// Qt specific include files
//////////////////////////////////////////////////////////////////////
// KDE specific include files
#include <kfiletreeviewitem.h>
#include <kfileitem.h>
#include <kmessagebox.h>
#include <kdebug.h>
//////////////////////////////////////////////////////////////////////
// Application specific include files
#include "dirsynchtreebranch.h"
#include "dirsynchtreeviewitem.h"
#include "kbeardirsynchpart.h"

//-----------------------------------------------
DirSynchTreeBranch::DirSynchTreeBranch( KFileTreeView* view, const KURL& url, const QString& name,
                    			const QPixmap& pix, bool showHidden )
	:	KFileTreeBranch( view, url, name, pix, showHidden ),
		m_dirLister( 0L ), m_diffColor( 237, 190, 190 ),
		m_missingRemoteColor( 190, 237, 190 ),
		m_missingLocalColor( 190, 190, 237 ),
		m_timeDiff( 0 )

{

	// this is important, the items are deleted by listview !!!!!!!!!!!!!!!
	m_pendingList.setAutoDelete( false ); // this is important
	connect( this, SIGNAL( populateFinished( KFileTreeViewItem* ) ),
				this, SLOT( slotPopulateFinished( KFileTreeViewItem* ) ) );
}
//-----------------------------------------------
DirSynchTreeBranch::~DirSynchTreeBranch(){
}
//-----------------------------------------------
KFileTreeViewItem* DirSynchTreeBranch::createTreeViewItem( KFileTreeViewItem* parent, KFileItem* fileItem ) {
	KFileTreeViewItem  *tvi = 0;

	if( parent && fileItem ) {
		tvi = new DirSynchTreeViewItem( parent, fileItem, this );
		DirSynchTreeViewItem* item = static_cast<DirSynchTreeViewItem*>( tvi );
		item->setTimeDiff( m_timeDiff );
		item->setColors( diffColor(), missingRemoteColor(), missingLocalColor() );
	}
	else {
		kdDebug() << "createTreeViewItem: Have no parent" << endl;
	}
	return( tvi );
}
//-----------------------------------------------
bool DirSynchTreeBranch::populate( const KURL& url,  KFileTreeViewItem *currItem ) {
//	kdDebug()<<"DirSynchTreeBranch::populate url="<<url.prettyURL()<<endl;
	return KFileTreeBranch::populate( url, currItem);
}
//-----------------------------------------------
bool DirSynchTreeBranch::openURL( const KURL& url,  bool keep, bool ) {
//	kdDebug()<<"DirSynchTreeBranch::openURL="<<url.prettyURL()<<endl;
	bool ret = false;
	if( ! validURL( url ) )
		return ret;
	if( m_dirLister ) {
//		emitChanges();
		m_dirLister->openURL( url, true );
		ret = true;
	}
	else {
		ret = KFileTreeBranch::openURL( url, keep, true );
	}
	return ret;
}
//-----------------------------------------------
void DirSynchTreeBranch::slotPopulateFinished( KFileTreeViewItem* currItem ) {
	currItem->setListed( true );
	KFileTreeViewItem* child = static_cast<KFileTreeViewItem*>( currItem->firstChild() );
	while( child ) {
		if( child->isDir() && ! child->alreadyListed() ) {
			KFileItem *kfi = child->fileItem();
			if( kfi && kfi->isReadable()) {
				m_pendingList.append( child );
			}
		}
	    child = static_cast<KFileTreeViewItem*>( child->nextSibling() );
	}
	if( m_pendingList.isEmpty() )
		emit finishedLoading( this );
	else {
//		kdDebug()<<"DirSynchTreeBranch::slotPopulateFinished="<<currItem->url().prettyURL()<<endl;
		// starts the listing
		m_pendingList.take()->setOpen( true );
	}

}
//-----------------------------------------------
KFileTreeViewItem* DirSynchTreeBranch::findTVIByURL( const KURL& url ) {
//	kdDebug()<<"DirSynchTreeBranch::findTVIByURL="<<url.prettyURL()<<endl;
	KFileTreeViewItem* item = KFileTreeBranch::findTVIByURL( url );
	if( ! item ) {
		QListViewItemIterator it( root() );
		for( ; it.current(); ++it ) {
			KFileTreeViewItem* item = static_cast<KFileTreeViewItem*>( it.current() );
//			kdDebug()<<"DirSynchTreeBranch::findTVIByURL item="<<item->fileItem()->url().prettyURL()<<" IN URL="<<url.prettyURL()<<endl;
			if( item->fileItem()->url().cmp( url, true ) ) {
//				kdDebug()<<"DirSynchTreeBranch::findTVIByURL FOUND !!!!!!!!!!!!!!!!!!!!!"<<item->fileItem()->url().prettyURL()<<endl;
				return item;
			}
		}
		item = 0L;
	}
	return item;
}
//-----------------------------------------------
void DirSynchTreeBranch::setDirLister( KBearDirLister* d ) {
	m_dirLister = d;
	connect( m_dirLister, SIGNAL( newItems(const KFileItemList&)),
				this, SIGNAL( newItems( const KFileItemList& )));
//	connect( m_dirLister, SIGNAL( clear()), this, SIGNAL( clear()));
	connect( m_dirLister, SIGNAL( infoMessage( const QString&)),
				this, SIGNAL( infoMessage( const QString&)));
	connect( m_dirLister, SIGNAL( redirection( const KURL& , const KURL& ) ),
				this, SIGNAL( redirection( const KURL& , const KURL& ) ) );
	connect( m_dirLister, SIGNAL( completed(const KURL& )),
				this, SIGNAL( completed(const KURL& )));
	connect( m_dirLister, SIGNAL( started(const KURL& )),
				this, SIGNAL( started(const KURL& )));
}
//-----------------------------------------------
void DirSynchTreeBranch::setTimeDiff( int diff ) {
	m_timeDiff = diff;
	if( ! root() || ! root()->listView() )
		return;

	QListViewItemIterator it( root()->firstChild() );
	for( ; it.current(); ++it ) {
		DirSynchTreeViewItem* item = static_cast<DirSynchTreeViewItem*>( it.current() );
		item->setTimeDiff( m_timeDiff );
	}
}
//-----------------------------------------------
void DirSynchTreeBranch::setColors( const QColor& diff, const QColor& mRemote, const QColor& mLocal ) {
	//kdDebug()<<"DirSynchTreeView::setColors"<<endl;
	m_diffColor = diff;
	m_missingRemoteColor = mRemote;
	m_missingLocalColor = mLocal;

	if( ! root() || ! root()->listView() )
		return;

	QListViewItemIterator it( root()->firstChild() );
	for( ; it.current(); ++it ) {
		DirSynchTreeViewItem* item = static_cast<DirSynchTreeViewItem*>( it.current() );
		item->setColors( diff, mRemote, mLocal );
	}
}
//-----------------------------------------------
